/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventorySimple
implements IInventory {
    protected ItemStack[] inventorySlots;
    protected String inventoryName;
    protected int numSlots;
    protected final String nbtKey;
    protected boolean notifyOnInventoryChanged = false;

    public InventorySimple(String inventoryName, int numSlots, String nbtKey) {
        this.inventoryName = inventoryName;
        this.numSlots = numSlots;
        this.nbtKey = nbtKey;
        this.inventorySlots = new ItemStack[numSlots];
    }

    public InventorySimple(String inventoryName, int numSlots) {
        this(inventoryName, numSlots, "ContainedItems");
    }

    public void onInventoryChanged(int slot, ItemStack prevStack) {
    }

    public int func_70302_i_() {
        return this.numSlots;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventorySlots[slot];
    }

    public ItemStack func_70298_a(int slot, int num) {
        if (this.inventorySlots[slot] != null) {
            if (this.inventorySlots[slot].field_77994_a <= num) {
                ItemStack stack = this.inventorySlots[slot];
                this.inventorySlots[slot] = null;
                this.func_70296_d();
                if (this.notifyOnInventoryChanged) {
                    this.onInventoryChanged(slot, stack.func_77946_l());
                }
                return stack;
            }
            ItemStack prev = this.notifyOnInventoryChanged ? this.inventorySlots[slot].func_77946_l() : null;
            ItemStack stack = this.inventorySlots[slot].func_77979_a(num);
            if (this.inventorySlots[slot].field_77994_a == 0) {
                this.inventorySlots[slot] = null;
            }
            this.func_70296_d();
            if (this.notifyOnInventoryChanged) {
                this.onInventoryChanged(slot, prev);
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack != this.inventorySlots[slot]) {
            ItemStack prev = this.notifyOnInventoryChanged ? this.inventorySlots[slot] : null;
            this.inventorySlots[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            if (this.notifyOnInventoryChanged) {
                this.onInventoryChanged(slot, prev);
            }
        }
    }

    public void setInventorySlotContentsSoftly(int slot, ItemStack stack) {
        this.inventorySlots[slot] = stack;
    }

    public String func_145825_b() {
        return this.inventoryName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void func_70296_d() {
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.nbtKey, 10);
        this.inventorySlots = new ItemStack[this.numSlots];
        if (nbttaglist.func_74745_c() > 0) {
            for (int i = 0; i < this.numSlots; ++i) {
                NBTTagCompound tagList = nbttaglist.func_150305_b(i);
                byte slot = tagList.func_74771_c("Slot");
                if (slot < 0 || slot >= this.numSlots || this.inventorySlots[slot] != null) continue;
                this.inventorySlots[slot] = this.loadItemStack(tagList);
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.numSlots; ++i) {
            if (this.inventorySlots[i] == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)i);
            this.writeItemStack(this.inventorySlots[i], tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a(this.nbtKey, (NBTBase)nbttaglist);
    }

    protected ItemStack loadItemStack(NBTTagCompound nbt) {
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    protected void writeItemStack(ItemStack stack, NBTTagCompound nbt) {
        stack.func_77955_b(nbt);
    }
}

