/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.api.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.api.gui.IAspectSelectorContainer;
import thaumicenergistics.api.gui.ICraftingIssuerContainer;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.api.storage.IEssentiaRepo;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.client.Packet_C_Sync;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.storage.EssentiaRepo;
import thaumicenergistics.common.utils.EffectiveSide;
import thaumicenergistics.common.utils.ThEUtils;

public abstract class ContainerEssentiaCellTerminalBase
extends ContainerWithPlayerInventory
implements IMEEssentiaMonitorReceiver,
IAspectSelectorContainer,
ICraftingIssuerContainer {
    private static final int OUTPUT_POSITION_X = 26;
    private static final int OUTPUT_POSITION_Y = 92;
    private static final int INPUT_POSITION_X = 8;
    private static final int INPUT_POSITION_Y = 92;
    private static final int PLAYER_INV_POSITION_Y = 122;
    private static final int HOTBAR_INV_POSITION_Y = 180;
    private static final int MINIMUM_SOUND_WAIT = 900;
    private static final int WORK_TICK_RATE = 3;
    private static final int ESSENTIA_TRANSFER_PER_WORK_CYCLE = 64;
    private static int OUTPUT_INV_INDEX = 1;
    private static int INPUT_INV_INDEX = 0;
    private final String soundLocation_Splash = "game.neutral.swim";
    private final String soundLocation_Paper = "thaumcraft:page";
    private int audioStackSizeTracker = 0;
    private Slot inputSlot;
    private IInventory inventory;
    private long lastSoundPlaytime = 0L;
    private Slot outputSlot;
    private Aspect selectedAspect;
    private int tickCounter = 0;
    private int workCounter = 0;
    protected final IEssentiaRepo repo;
    private IMEEssentiaMonitor essentiaMonitor;

    public ContainerEssentiaCellTerminalBase(EntityPlayer player) {
        super(player);
        if (EffectiveSide.isClientSide()) {
            this.lastSoundPlaytime = System.currentTimeMillis();
        }
        this.repo = new EssentiaRepo();
    }

    private boolean attachToMonitor(IMEEssentiaMonitor eMonitor) {
        if (EffectiveSide.isServerSide() && eMonitor != null) {
            IGrid grid = this.getHostGrid();
            if (grid == null) {
                return false;
            }
            if (this.essentiaMonitor != null) {
                this.detachFromMonitor();
            }
            this.essentiaMonitor = eMonitor;
            this.essentiaMonitor.addListener(this, grid.hashCode());
            this.repo.copyFrom(this.essentiaMonitor.getEssentiaList());
            return true;
        }
        return false;
    }

    private boolean canMergeWithOutputSlot(ItemStack stackToMerge) {
        if (stackToMerge == null) {
            return false;
        }
        if (!this.outputSlot.func_75216_d()) {
            return true;
        }
        ItemStack slotStack = this.outputSlot.func_75211_c();
        int slotStackSize = slotStack.field_77994_a;
        if (slotStack.func_77976_d() == slotStackSize) {
            return false;
        }
        if (slotStackSize + stackToMerge.field_77994_a > slotStack.func_77976_d()) {
            return false;
        }
        ItemStack o = slotStack.func_77946_l();
        ItemStack n = stackToMerge.func_77946_l();
        o.field_77994_a = 1;
        n.field_77994_a = 1;
        return ItemStack.func_77989_b((ItemStack)o, (ItemStack)n);
    }

    private boolean checkSecurityPermission(SecurityPermissions perm, BaseActionSource actionSource) {
        if (actionSource == null) {
            return false;
        }
        IGridNode sourceNode = null;
        if (actionSource instanceof MachineSource) {
            sourceNode = ((MachineSource)actionSource).via.getActionableNode();
        } else if (actionSource instanceof PlayerSource) {
            sourceNode = ((PlayerSource)actionSource).via.getActionableNode();
        }
        if (sourceNode == null) {
            return false;
        }
        ISecurityGrid sGrid = (ISecurityGrid)sourceNode.getGrid().getCache(ISecurityGrid.class);
        return sGrid.hasPermission(this.player, perm);
    }

    @Nullable
    private ImmutablePair<Integer, ItemStack> drainContainer(ItemStack container, BaseActionSource actionSource, Actionable mode) {
        if (container == null) {
            return null;
        }
        IAspectStack containerEssentia = EssentiaItemContainerHelper.INSTANCE.getAspectStackFromContainer(container);
        if (containerEssentia == null || containerEssentia.isEmpty()) {
            return null;
        }
        int proposedDrainAmount = (int)containerEssentia.getStackSize();
        long rejectedAmount = this.essentiaMonitor.injectEssentia(containerEssentia.getAspect(), proposedDrainAmount, mode, actionSource, true);
        if (rejectedAmount > 0L && (proposedDrainAmount -= (int)rejectedAmount) <= 0) {
            return null;
        }
        if (mode == Actionable.MODULATE) {
            this.workCounter += proposedDrainAmount;
        }
        return EssentiaItemContainerHelper.INSTANCE.extractFromContainer(container, proposedDrainAmount);
    }

    @Nullable
    private ImmutablePair<Integer, ItemStack> fillContainer(Aspect withAspect, ItemStack container, BaseActionSource actionSource, Actionable mode) {
        if (withAspect == null) {
            return null;
        }
        int containerCapacity = EssentiaItemContainerHelper.INSTANCE.getContainerCapacity(container);
        if (containerCapacity == 0) {
            return null;
        }
        long extractedAmount = this.essentiaMonitor.extractEssentia(withAspect, containerCapacity, mode, actionSource, true);
        if (extractedAmount <= 0L) {
            return null;
        }
        int proposedFillAmount = (int)Math.min((long)containerCapacity, extractedAmount);
        if (mode == Actionable.MODULATE) {
            this.workCounter += proposedFillAmount;
        }
        return EssentiaItemContainerHelper.INSTANCE.injectIntoContainer(container, new AspectStack(withAspect, proposedFillAmount));
    }

    protected void bindToInventory(IInventory inventory) {
        this.inventory = inventory;
        this.inputSlot = new SlotRestrictive(inventory, INPUT_INV_INDEX, 8, 92);
        this.func_75146_a(this.inputSlot);
        this.outputSlot = new SlotFurnace(this.player, inventory, OUTPUT_INV_INDEX, 26, 92);
        this.func_75146_a(this.outputSlot);
        this.bindPlayerInventory((IInventory)this.player.field_71071_by, 122, 180);
    }

    protected void detachFromMonitor() {
        if (EffectiveSide.isServerSide() && this.essentiaMonitor != null) {
            this.essentiaMonitor.removeListener(this);
            this.essentiaMonitor = null;
            this.repo.clear();
        }
    }

    @Override
    protected boolean detectAndSendChangesMP(@Nonnull EntityPlayerMP playerMP) {
        if (this.getHostSelectedAspect() != this.selectedAspect) {
            this.selectedAspect = this.getHostSelectedAspect();
            Packet_C_EssentiaCellTerminal.setSelectedAspect(this.player, this.selectedAspect);
        }
        if (this.essentiaMonitor != null) {
            ++this.tickCounter;
            if (this.tickCounter > 3) {
                this.doWork(this.tickCounter);
                this.tickCounter = 0;
                return true;
            }
        } else if (this.attachToMonitor(this.getNewMonitor())) {
            this.onClientRequestFullUpdate();
        }
        return false;
    }

    protected abstract void doWork(int var1);

    protected abstract BaseActionSource getActionSource();

    @Nullable
    protected abstract IGrid getHostGrid();

    @Nullable
    protected abstract Aspect getHostSelectedAspect();

    @Nullable
    protected abstract IMEEssentiaMonitor getNewMonitor();

    protected abstract void setHostSelectedAspect(@Nullable Aspect var1);

    protected ItemStack transferEssentia(ItemStack stack, Aspect aspect, BaseActionSource actionSource, Actionable mode) {
        if (stack == null || this.essentiaMonitor == null) {
            return stack;
        }
        EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(stack);
        if (iType == EssentiaItemContainerHelper.AspectItemType.JarLabel) {
            ItemStack label = stack.func_77946_l();
            EssentiaItemContainerHelper.INSTANCE.setLabelAspect(label, aspect);
            ++this.workCounter;
            return label;
        }
        if (iType != EssentiaItemContainerHelper.AspectItemType.EssentiaContainer) {
            return stack;
        }
        ImmutablePair<Integer, ItemStack> result = null;
        if (EssentiaItemContainerHelper.INSTANCE.isContainerEmpty(stack)) {
            if (this.checkSecurityPermission(SecurityPermissions.EXTRACT, actionSource)) {
                result = this.fillContainer(aspect, stack, actionSource, mode);
            }
        } else if (this.checkSecurityPermission(SecurityPermissions.INJECT, actionSource)) {
            result = this.drainContainer(stack, actionSource, mode);
        }
        if (result != null) {
            return (ItemStack)result.right;
        }
        return stack;
    }

    protected void transferEssentiaFromWorkSlots() {
        ItemStack result;
        ItemStack outputStack;
        if (this.inventory == null) {
            return;
        }
        ItemStack inputStack = this.inventory.func_70301_a(INPUT_INV_INDEX);
        if (inputStack == null) {
            return;
        }
        if (this.outputSlot.func_75216_d() && outputStack.field_77994_a >= (outputStack = this.outputSlot.func_75211_c()).func_77976_d()) {
            return;
        }
        this.workCounter = 0;
        BaseActionSource actionSource = this.getActionSource();
        ItemStack container = inputStack.func_77946_l();
        container.field_77994_a = 1;
        while ((result = this.transferEssentia(container, this.selectedAspect, actionSource, Actionable.SIMULATE)) != null && result != container && this.canMergeWithOutputSlot(result)) {
            result = this.transferEssentia(container, this.selectedAspect, actionSource, Actionable.MODULATE);
            if (this.outputSlot.func_75216_d()) {
                ++this.outputSlot.func_75211_c().field_77994_a;
            } else {
                this.outputSlot.func_75215_d(result);
            }
            if (--inputStack.field_77994_a == 0) {
                this.inputSlot.func_75215_d(null);
                break;
            }
            if (this.workCounter < 64) continue;
        }
    }

    public Collection<IAspectStack> getAspectStackList() {
        return this.repo.getAll();
    }

    @Override
    public abstract ICraftingIssuerHost getCraftingHost();

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Aspect getSelectedAspect() {
        return this.selectedAspect;
    }

    @Override
    public final boolean isValid(Object verificationToken) {
        IGrid grid = this.getHostGrid();
        if (grid != null && grid.hashCode() == ((Integer)verificationToken).intValue()) {
            return true;
        }
        this.essentiaMonitor = null;
        this.repo.clear();
        this.onClientRequestFullUpdate();
        return false;
    }

    public abstract void onClientRequestAutoCraft(EntityPlayer var1, Aspect var2);

    public abstract void onClientRequestFullUpdate();

    public abstract void onClientRequestSortModeChange(EntityPlayer var1, boolean var2);

    public abstract void onClientRequestViewModeChange(EntityPlayer var1, boolean var2);

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        this.detachFromMonitor();
    }

    public void onInteractWithHeldItem(EntityPlayer player, Aspect aspect) {
        if (player == null || player.field_71071_by.func_70445_o() == null) {
            return;
        }
        ItemStack sourceStack = player.field_71071_by.func_70445_o();
        ItemStack takeFrom = sourceStack.func_77946_l();
        takeFrom.field_77994_a = 1;
        BaseActionSource actionSource = this.getActionSource();
        ItemStack resultStack = this.transferEssentia(takeFrom, aspect, actionSource, Actionable.SIMULATE);
        if (resultStack == null || resultStack == takeFrom) {
            return;
        }
        if (sourceStack.field_77994_a > 1) {
            if (!this.mergeSlotWithHotbarInventory(resultStack) && !this.mergeSlotWithPlayerInventory(resultStack)) {
                return;
            }
            --sourceStack.field_77994_a;
        } else {
            sourceStack = resultStack;
        }
        this.transferEssentia(takeFrom, aspect, actionSource, Actionable.MODULATE);
        player.field_71071_by.func_70437_b(sourceStack);
        Packet_C_Sync.sendPlayerHeldItem(player, sourceStack);
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71137_h = false;
        }
        this.func_75142_b();
        this.playTransferSound(player, false, EssentiaItemContainerHelper.INSTANCE.getItemType(sourceStack) == EssentiaItemContainerHelper.AspectItemType.JarLabel ? 1 : 0);
    }

    public void onReceivedAspectList(Collection<IAspectStack> aspectStackList) {
        this.repo.copyFrom(aspectStackList);
    }

    public void onReceivedAspectListChange(IAspectStack change) {
        if (EffectiveSide.isServerSide()) {
            return;
        }
        if (change == null) {
            return;
        }
        this.repo.postChange(change);
    }

    public void onReceivedSelectedAspect(Aspect selectedAspect) {
        if (EffectiveSide.isServerSide()) {
            this.setHostSelectedAspect(selectedAspect);
        } else {
            this.selectedAspect = selectedAspect;
        }
    }

    public void playTransferSound(EntityPlayer player, boolean checkWorkSlots, int type) {
        if (checkWorkSlots) {
            ItemStack itemStack = this.outputSlot.func_75211_c();
            if (itemStack != null) {
                type = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack) == EssentiaItemContainerHelper.AspectItemType.JarLabel ? 1 : 0;
                if (this.audioStackSizeTracker == itemStack.field_77994_a) {
                    return;
                }
                this.audioStackSizeTracker = itemStack.field_77994_a;
            } else {
                this.audioStackSizeTracker = 0;
                return;
            }
        }
        if (System.currentTimeMillis() - this.lastSoundPlaytime > 900L) {
            if (type == 0) {
                ThEUtils.playClientSound(this.player, this.soundLocation_Splash);
            } else if (type == 1) {
                ThEUtils.playClientSound(this.player, this.soundLocation_Paper);
            }
            this.lastSoundPlaytime = System.currentTimeMillis();
        }
    }

    @Override
    public final void postChange(IMEEssentiaMonitor fromMonitor, Iterable<IAspectStack> changes) {
        if (changes == null) {
            return;
        }
        for (IAspectStack change : changes) {
            Packet_C_EssentiaCellTerminal.setAspectAmount(this.player, change);
        }
    }

    public void func_75141_a(int slotNumber, ItemStack stack) {
        super.func_75141_a(slotNumber, stack);
        if (this.outputSlot.field_75222_d == slotNumber && EffectiveSide.isClientSide()) {
            this.playTransferSound(null, true, 0);
        }
    }

    @Override
    public void setSelectedAspect(Aspect selectedAspect) {
        Packet_S_EssentiaCellTerminal.sendSelectedAspect(this.player, selectedAspect);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (slot == this.inputSlot || slot == this.outputSlot) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (this.inputSlot.func_75214_a(slotStack)) {
                    didMerge = this.func_75135_a(slotStack, this.inputSlot.field_75222_d, this.inputSlot.field_75222_d + 1, false);
                }
                if (!didMerge) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            }
            if (didMerge) {
                if (slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }
}

