/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class MiningUtils {
    public static int mMoonID = -99;
    public static int mMarsID = -99;
    public static int mCometsID = -99;
    public static AutoMap<GT_Worldgen_GT_Ore_Layer>[] mOreMaps = new AutoMap[7];
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Overworld = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Nether = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_End = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Moon = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Mars = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Comets = new AutoMap();
    private static AutoMap<GT_Worldgen_GT_Ore_Layer> Ores_Misc = new AutoMap();

    public static Boolean canPickaxeBlock(Block currentBlock, World currentWorld) {
        String correctTool = "";
        if (!currentWorld.field_72995_K) {
            try {
                correctTool = currentBlock.getHarvestTool(0);
                if (correctTool.equals("pickaxe")) {
                    return true;
                }
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    private static void removeBlockAndDropAsItem(World world, int X, int Y, int Z) {
        try {
            Block block = world.func_147439_a(X, Y, Z);
            if (MiningUtils.canPickaxeBlock(block, world).booleanValue()) {
                if (block != Blocks.field_150357_h && block.func_149712_f(world, X, Y, Z) != -1.0f && block.func_149712_f(world, X, Y, Z) <= 100.0f && block != Blocks.field_150355_j && block != Blocks.field_150353_l) {
                    block.func_149697_b(world, X, Y, Z, world.func_72805_g(X, Y, Z), 0);
                    world.func_147468_f(X, Y, Z);
                } else {
                    Logger.WARNING("Incorrect Tool for mining this block.");
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static boolean getBlockType(Block block, World world, int[] xyz, int miningLevel) {
        String LIQUID = "liquid";
        String BLOCK = "block";
        String ORE = "ore";
        String AIR = "air";
        String blockClass = "";
        if (world.field_72995_K) {
            return false;
        }
        if (block == Blocks.field_150377_bs) {
            return true;
        }
        if (block == Blocks.field_150348_b) {
            return true;
        }
        if (block == Blocks.field_150322_A) {
            return true;
        }
        if (block == Blocks.field_150424_aL) {
            return true;
        }
        if (block == Blocks.field_150385_bj) {
            return true;
        }
        if (block == Blocks.field_150387_bl) {
            return true;
        }
        if (block == Blocks.field_150386_bk) {
            return true;
        }
        if (block == Blocks.field_150426_aN) {
            return true;
        }
        try {
            blockClass = block.getClass().toString().toLowerCase();
            Logger.WARNING(blockClass);
            if (blockClass.toLowerCase().contains("liquid")) {
                Logger.WARNING(block.toString() + " is a Liquid.");
                return false;
            }
            if (blockClass.toLowerCase().contains("ore")) {
                Logger.WARNING(block.toString() + " is an Ore.");
                return true;
            }
            if (block.getHarvestLevel(world.func_72805_g(xyz[0], xyz[1], xyz[2])) >= miningLevel) {
                Logger.WARNING(block.toString() + " is minable.");
                return true;
            }
            if (blockClass.toLowerCase().contains("air")) {
                Logger.WARNING(block.toString() + " is Air.");
                return false;
            }
            if (blockClass.toLowerCase().contains("block")) {
                Logger.WARNING(block.toString() + " is a block of some kind.");
                return false;
            }
            Logger.WARNING(block.toString() + " is mystery.");
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static AutoMap<GT_Worldgen_GT_Ore_Layer> getOresForDim(int dim) {
        if (dim == -1) {
            return Ores_Nether;
        }
        if (dim == 1) {
            return Ores_End;
        }
        if (dim == mMoonID) {
            return Ores_Moon;
        }
        if (dim == mMarsID) {
            return Ores_Mars;
        }
        if (dim == mCometsID) {
            return Ores_Comets;
        }
        return Ores_Overworld;
    }

    public static void iterateAllOreTypes() {
        HashMap<String, Integer> M = new HashMap<String, Integer>();
        String aTextWorldGen = null;
        if (MiningUtils.findAndMapOreTypesFromGT()) {
            int mapKey = 0;
            for (AutoMap<GT_Worldgen_GT_Ore_Layer> g : mOreMaps) {
                for (GT_Worldgen_GT_Ore_Layer h : g) {
                    try {
                        aTextWorldGen = (String)ReflectionUtils.getField(GT_Worldgen_GT_Ore_Layer.class, "aTextWorldgen").get(h);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        aTextWorldGen = h.mWorldGenName;
                    }
                    M.put(aTextWorldGen + h.mWorldGenName, mapKey);
                    Logger.INFO("Found Vein type: " + aTextWorldGen + h.mWorldGenName + " in map with key: " + mapKey);
                }
                ++mapKey;
            }
        }
    }

    public static boolean findAndMapOreTypesFromGT() {
        try {
            if (ReflectionUtils.getClass("micdoodle8.mods.galacticraft.core.util.ConfigManagerCore") != null && mMoonID == -99) {
                mMoonID = ReflectionUtils.getField(ReflectionUtils.getClass("micdoodle8.mods.galacticraft.core.util.ConfigManagerCore"), "idDimensionMoon").getInt(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        try {
            if (ReflectionUtils.getClass("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars") != null && mMarsID == -99) {
                mMarsID = ReflectionUtils.getField(ReflectionUtils.getClass("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars"), "dimensionIDMars").getInt(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        try {
            if (ReflectionUtils.getClass("micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids") != null && mCometsID == -99) {
                mCometsID = ReflectionUtils.getField(ReflectionUtils.getClass("micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids"), "dimensionIDAsteroids").getInt(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        Ores_Overworld.clear();
        Ores_Nether.clear();
        Ores_End.clear();
        Ores_Misc.clear();
        for (GT_Worldgen_GT_Ore_Layer x : GT_Worldgen_GT_Ore_Layer.sList) {
            if (x.mEnabled) {
                boolean aEndAsteroids;
                try {
                    aEndAsteroids = ReflectionUtils.getField(GT_Worldgen_GT_Ore_Layer.class, "mEndAsteroid").getBoolean(x);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    aEndAsteroids = false;
                }
                if (x.mOverworld) {
                    Ores_Overworld.put(x);
                }
                if (x.mNether) {
                    Ores_Nether.put(x);
                }
                if (x.mEnd || aEndAsteroids) {
                    Ores_End.put(x);
                }
                if (x.mOverworld || x.mNether || x.mEnd || aEndAsteroids) continue;
                Ores_Misc.put(x);
                continue;
            }
            Ores_Comets.put(x);
        }
        MiningUtils.mOreMaps[0] = Ores_Overworld;
        MiningUtils.mOreMaps[1] = Ores_Nether;
        MiningUtils.mOreMaps[2] = Ores_End;
        MiningUtils.mOreMaps[3] = Ores_Moon;
        MiningUtils.mOreMaps[4] = Ores_Mars;
        MiningUtils.mOreMaps[5] = Ores_Comets;
        MiningUtils.mOreMaps[6] = Ores_Misc;
        return true;
    }
}

