/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items.behaviours;

import codechicken.lib.math.MathHelper;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.entity.projectile.EntityLightningAttack;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Behaviour_Electric_Lighter
extends Behaviour_None {
    private final String mTooltip = GT_LanguageManager.addStringLocalization((String)"gt.behaviour.lighter.tooltip", (String)"Can light things on Fire");
    private final String mTooltipUses = GT_LanguageManager.addStringLocalization((String)"gt.behaviour.lighter.uses", (String)"Remaining Uses:");
    private final String mTooltipUnstackable = GT_LanguageManager.addStringLocalization((String)"gt.behaviour.unstackable", (String)"Not usable when stacked!");

    public boolean onLeftClickEntity(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (!aPlayer.field_70170_p.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            boolean rOutput = false;
            if (aEntity instanceof EntityCreeper && (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d)) {
                GT_Utility.sendSoundToPlayers((World)aPlayer.field_70170_p, (SoundResource)SoundResource.FIRE_IGNITE, (float)1.0f, (float)1.0f, (int)MathHelper.floor_double((double)aEntity.field_70165_t), (int)MathHelper.floor_double((double)aEntity.field_70163_u), (int)MathHelper.floor_double((double)aEntity.field_70161_v));
                ((EntityCreeper)aEntity).func_146079_cb();
                rOutput = true;
            }
            return rOutput;
        }
        return false;
    }

    public boolean onItemUse(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (!aWorld.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            if (aPlayer.func_70093_af()) {
                Logger.INFO("Changing Mode");
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                Logger.INFO("Is currently in Fireball mode? " + aCurrentMode);
                boolean aNewMode = Utils.invertBoolean(aCurrentMode);
                Logger.INFO("Is now set to Fireball mode? " + aNewMode);
                aStack.func_77978_p().func_74757_a("aFireballMod", aNewMode);
                PlayerUtils.messagePlayer(aPlayer, "Current Mode: " + EnumChatFormatting.RED + (aNewMode ? "Projectile" : "Fire Starter"));
            } else {
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                if (aCurrentMode) {
                    aWorld.func_72956_a((Entity)aPlayer, "random.bow", 0.5f, 0.4f / (CORE.RANDOM.nextFloat() * 0.4f + 0.8f));
                    if (!aWorld.field_72995_K) {
                        aWorld.func_72838_d((Entity)new EntityLightningAttack(aWorld, (EntityLivingBase)aPlayer, hitX, hitY, hitZ));
                    }
                } else {
                    Logger.WARNING("Preparing Lighter a");
                    boolean rOutput = false;
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)ordinalSide);
                    if (GT_Utility.isBlockAir((World)aWorld, (int)(aX += tDirection.offsetX), (int)(aY += tDirection.offsetY), (int)(aZ += tDirection.offsetZ)) && aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
                        Logger.WARNING("Preparing Lighter b");
                        if (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d) {
                            Logger.WARNING("Preparing Lighter c");
                            GT_Utility.sendSoundToPlayers((World)aWorld, (SoundResource)SoundResource.FIRE_IGNITE, (float)1.0f, (float)1.0f, (int)aX, (int)aY, (int)aZ);
                            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                            rOutput = true;
                            return rOutput;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter z");
        return false;
    }

    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (!aWorld.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            if (aPlayer.func_70093_af()) {
                Logger.INFO("Changing Mode");
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                Logger.INFO("Is currently in Fireball mode? " + aCurrentMode);
                boolean aNewMode = Utils.invertBoolean(aCurrentMode);
                Logger.INFO("Is now set to Fireball mode? " + aNewMode);
                aStack.func_77978_p().func_74757_a("aFireballMode", aNewMode);
                PlayerUtils.messagePlayer(aPlayer, "Current Mode: " + EnumChatFormatting.RED + (aNewMode ? "Projectile" : "Fire Starter"));
            } else {
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                if (aCurrentMode) {
                    aWorld.func_72956_a((Entity)aPlayer, "random.bow", 0.5f, 0.4f / (CORE.RANDOM.nextFloat() * 0.4f + 0.8f));
                    if (!aWorld.field_72995_K) {
                        aWorld.func_72838_d((Entity)new EntityLightningAttack(aWorld, (EntityLivingBase)aPlayer, hitX, hitY, hitZ));
                    }
                } else {
                    Logger.WARNING("Preparing Lighter a");
                    boolean rOutput = false;
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)ordinalSide);
                    if (GT_Utility.isBlockAir((World)aWorld, (int)(aX += tDirection.offsetX), (int)(aY += tDirection.offsetY), (int)(aZ += tDirection.offsetZ)) && aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
                        Logger.WARNING("Preparing Lighter b");
                        if (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d) {
                            Logger.WARNING("Preparing Lighter c");
                            GT_Utility.sendSoundToPlayers((World)aWorld, (SoundResource)SoundResource.FIRE_IGNITE, (float)1.0f, (float)1.0f, (int)aX, (int)aY, (int)aZ);
                            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                            rOutput = true;
                            return rOutput;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter z");
        return false;
    }

    private boolean prepare(ItemStack aStack) {
        if (aStack != null) {
            Logger.WARNING("Preparing Lighter 1");
            if (aStack.func_77973_b() instanceof MetaGeneratedGregtechTools) {
                Logger.WARNING("Preparing Lighter 2");
                if (ChargingHelper.isItemValid(aStack)) {
                    Logger.WARNING("Preparing Lighter 3");
                    if (aStack.func_77973_b() instanceof IElectricItemManager) {
                        Logger.WARNING("Preparing Lighter 4");
                        IElectricItemManager aItemElec = (IElectricItemManager)aStack.func_77973_b();
                        double aCharge = aItemElec.getCharge(aStack);
                        long aEuCost = 8192L;
                        if (aCharge >= (double)aEuCost) {
                            Logger.WARNING("Preparing Lighter 5");
                            aItemElec.discharge(aStack, (double)aEuCost, 3, true, true, false);
                            return true;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter 0");
        return false;
    }

    private void useUp(ItemStack aStack) {
    }

    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        int aUses = 0;
        if (aStack != null && aStack.func_77973_b() instanceof MetaGeneratedGregtechTools) {
            boolean aCurrentMode;
            if (ChargingHelper.isItemValid(aStack) && aStack.func_77973_b() instanceof IElectricItemManager) {
                IElectricItemManager aItemElec = (IElectricItemManager)aStack.func_77973_b();
                double aCharge = aItemElec.getCharge(aStack);
                long aEuCost = 8192L;
                aUses = (int)(aCharge / (double)aEuCost);
            }
            if (!NBTUtils.hasTagCompound(aStack)) {
                NBTUtils.createEmptyTagCompound(aStack);
            }
            if (NBTUtils.hasKey(aStack, "aFireballMode")) {
                aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
            } else {
                aStack.func_77978_p().func_74757_a("aFireballMode", false);
                aCurrentMode = false;
            }
            aList.add("Current Mode: " + EnumChatFormatting.RED + (aCurrentMode ? "Projectile" : "Fire Starter"));
        }
        aList.add(this.mTooltipUses + " " + aUses);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

