/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators.GregtechMetaBoilerBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class GregtechMetaCondensor
extends GregtechMetaBoilerBase
implements IAddGregtechLogo {
    public GregtechMetaCondensor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "A Steam condenser - [IC2->Steam]", new ITexture[0]);
    }

    public GregtechMetaCondensor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"IC2 Steam + Water = Normal Steam.", "Requires no power to run, although it's not very fast.", CORE.GT_Tooltip.get()});
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa))};
            rTextures[1][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[2][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[3][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER)};
            rTextures[4][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER_ACTIVE)};
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaCondensor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.RI = MathUtils.randLong(5L, 30L);
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            if (this.mTemperature <= 5) {
                this.mTemperature = 5;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 10) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTileEntity;
                if (this.mSteam == null) break;
                if (side == aBaseMetaTileEntity.getFrontFacing() || (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(side)) == null || (tDrained = aBaseMetaTileEntity.drain(side, Math.max(1, this.mSteam.amount / 2), false)) == null || (tFilledAmount = tTileEntity.fill(side.getOpposite(), tDrained, false)) <= 0) continue;
                tTileEntity.fill(side.getOpposite(), aBaseMetaTileEntity.drain(side, tFilledAmount, true), true);
            }
            if (aTick % 10L == 0L) {
                if (this.mTemperature > 5) {
                    if (this.mFluid == null || !GT_ModHandler.isWater((FluidStack)this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam((long)30L);
                        } else if (GT_ModHandler.isSteam((FluidStack)this.mSteam)) {
                            this.mSteam.amount += 30;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam((long)30L);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > this.getSteamCapacity()) {
                this.sendSound((byte)1);
                this.mSteam.amount = this.getSteamCapacity() * 3 / 4;
            }
            if (this.mTemperature < 1000 && this.mProcessingEnergy > 0 && aTick % this.RI == 0L) {
                this.mProcessingEnergy -= 40;
                this.mTemperature += 2;
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    public final int fill(FluidStack aFluid, boolean doFill) {
        if (Utils.isIC2Steam(aFluid) && this.mProcessingEnergy < 50) {
            int tFilledAmount = Math.min(50, aFluid.amount);
            if (doFill) {
                this.mProcessingEnergy += tFilledAmount;
            }
            return tFilledAmount;
        }
        return super.fill(aFluid, doFill);
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setPos(43, 25).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setPos(43, 61).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_OUT}))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 2).setPos(115, 61).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_COAL}))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 3).setPos(115, 25).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DUST}))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mSteam == null ? 0.0f : (float)this.mSteam.amount / (float)this.getCapacity())).setTexture(GTPP_UITextures.PROGRESSBAR_BOILER_EMPTY, GT_UITextures.PROGRESSBAR_BOILER_STEAM, 10).setDirection(ProgressBar.Direction.UP).setPos(70, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mFluid == null ? 0.0f : (float)this.mFluid.amount / (float)this.getCapacity())).setTexture(GTPP_UITextures.PROGRESSBAR_BOILER_EMPTY, GT_UITextures.PROGRESSBAR_BOILER_WATER, 10).setDirection(ProgressBar.Direction.UP).setPos(83, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mTemperature / (float)this.maxProgresstime())).setTexture(GTPP_UITextures.PROGRESSBAR_BOILER_EMPTY, GT_UITextures.PROGRESSBAR_BOILER_HEAT, 10).setDirection(ProgressBar.Direction.UP).setPos(96, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mProcessingEnergy > 0 ? Math.max((float)this.mProcessingEnergy / 1000.0f, 0.2f) : 0.0f)).setTexture(GTPP_UITextures.PROGRESSBAR_FUEL, 14).setDirection(ProgressBar.Direction.UP).setPos(116, 45).setSize(14, 14))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.OVERLAY_SLOT_CANISTER_DARK).setPos(43, 43).setSize(18, 18));
    }
}

