/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.ob;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.util.data.FileUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.StringUtils;

public class GliderHandler {
    private static final AutoMap<Integer> mDimensionalBlacklist = new AutoMap();

    @SubscribeEvent
    public void onItemUsageEx(PlayerInteractEvent event) {
        if (event != null && event.entityPlayer != null) {
            if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                Logger.WARNING("[OpenBlocks] Wrong type of PlayerInteractEvent, skipping.");
            }
            if (event.entityPlayer.field_70170_p.field_72995_K) {
                return;
            }
            ItemStack aItem = PlayerUtils.getItemStackInPlayersHand(event.entityPlayer);
            if (ItemUtils.checkForInvalidItems(aItem)) {
                Class<?> aItemGliderClass = ReflectionUtils.getClass("openblocks.common.item.ItemHangGlider");
                if (aItemGliderClass.isInstance(aItem.func_77973_b())) {
                    if (!GliderHandler.canPlayerGlideInThisDimension(event.entityPlayer)) {
                        event.setCanceled(true);
                        PlayerUtils.messagePlayer(event.entityPlayer, "Glider is blacklisted in this dimension.");
                        Logger.WARNING("[OpenBlocks] " + event.entityPlayer.func_70005_c_() + " tried to use glider in dimension " + event.entityPlayer.func_130014_f_().field_73011_w.field_76574_g + ".");
                    } else {
                        Logger.WARNING("[OpenBlocks] " + event.entityPlayer.func_70005_c_() + " used glider in dimension " + event.entityPlayer.func_130014_f_().field_73011_w.field_76574_g + ".");
                    }
                } else {
                    Logger.WARNING("[OpenBlocks] Item was not a glider.");
                }
            } else {
                Logger.WARNING("[OpenBlocks] Bad Item in player hand.");
            }
        } else {
            Logger.WARNING("[OpenBlocks] Bad event or player.");
        }
    }

    private static final boolean canPlayerGlideInThisDimension(EntityPlayer aPlayer) {
        World aWorld = aPlayer.field_70170_p;
        if (aWorld == null) {
            return false;
        }
        if (aWorld.field_73011_w == null) {
            return false;
        }
        int aDimID = aWorld.field_73011_w.field_76574_g;
        for (int i : mDimensionalBlacklist) {
            if (i != aDimID) continue;
            return false;
        }
        return true;
    }

    static final void populateBlacklist() {
        if (!mDimensionalBlacklist.isEmpty()) {
            return;
        }
        File aBlacklist = FileUtils.getFile("config/GTplusplus/", "GliderBlacklist", "cfg");
        List<String> lines = new ArrayList();
        try {
            lines = org.apache.commons.io.FileUtils.readLines((File)aBlacklist, (String)"utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (lines.isEmpty()) {
            try {
                String aInfoTip = "# Add one dimension ID per line. Lines with a # are comments and are ignored.";
                FileWriter fw = new FileWriter(aBlacklist);
                fw.write(aInfoTip);
                fw.close();
                lines.add(aInfoTip);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!lines.isEmpty()) {
            for (String s : lines) {
                if (s == null || s.equals("") || s.contains("#")) continue;
                s = StringUtils.remove((String)s, (String)" ");
                s = StringUtils.trim((String)s);
                Integer g = Integer.decode(s = StringUtils.remove((String)s, (String)","));
                if (g == null) continue;
                mDimensionalBlacklist.add(g);
                Logger.INFO("[OpenBlocks] Added Dimension with ID '" + g + "' to Blacklist for Glider.");
            }
        }
    }
}

