/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.core.localization.GuiText;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.ContainerFluidInterface;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.gui.MouseRegionManager;
import com.glodblock.github.inventory.gui.TankMouseHandler;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.network.CPacketSwitchGuis;
import com.glodblock.github.util.RenderUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiFluidInterface
extends AEBaseGui {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/interface_fluid.png");
    private static final int TANK_X = 35;
    private static final int TANK_X_OFF = 18;
    private static final int TANK_Y = 53;
    private static final int TANK_WIDTH = 16;
    private static final int TANK_HEIGHT = 68;
    private final ContainerFluidInterface cont;
    private GuiTabButton switcher;
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);

    public GuiFluidInterface(InventoryPlayer ipl, IDualHost tile) {
        super((Container)new ContainerFluidInterface(ipl, tile));
        this.cont = (ContainerFluidInterface)this.field_147002_h;
        this.field_147000_g = 231;
        this.addMouseRegin();
    }

    private void addMouseRegin() {
        for (int i = 0; i < 6; ++i) {
            this.mouseRegions.addRegion(35 + 18 * i, 53, 16, 68, new TankMouseHandler(this.cont.getTile().getInternalFluid(), i));
        }
    }

    public void func_146977_a(Slot s) {
        try {
            GuiContainer.class.getDeclaredMethod("func_146977_a_original", Slot.class).invoke((Object)this, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.switcher = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, this.isPart() ? ItemAndBlockHolder.FLUID_INTERFACE.stack() : ItemAndBlockHolder.INTERFACE.stack(), StatCollector.func_74838_a((String)"ae2fc.tooltip.switch_fluid_interface"), field_146296_j);
        this.field_146292_n.add(this.switcher);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)"ae2fc.gui.fluid_interface", (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 94, 0x404040);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AEFluidInventory fluidInv = this.cont.getTile().getInternalFluid();
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (int i = 0; i < 6; ++i) {
            if (!this.isPart()) {
                this.field_146289_q.func_78276_b(this.dirName(i), 35 + i * 18 + 5, 22, 0x404040);
            }
            RenderUtil.renderFluidIntoGui((Gui)this, 35 + i * 18, 53, 16, 68, fluidInv.getFluidInSlot(i), fluidInv.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[i].capacity);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mouseRegions.render(mouseX, mouseY);
    }

    public String dirName(int face) {
        return I18n.func_135052_a((String)("ae2fc.gui.fluid_interface." + face), (Object[])new Object[0]);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn == this.switcher) {
            FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketSwitchGuis(GuiType.DUAL_INTERFACE));
        }
    }

    public void update(int id, IAEFluidStack stack) {
        if (id >= 100) {
            this.cont.getTile().setConfig(id - 100, stack);
        } else {
            this.cont.getTile().setFluidInv(id, stack);
        }
    }

    private boolean isPart() {
        return this.cont.getTile() instanceof PartFluidInterface;
    }
}

