/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.waila.vanilla;

import appeng.integration.modules.waila.BaseWailaDataProvider;
import com.glodblock.github.common.tile.TileCertusQuartzTank;
import com.glodblock.github.crossmod.waila.Tooltip;
import com.glodblock.github.util.Util;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;

public class FluidInvWailaDataProvider
extends BaseWailaDataProvider {
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileCertusQuartzTank && accessor.getNBTData().func_74764_b("fluidInv")) {
            NBTTagCompound data = (NBTTagCompound)accessor.getNBTData().func_74781_a("fluidInv");
            for (FluidTankInfo info : Util.FluidUtil.fluidTankInfoReadFromNBT(data)) {
                if (info.fluid == null) continue;
                currentToolTip.add(Tooltip.fluidFormat(info.fluid.getLocalizedName(), info.fluid.amount, info.capacity));
            }
        }
        return currentToolTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileCertusQuartzTank) {
            NBTTagCompound data = new NBTTagCompound();
            Util.FluidUtil.fluidTankInfoWriteToNBT(((TileCertusQuartzTank)te).getInternalFluid(), data);
            tag.func_74782_a("fluidInv", (NBTBase)data);
            te.func_145841_b(tag);
        }
        return tag;
    }
}

