/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes;

import codechicken.nei.recipe.IRecipeHandler;
import com.glodblock.github.nei.recipes.FluidRecipe;
import com.glodblock.github.nei.recipes.extractor.AvaritiaRecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.EnderIORecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.ForestryRecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.GTPPRecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.GregTech5RecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.GregTech6RecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.IndustrialCraftRecipeExtractor;
import com.glodblock.github.nei.recipes.extractor.VanillaRecipeExtractor;
import com.glodblock.github.util.ModAndClassUtil;
import forestry.factory.recipes.nei.NEIHandlerBottler;
import forestry.factory.recipes.nei.NEIHandlerCarpenter;
import forestry.factory.recipes.nei.NEIHandlerCentrifuge;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerFermenter;
import forestry.factory.recipes.nei.NEIHandlerMoistener;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import forestry.factory.recipes.nei.NEIHandlerStill;
import gregapi.recipes.Recipe;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;

public class DefaultExtractorLoader
implements Runnable {
    @Override
    public void run() {
        FluidRecipe.addRecipeMap("smelting", new VanillaRecipeExtractor(false));
        FluidRecipe.addRecipeMap("brewing", new VanillaRecipeExtractor(false));
        FluidRecipe.addRecipeMap("crafting", new VanillaRecipeExtractor(true));
        FluidRecipe.addRecipeMap("crafting2x2", new VanillaRecipeExtractor(true));
        if (ModAndClassUtil.GT5) {
            for (GT_Recipe.GT_Recipe_Map tMap : GT_Recipe.GT_Recipe_Map.sMappings) {
                FluidRecipe.addRecipeMap(tMap.mNEIName, new GregTech5RecipeExtractor(tMap.mNEIName.equals("gt.recipe.scanner") || tMap.mNEIName.equals("gt.recipe.fakeAssemblylineProcess")));
            }
        }
        if (ModAndClassUtil.GT6) {
            for (GT_Recipe.GT_Recipe_Map tMap : Recipe.RecipeMap.RECIPE_MAPS.values()) {
                FluidRecipe.addRecipeMap(tMap.mNameNEI, new GregTech6RecipeExtractor((Recipe.RecipeMap)tMap));
            }
        }
        if (ModAndClassUtil.GTPP) {
            for (GTPP_Recipe.GTPP_Recipe_Map_Internal gtppMap : GTPP_Recipe.GTPP_Recipe_Map_Internal.sMappingsEx) {
                if (!gtppMap.mNEIAllowed) continue;
                FluidRecipe.addRecipeMap(gtppMap.mNEIName, new GTPPRecipeExtractor());
            }
        }
        if (ModAndClassUtil.EIO) {
            FluidRecipe.addRecipeMap("EIOEnchanter", new EnderIORecipeExtractor());
            FluidRecipe.addRecipeMap("EnderIOAlloySmelter", new EnderIORecipeExtractor());
            FluidRecipe.addRecipeMap("EnderIOSagMill", new EnderIORecipeExtractor());
            FluidRecipe.addRecipeMap("EnderIOSliceAndSplice", new EnderIORecipeExtractor());
            FluidRecipe.addRecipeMap("EnderIOSoulBinder", new EnderIORecipeExtractor());
            FluidRecipe.addRecipeMap("EnderIOVat", new EnderIORecipeExtractor());
        }
        if (ModAndClassUtil.AVARITIA) {
            FluidRecipe.addRecipeMap("extreme", new AvaritiaRecipeExtractor());
        }
        if (ModAndClassUtil.FTR) {
            FluidRecipe.addRecipeMap("forestry.bottler", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerBottler()));
            FluidRecipe.addRecipeMap("forestry.carpenter", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerCarpenter()));
            FluidRecipe.addRecipeMap("forestry.centrifuge", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerCentrifuge()));
            FluidRecipe.addRecipeMap("forestry.fabricator", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerFabricator()));
            FluidRecipe.addRecipeMap("forestry.fermenter", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerFermenter()));
            FluidRecipe.addRecipeMap("forestry.moistener", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerMoistener()));
            FluidRecipe.addRecipeMap("forestry.squeezer", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerSqueezer()));
            FluidRecipe.addRecipeMap("forestry.still", new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerStill()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerBottler()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerCarpenter()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerCentrifuge()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerFabricator()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerFermenter()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerMoistener()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerSqueezer()));
            FluidRecipe.addRecipeMap(null, new ForestryRecipeExtractor((IRecipeHandler)new NEIHandlerStill()));
        }
        if (ModAndClassUtil.IC2) {
            FluidRecipe.addRecipeMap("blastfurnace", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("BlockCutter", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("centrifuge", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("compressor", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("extractor", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("fluidcanner", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("macerator", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("metalformer", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("oreWashing", new IndustrialCraftRecipeExtractor());
            FluidRecipe.addRecipeMap("solidcanner", new IndustrialCraftRecipeExtractor());
        }
    }
}

