/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.container.AEBaseContainer;
import appeng.helpers.ICustomNameObject;
import appeng.tile.networking.TileCableBus;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessInterfaceTerminal;
import com.glodblock.github.network.SPacketStringUpdate;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketRenamer
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int dim;
    private ForgeDirection side;
    private Action action;
    private String text;

    public CPacketRenamer() {
    }

    public CPacketRenamer(String text) {
        this.action = Action.SET_TEXT;
        this.text = text;
    }

    public CPacketRenamer(Action a) {
        this.action = a;
    }

    public CPacketRenamer(int x, int y, int z, int dim, ForgeDirection side) {
        this.action = Action.OPEN;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        if (this.action == Action.OPEN) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.dim = buf.readInt();
            this.side = ForgeDirection.getOrientation((int)buf.readInt());
        } else if (this.action == Action.SET_TEXT) {
            int leName = buf.readInt();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < leName; ++i) {
                sb.append(buf.readChar());
            }
            this.text = sb.toString();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        if (this.action == Action.OPEN) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.dim);
            buf.writeInt(this.side.ordinal());
        } else if (this.action == Action.SET_TEXT) {
            buf.writeInt(this.text.length());
            for (int i = 0; i < this.text.length(); ++i) {
                buf.writeChar((int)this.text.charAt(i));
            }
        }
    }

    public static enum Action {
        OPEN,
        GET_TEXT,
        SET_TEXT;

    }

    public static class Handler
    implements IMessageHandler<CPacketRenamer, IMessage> {
        private String getName(ICustomNameObject obj) {
            return obj.hasCustomName() ? obj.getCustomName() : "";
        }

        private String getName(TileEntity tile, ForgeDirection side) {
            if (tile instanceof TileCableBus) {
                return this.getName((ICustomNameObject)((TileCableBus)tile).getPart(side));
            }
            return this.getName((ICustomNameObject)tile);
        }

        private void setName(TileEntity tile, ForgeDirection side, String text) {
            if (tile instanceof TileCableBus) {
                ((ICustomNameObject)((TileCableBus)tile).getPart(side)).setCustomName(text);
            } else {
                ((ICustomNameObject)tile).setCustomName(text);
            }
        }

        public IMessage onMessage(CPacketRenamer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            AEBaseContainer con = (AEBaseContainer)player.field_71070_bA;
            if (message.action == Action.OPEN) {
                TileEntity tile = DimensionManager.getWorld((int)message.dim).func_147438_o(message.x, message.y, message.z);
                if (tile != null && con.getTarget() instanceof IWirelessInterfaceTerminal && tile instanceof ICustomNameObject) {
                    String name = this.getName(tile, message.side);
                    ((IWirelessInterfaceTerminal)con.getTarget()).setClickedInterface(new Util.DimensionalCoordSide(message.x, message.y, message.z, message.dim, message.side, name));
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((IWirelessInterfaceTerminal)con.getTarget()).getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 1), message.side, GuiType.RENAMER);
                }
            } else if (con.getTarget() instanceof IWirelessInterfaceTerminal) {
                Util.DimensionalCoordSide intMsg = ((IWirelessInterfaceTerminal)con.getTarget()).getClickedInterface();
                TileEntity tile = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(intMsg.x, intMsg.y, intMsg.z);
                if (message.action == Action.GET_TEXT) {
                    FluidCraft.proxy.netHandler.sendTo((IMessage)new SPacketStringUpdate(this.getName(tile, intMsg.getSide())), player);
                } else {
                    this.setName(tile, intMsg.getSide(), message.text);
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((IWirelessInterfaceTerminal)con.getTarget()).getInventorySlot(), Util.GuiHelper.encodeType(ItemWirelessUltraTerminal.getGuis().indexOf((Object)GuiType.valueOf(GuiType.WIRELESS_INTERFACE_TERMINAL.toString())), Util.GuiHelper.GuiType.ITEM), 0), ForgeDirection.UNKNOWN, GuiType.WIRELESS_INTERFACE_TERMINAL);
                }
            }
            return null;
        }
    }
}

