/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import akka.japi.Pair;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotFake;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketNEIDragClick;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.parts.automation.PartExportBus;
import appeng.parts.automation.PartImportBus;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

@Optional.Interface(modid="NotEnoughItems", iface="codechicken.nei.api.INEIGuiHandler")
public class GuiUpgradeable
extends AEBaseGui
implements INEIGuiHandler {
    protected final ContainerUpgradeable cvb;
    protected final IUpgradeableHost bc;
    protected GuiImgButton redstoneMode;
    protected GuiImgButton fuzzyMode;
    protected GuiImgButton craftMode;
    protected GuiImgButton schedulingMode;
    protected GuiImgButton oreFilter;

    public GuiUpgradeable(InventoryPlayer inventoryPlayer, IUpgradeableHost te) {
        this(new ContainerUpgradeable(inventoryPlayer, te));
    }

    public GuiUpgradeable(ContainerUpgradeable te) {
        super(te);
        this.cvb = te;
        this.bc = (IUpgradeableHost)te.getTarget();
        this.field_146999_f = this.hasToolbox() ? 246 : 211;
        this.field_147000_g = 184;
    }

    protected boolean hasToolbox() {
        return ((ContainerUpgradeable)this.field_147002_h).hasToolbox();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButtons();
    }

    protected void addButtons() {
        this.redstoneMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.schedulingMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.oreFilter = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.ACTIONS, ActionItems.ORE_FILTER);
        this.field_146292_n.add(this.craftMode);
        this.field_146292_n.add(this.redstoneMode);
        this.field_146292_n.add(this.fuzzyMode);
        this.field_146292_n.add(this.schedulingMode);
        this.field_146292_n.add(this.oreFilter);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(this.getName().getLocal()), 8, 6, GuiColors.UpgradableTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, GuiColors.UpgradableInventory.getColor());
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.getRedStoneMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.getCraftingMode());
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(this.cvb.getSchedulingMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 14 + this.cvb.availableUpgrades() * 18);
        }
        if (this.hasToolbox()) {
            this.func_73729_b(offsetX + 178, offsetY + this.field_147000_g - 90, 178, this.field_147000_g - 90, 68, 68);
        }
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0 && this.bc.getInstalledUpgrades(Upgrades.ORE_FILTER) == 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CAPACITY) > 0 && this.bc instanceof PartExportBus);
        }
        if (this.oreFilter != null) {
            this.oreFilter.setVisibility(this.bc.getInstalledUpgrades(Upgrades.ORE_FILTER) > 0);
        }
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected GuiText getName() {
        return this.bc instanceof PartImportBus ? GuiText.ImportBus : GuiText.ExportBus;
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.redstoneMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.redstoneMode.getSetting(), backwards));
        }
        if (btn == this.craftMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.craftMode.getSetting(), backwards));
        }
        if (btn == this.fuzzyMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.fuzzyMode.getSetting(), backwards));
        }
        if (btn == this.schedulingMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.schedulingMode.getSetting(), backwards));
        }
        if (btn == this.oreFilter) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(GuiBridge.GUI_ORE_FILTER));
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    public boolean handleDragNDrop(GuiContainer gui, int mouseX, int mouseY, ItemStack draggedStack, int button) {
        ArrayList<Pair> slots = new ArrayList<Pair>();
        if (this.field_147002_h.field_75151_b.size() > 0) {
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Object slot = this.field_147002_h.field_75151_b.get(i);
                if (!(slot instanceof SlotFake)) continue;
                slots.add(new Pair((Object)((SlotFake)((Object)slot)), (Object)i));
            }
        }
        for (Pair fakeSlotPair : slots) {
            SlotFake fakeSlot = (SlotFake)((Object)fakeSlotPair.first());
            if (!fakeSlot.isEnabled() || !this.getSlotArea(fakeSlot).contains(mouseX, mouseY)) continue;
            fakeSlot.func_75215_d(draggedStack);
            NetworkHandler.instance.sendToServer(new PacketNEIDragClick(draggedStack, (Integer)fakeSlotPair.second()));
            if (draggedStack != null) {
                draggedStack.field_77994_a = 0;
            }
            return true;
        }
        if (draggedStack != null) {
            draggedStack.field_77994_a = 0;
        }
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return false;
    }

    private Rectangle getSlotArea(SlotFake slot) {
        return new Rectangle(this.field_147003_i + slot.getX(), this.field_147009_r + slot.getY(), 16, 16);
    }
}

