/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import buildcraft.api.tools.IToolWrench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class PartP2PTunnelStatic<T extends PartP2PTunnelStatic>
extends PartP2PTunnel<T> {
    public PartP2PTunnelStatic(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        Item item;
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && (item = is.func_77973_b()) instanceof IMemoryCard) {
            Item item2;
            IMemoryCard mc = (IMemoryCard)item;
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            NBTTagCompound data = mc.getData(is);
            ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
            long freq = data.func_74763_f("freq");
            if (newType != null && (item2 = newType.func_77973_b()) instanceof IPartItem) {
                IPartItem partItem = (IPartItem)item2;
                IPart testPart = partItem.createPartFromItemStack(newType);
                if (this.getClass().isInstance(testPart)) {
                    this.getHost().removePart(this.getSide(), true);
                    ForgeDirection dir = this.getHost().addPart(newType, this.getSide(), player);
                    IPart newBus = this.getHost().getPart(dir);
                    if (newBus instanceof PartP2PTunnel) {
                        PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                        newTunnel.setOutput(true);
                        try {
                            P2PCache p2p = newTunnel.getProxy().getP2P();
                            p2p.updateFreq(newTunnel, freq);
                            PartP2PTunnel input = p2p.getInput(freq);
                            if (input != null) {
                                newTunnel.setCustomNameInternal(input.getCustomName());
                            }
                        }
                        catch (GridAccessException gridAccessException) {
                            // empty catch block
                        }
                        newTunnel.onTunnelNetworkChange();
                    }
                    mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    return true;
                }
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (!player.func_70093_af() && is != null && is.func_77973_b() instanceof IToolWrench && !Platform.isClient()) {
            this.printConnectionInfo(player);
        }
        return false;
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.World || type == PartItemStack.Network || type == PartItemStack.Wrench) {
            return super.getItemStack(type);
        }
        return super.getItemStack(PartItemStack.Pick);
    }
}

