/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.parts.IPart;
import appeng.helpers.IInterfaceHost;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBetterStorage;
import appeng.parts.p2p.PartP2PItems;
import appeng.tile.AEBaseInvTile;
import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import appeng.util.AdaptorP2PItem;
import appeng.util.Platform;
import appeng.util.inv.AdaptorDualityInterface;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorList;
import appeng.util.inv.AdaptorPlayerInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperMCISidedInventory;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InventoryAdaptor
implements Iterable<ItemSlot> {
    public static InventoryAdaptor getAdaptor(Object te, ForgeDirection d) {
        IInventory i;
        if (te == null) {
            return null;
        }
        IBetterStorage bs = (IBetterStorage)(IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.BetterStorage) ? IntegrationRegistry.INSTANCE.getInstance(IntegrationType.BetterStorage) : null);
        if (te instanceof EntityPlayer) {
            return new AdaptorIInventory(new AdaptorPlayerInventory((IInventory)((EntityPlayer)te).field_71071_by, false));
        }
        if (te instanceof ArrayList) {
            ArrayList list = (ArrayList)te;
            return new AdaptorList(list);
        }
        if (bs != null && bs.isStorageCrate(te)) {
            return bs.getAdaptor(te, d);
        }
        if (te instanceof TileEntityChest) {
            return new AdaptorIInventory(Platform.GetChestInv(te));
        }
        if (te instanceof ISidedInventory) {
            ISidedInventory si = (ISidedInventory)te;
            int[] slots = si.func_94128_d(d.ordinal());
            if (te instanceof TileInterface) {
                return new AdaptorDualityInterface((IInventory)new WrapperMCISidedInventory(si, d), (IInterfaceHost)te);
            }
            if (te instanceof TileCableBus) {
                IPart part = ((TileCableBus)te).getPart(d);
                if (part instanceof IInterfaceHost) {
                    IInterfaceHost host = (IInterfaceHost)((Object)part);
                    return new AdaptorDualityInterface((IInventory)new WrapperMCISidedInventory(si, d), host);
                }
                if (part instanceof PartP2PItems) {
                    PartP2PItems p2p = (PartP2PItems)part;
                    return new AdaptorP2PItem(p2p);
                }
            }
            int stackLimit = 0;
            if (te instanceof AEBaseInvTile) {
                stackLimit = ((AEBaseInvTile)te).getInternalInventory().func_70297_j_();
            }
            if (si.func_70302_i_() > 0 && slots != null && slots.length > 0) {
                if (stackLimit > 0) {
                    return new AdaptorIInventory(new WrapperMCISidedInventory(si, d), stackLimit);
                }
                return new AdaptorIInventory(new WrapperMCISidedInventory(si, d));
            }
        } else if (te instanceof IInventory && (i = (IInventory)te).func_70302_i_() > 0) {
            return new AdaptorIInventory(i);
        }
        return null;
    }

    public abstract ItemStack removeItems(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack simulateRemove(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack removeSimilarItems(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack simulateSimilarRemove(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack addItems(ItemStack var1);

    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        return this.addItems(toBeAdded);
    }

    public abstract ItemStack simulateAdd(ItemStack var1);

    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        return this.simulateAdd(toBeSimulated);
    }

    public abstract boolean containsItems();
}

