/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunklistener;

import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.chunkblock.IChunkBlockHandler;
import net.malisis.core.util.chunklistener.IBlockListener;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.Chunk;

public class ChunkListener
implements IChunkBlockHandler {
    @Override
    public boolean updateCoordinates(Chunk chunk, BlockPos pos, Block old, Block block) {
        BlockNotifierProcedure procedure = new BlockNotifierProcedure(new BlockState(pos, block));
        ChunkBlockHandler.get().callProcedure(chunk, procedure);
        return procedure.isCanceled();
    }

    private static class BlockNotifierProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private boolean cancel = false;
        private BlockState newState;

        public BlockNotifierProcedure(BlockState newState) {
            this.newState = newState;
        }

        public boolean isCanceled() {
            return this.cancel;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            if (!(this.state.getBlock() instanceof IBlockListener)) {
                return true;
            }
            IBlockListener block = (IBlockListener)this.state.getBlock();
            if (!this.state.getPos().isInRange(this.newState.getPos(), block.blockRange())) {
                return true;
            }
            if (!this.state.getPos().equals(this.newState.getPos())) {
                this.cancel = this.newState.getBlock() == Blocks.field_150350_a ? (this.cancel |= !block.onBlockRemoved(this.world, this.state.getPos(), this.newState.getPos())) : (this.cancel |= !block.onBlockSet(this.world, this.state.getPos(), this.newState));
            }
            return !this.cancel;
        }

        @Override
        protected void clean() {
            super.clean();
            this.cancel = false;
            this.newState = null;
        }
    }
}

