/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.dimension;

import galaxyspace.core.world.GSBiomeGenBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public abstract class ChunkProviderSpaceLakes
extends ChunkProviderGenerate {
    protected Random field_73220_k;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves field_73214_a;
    public NoiseGeneratorOctaves field_73212_b;
    public NoiseGeneratorOctaves field_73213_c;
    protected World field_73230_p;
    private double[] stoneNoise;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private double[] terrainCalcs;
    private float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private final Gradient noiseGen8;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpaceLakes(World world, long seed, boolean flag) {
        super(world, seed, flag);
        this.stoneNoise = new double[256];
        this.field_73230_p = world;
        this.field_73220_k = new Random(seed);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.field_73220_k, 4);
        this.field_73214_a = new NoiseGeneratorOctaves(this.field_73220_k, 10);
        this.field_73212_b = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.noiseGen8 = new Gradient(this.field_73220_k.nextLong(), 2, 0.25f);
        this.field_73213_c = new NoiseGeneratorOctaves(this.field_73220_k, 8);
        this.field_147431_j = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.field_73220_k, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.field_73220_k, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_73154_d(int x, int z) {
        this.field_73220_k.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blockStorage = new Block[65536];
        byte[] metaStorage = new byte[65536];
        this.generateTerrain(x, z, blockStorage, metaStorage);
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_147422_a(x, z, blockStorage, metaStorage, this.biomesForGeneration);
        this.onChunkProvider(x, z, blockStorage, metaStorage);
        Chunk chunk = new Chunk(this.field_73230_p, blockStorage, metaStorage, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, x, z, blockStorage, metaStorage);
        }
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blockStorage, byte[] metaStorage) {
        int seaLevel = this.getWaterLevel();
        metaStorage = new byte[65536];
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k2 = (l + j1) * 33;
                int l2 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k3 = 0; k3 < 32; ++k3) {
                    double d0 = 0.125;
                    double d2 = this.terrainCalcs[k2 + k3];
                    double d3 = this.terrainCalcs[l2 + k3];
                    double d4 = this.terrainCalcs[i2 + k3];
                    double d5 = this.terrainCalcs[j2 + k3];
                    double d6 = (this.terrainCalcs[k2 + k3 + 1] - d2) * 0.125;
                    double d7 = (this.terrainCalcs[l2 + k3 + 1] - d3) * 0.125;
                    double d8 = (this.terrainCalcs[i2 + k3 + 1] - d4) * 0.125;
                    double d9 = (this.terrainCalcs[j2 + k3 + 1] - d5) * 0.125;
                    for (int l3 = 0; l3 < 8; ++l3) {
                        double d10 = 0.25;
                        double d11 = d2;
                        double d12 = d3;
                        double d13 = (d4 - d2) * 0.25;
                        double d14 = (d5 - d3) * 0.25;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k3 * 8 + l3;
                            int short1 = 256;
                            j3 -= 256;
                            double d15 = 0.25;
                            double d16 = (d12 - d11) * 0.25;
                            double d17 = d11 - d16;
                            for (int k4 = 0; k4 < 4; ++k4) {
                                double d;
                                d17 += d16;
                                blockStorage[j3 += 256] = d > 0.0 ? this.getStoneBlock().getBlock() : (k3 * 8 + l3 < seaLevel && this.canGenerateWaterBlock() ? this.getWaterBlock().getBlock() : null);
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        d5 += d9;
                    }
                }
            }
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.field_73212_b.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -2; ox <= 2; ++ox) {
                    for (int oz = -2; oz <= 2; ++oz) {
                        BiomeGenBase biomegenbase2 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase2.field_76748_D;
                        float heightVariation = biomegenbase2.field_76749_E;
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase2.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = (double)totalVariation * this.getHeightModifier() / 10.0;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d10 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d10) + -10.0 * d10;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        float var6 = 0.03125f;
        this.noiseGen8.setFrequency(0.0625f);
        for (int var7 = 0; var7 < 16; ++var7) {
            for (int var8 = 0; var8 < 16; ++var8) {
                GSBiomeGenBase biomegenbase = (GSBiomeGenBase)par4ArrayOfBiomeGenBase[var7 + var8 * 16];
                int var9 = (int)((double)this.noiseGen8.getNoise((float)(par1 * 16 + var7), (float)(par2 * 16 + var8)) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var10 = -1;
                Block var11 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76752_A : this.getGrassBlock().getBlock();
                byte var14m = this.enableBiomeGenBaseBlock() ? biomegenbase.topMeta : this.getGrassBlock().getMetadata();
                Block var12 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76753_B : this.getDirtBlock().getBlock();
                byte var15m = this.enableBiomeGenBaseBlock() ? biomegenbase.fillerMeta : this.getDirtBlock().getMetadata();
                for (int var13 = 255; var13 >= 0; --var13) {
                    int index = this.getIndex(var7, var13, var8);
                    if (var13 <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                    }
                    if (var13 == 5 || var13 == 6 + this.field_73220_k.nextInt(3)) {
                        arrayOfIDs[index] = this.canGenerateIceBlock() ? Blocks.field_150403_cj : Blocks.field_150357_h;
                        continue;
                    }
                    Block var14 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var14) {
                        var10 = -1;
                        continue;
                    }
                    if (var14 == this.getStoneBlock().getBlock() && !this.enableBiomeGenBaseBlock()) {
                        arrayOfMeta[index] = this.getStoneBlock().getMetadata();
                        if (var10 == -1) {
                            if (var9 <= 0) {
                                var11 = Blocks.field_150350_a;
                                var14m = 0;
                                var12 = this.getStoneBlock().getBlock();
                                var15m = this.getStoneBlock().getMetadata();
                            } else if (var13 >= 36 && var13 <= 21) {
                                if (this.enableBiomeGenBaseBlock()) {
                                    var11 = biomegenbase.field_76752_A;
                                    var14m = biomegenbase.topMeta;
                                    var11 = biomegenbase.field_76753_B;
                                    var14m = biomegenbase.fillerMeta;
                                } else {
                                    var11 = this.getGrassBlock().getBlock();
                                    var14m = this.getGrassBlock().getMetadata();
                                    var11 = this.getDirtBlock().getBlock();
                                    var14m = this.getDirtBlock().getMetadata();
                                }
                            }
                            var10 = var9;
                            if (var13 >= 19) {
                                arrayOfIDs[index] = var11;
                                arrayOfMeta[index] = var14m;
                                continue;
                            }
                            arrayOfIDs[index] = var12;
                            arrayOfMeta[index] = var15m;
                            continue;
                        }
                        if (var10 <= 0) continue;
                        --var10;
                        arrayOfIDs[index] = var12;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var14 != biomegenbase.stoneBlock) continue;
                    arrayOfMeta[index] = biomegenbase.stoneMeta;
                    if (var10 == -1) {
                        if (var9 <= 0) {
                            var11 = Blocks.field_150350_a;
                            var14m = 0;
                            if (this.enableBiomeGenBaseBlock()) {
                                var12 = biomegenbase.stoneBlock;
                                var15m = biomegenbase.stoneMeta;
                            } else {
                                var12 = this.getStoneBlock().getBlock();
                                var15m = this.getStoneBlock().getMetadata();
                            }
                        } else if (var13 >= 36 && var13 <= 21) {
                            if (this.enableBiomeGenBaseBlock()) {
                                var11 = biomegenbase.field_76752_A;
                                var14m = biomegenbase.topMeta;
                                var11 = biomegenbase.field_76753_B;
                                var14m = biomegenbase.fillerMeta;
                            } else {
                                var11 = this.getGrassBlock().getBlock();
                                var14m = this.getGrassBlock().getMetadata();
                                var11 = this.getDirtBlock().getBlock();
                                var14m = this.getDirtBlock().getMetadata();
                            }
                        }
                        var10 = var9;
                        if (var13 >= 19) {
                            arrayOfIDs[index] = var11;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        arrayOfIDs[index] = var12;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var10 <= 0) continue;
                    --var10;
                    arrayOfIDs[index] = var12;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunk, int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        BiomeGenBase biomeGen = this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long var6 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)x * var6 + (long)z * var7 ^ this.field_73230_p.func_72905_C());
        biomeGen.func_76728_a(this.field_73230_p, this.field_73220_k, var4, var5);
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, var4, var5);
        SpawnerAnimals.func_77191_a((World)this.field_73230_p, (BiomeGenBase)biomeGen, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.field_73220_k);
        this.onPopulate(chunk, x, z);
        BlockFalling.field_149832_M = false;
    }

    public void decoratePlanet(World world, Random rand, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand, x, z);
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry monster : this.getMonsters()) {
                monsters.add(monster);
            }
            return monsters;
        }
        if (par1EnumCreatureType == EnumCreatureType.creature) {
            ArrayList<BiomeGenBase.SpawnListEntry> creatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry creature : this.getCreatures()) {
                creatures.add(creature);
            }
            return creatures;
        }
        if (par1EnumCreatureType == EnumCreatureType.waterCreature) {
            ArrayList<BiomeGenBase.SpawnListEntry> watercreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry watercreature : this.getWaterCreatures()) {
                watercreatures.add(watercreature);
            }
            return watercreatures;
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String string, int x, int y, int z) {
        return null;
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract BiomeGenBase[] getBiomesForGeneration();

    public abstract void onChunkProvider(int var1, int var2, Block[] var3, byte[] var4);

    public abstract void onPopulate(IChunkProvider var1, int var2, int var3);

    protected abstract BiomeGenBase.SpawnListEntry[] getMonsters();

    protected abstract BiomeGenBase.SpawnListEntry[] getCreatures();

    protected abstract BiomeGenBase.SpawnListEntry[] getWaterCreatures();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    public abstract double getHeightModifier();

    public abstract int getWaterLevel();

    public abstract boolean canGenerateWaterBlock();

    public abstract boolean canGenerateIceBlock();

    protected abstract BlockMetaPair getWaterBlock();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    protected abstract boolean enableBiomeGenBaseBlock();
}

