/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.enums.ItemEqualsCompareMethodEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class ItemDescriptor {
    private static LogHelper _mLog = YAMCore.instance.getLogger();
    private final String mModID;
    private final String mItemName;
    private final int mMetaID;

    public String getModID() {
        return this.mModID;
    }

    public String getItemName() {
        return this.mItemName;
    }

    public int getMeta() {
        return this.mMetaID;
    }

    public ItemDescriptor() {
        this("", "", 0);
    }

    public ItemDescriptor(String pModID, String pItemName) {
        this(pModID, pItemName, 0);
    }

    public ItemDescriptor(String pModID, String pItemName, int pMeta) {
        this.mModID = pModID;
        this.mItemName = pItemName;
        this.mMetaID = pMeta;
    }

    public static ItemDescriptor fromItem(Item pItem) {
        ItemDescriptor tRet = null;
        if (pItem != null) {
            GameRegistry.UniqueIdentifier UID = GameRegistry.findUniqueIdentifierFor((Item)pItem);
            tRet = UID != null ? new ItemDescriptor(UID.modId, UID.name) : null;
        }
        return tRet;
    }

    public static ItemDescriptor fromStack(ItemStack pItemStack) {
        ItemDescriptor tRet = null;
        if (pItemStack != null) {
            GameRegistry.UniqueIdentifier UID = GameRegistry.findUniqueIdentifierFor((Item)pItemStack.func_77973_b());
            tRet = UID != null ? new ItemDescriptor(UID.modId, UID.name, pItemStack.func_77960_j()) : null;
        }
        return tRet;
    }

    public static ItemDescriptor fromString(String pItemIdentifier) {
        return ItemDescriptor.fromString(pItemIdentifier, false);
    }

    public static ItemDescriptor fromString(String pItemIdentifier, boolean pVerifyItemExists) {
        ItemDescriptor tRet = null;
        try {
            String[] args = pItemIdentifier.split(":");
            if (args.length >= 2) {
                String tModID = args[0];
                String tItemName = args[1];
                int tMetaID = 0;
                if (args.length == 3) {
                    tMetaID = Integer.parseInt(args[2]);
                }
                tRet = new ItemDescriptor(tModID, tItemName, tMetaID);
                if (pVerifyItemExists && tRet.getItemStack(1) == null) {
                    tRet = null;
                }
            }
        }
        catch (NumberFormatException e) {
            _mLog.error(String.format("Found invalid descriptor tag: %s", pItemIdentifier));
            e.printStackTrace();
        }
        catch (Exception e) {
            _mLog.error(String.format("Error while parsing itemIdentifier %s", pItemIdentifier));
            e.printStackTrace();
        }
        return tRet;
    }

    public static boolean isEqualTo(ItemDescriptor pID1, ItemDescriptor pID2, ItemEqualsCompareMethodEnum pCompareMethod) {
        String tObjectHashA = "";
        String tObjectHashB = "";
        switch (pCompareMethod) {
            case Exact: {
                tObjectHashA = pID1.toString();
                tObjectHashB = pID2.toString();
                break;
            }
            case IgnoreMetaData: {
                tObjectHashA = String.format("%s:%s", pID1.getModID(), pID1.getItemName());
                tObjectHashB = String.format("%s:%s", pID2.getModID(), pID2.getItemName());
            }
        }
        return tObjectHashA.equals(tObjectHashB);
    }

    public boolean isEqualTo(ItemDescriptor pOther, ItemEqualsCompareMethodEnum pCompareMethod) {
        return ItemDescriptor.isEqualTo(this, pOther, pCompareMethod);
    }

    public Item getItem() {
        Item tRet = null;
        try {
            Item tItem = GameRegistry.findItem((String)this.mModID, (String)this.mItemName);
            if (tItem != null) {
                tRet = tItem;
            }
        }
        catch (Exception e) {
            _mLog.error(String.format("Unable to get Item %s:s", this.mModID, this.mItemName));
        }
        return tRet;
    }

    public ItemStack getItemStack(int pAmount) {
        ItemStack tRetStack = null;
        Item tItem = this.getItem();
        if (tItem != null) {
            tRetStack = new ItemStack(tItem, pAmount, this.mMetaID);
        }
        return tRetStack;
    }

    public ItemStack getItemStackwNBT(int pAmount, NBTTagCompound pTag) {
        ItemStack tRet = null;
        tRet = this.getItemStack(pAmount);
        if (pTag != null) {
            tRet.func_77982_d(pTag);
        }
        return tRet;
    }

    public ItemStack getItemStackwNBT(int pAmount, String pTag) {
        NBTTagCompound tNBT = null;
        boolean tDamagedNBT = false;
        try {
            if (!pTag.isEmpty()) {
                tNBT = (NBTTagCompound)JsonToNBT.func_150315_a((String)pTag);
            }
        }
        catch (Exception e) {
            _mLog.error(String.format("Found invalid NBT Tag: %s", pTag));
            tDamagedNBT = true;
        }
        if (!tDamagedNBT) {
            return this.getItemStackwNBT(pAmount, tNBT);
        }
        return null;
    }

    public String toString() {
        String tRet = String.format("%s:%s", this.mModID, this.mItemName);
        if (this.mMetaID > 0) {
            tRet = String.format("%s:%d", tRet, this.mMetaID);
        }
        return tRet;
    }
}

