/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpace;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GridSpaceHolder {
    public GridSpace[][] area = new GridSpace[1][1];
    public int negXRadius;
    public int posXRadius;
    public int negZRadius;
    public int posZRadius;

    public GridSpaceHolder() {
        this.area[0][0] = new GridSpace();
    }

    public void expandAreaInNegX() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 2][this.negZRadius + this.posZRadius + 1];
        for (i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
            newGrid[0][i] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i + 1][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.negXRadius;
    }

    public void expandAreaInPosX() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 2][this.negZRadius + this.posZRadius + 1];
        for (i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
            newGrid[this.negXRadius + this.posXRadius + 1][i] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.posXRadius;
    }

    public void expandAreaInNegZ() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 2];
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            newGrid[i][0] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j + 1] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.negZRadius;
    }

    public void expandAreaInPosZ() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 2];
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            newGrid[i][this.negZRadius + this.posZRadius + 1] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.posZRadius;
    }

    public GridSpace getGridSpace(int x, int z) {
        if (x > this.posXRadius || x < -this.negXRadius || z > this.posZRadius || z < -this.negZRadius) {
            return new GridSpace();
        }
        return this.area[x + this.negXRadius][z + this.negZRadius];
    }

    public void setGridSpace(int x, int z, GridSpace space) {
        if (x > this.posXRadius) {
            this.expandAreaInPosX();
            this.setGridSpace(x, z, space);
        } else if (x < -this.negXRadius) {
            this.expandAreaInNegX();
            this.setGridSpace(x, z, space);
        } else if (z > this.posZRadius) {
            this.expandAreaInPosZ();
            this.setGridSpace(x, z, space);
        } else if (z < -this.negZRadius) {
            this.expandAreaInNegZ();
            this.setGridSpace(x, z, space);
        } else {
            this.area[x + this.negXRadius][z + this.negZRadius] = space;
        }
    }

    public boolean doesContainAll(GridSpaceHolder master, int xInit, int zInit, ForgeDirection dir) {
        if (master != null) {
            if (TEDemonPortal.printDebug) {
                AlchemicalWizardry.logger.info("negXRadius: " + this.negXRadius + " posXRadius: " + this.posXRadius + " negZRadius: " + this.negZRadius + " posZRadius: " + this.posZRadius);
            }
            for (int i = -this.negXRadius; i <= this.posXRadius; ++i) {
                for (int j = -this.negZRadius; j <= this.posZRadius; ++j) {
                    int zOff;
                    int xOff;
                    GridSpace thisSpace = this.getGridSpace(i, j);
                    if (thisSpace.isEmpty()) continue;
                    if (TEDemonPortal.printDebug) {
                        AlchemicalWizardry.logger.info("x: " + i + " z: " + j);
                    }
                    switch (dir) {
                        case SOUTH: {
                            xOff = -i;
                            zOff = -j;
                            break;
                        }
                        case WEST: {
                            xOff = j;
                            zOff = -i;
                            break;
                        }
                        case EAST: {
                            xOff = -j;
                            zOff = i;
                            break;
                        }
                        default: {
                            xOff = i;
                            zOff = j;
                        }
                    }
                    if (master.getGridSpace(xInit + xOff, zInit + zOff).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void setAllGridSpaces(int xInit, int zInit, int yLevel, ForgeDirection dir, int type, GridSpaceHolder master) {
        if (TEDemonPortal.printDebug) {
            AlchemicalWizardry.logger.info("Grid space selected: (" + xInit + "," + zInit + ")");
        }
        if (master != null) {
            for (int i = -this.negXRadius; i <= this.posXRadius; ++i) {
                for (int j = -this.negZRadius; j <= this.posZRadius; ++j) {
                    int zOff;
                    int xOff;
                    GridSpace thisSpace = this.getGridSpace(i, j);
                    if (thisSpace.isEmpty()) continue;
                    switch (dir) {
                        case SOUTH: {
                            xOff = -i;
                            zOff = -j;
                            break;
                        }
                        case WEST: {
                            xOff = j;
                            zOff = -i;
                            break;
                        }
                        case EAST: {
                            xOff = -j;
                            zOff = i;
                            break;
                        }
                        default: {
                            xOff = i;
                            zOff = j;
                        }
                    }
                    if (TEDemonPortal.printDebug) {
                        AlchemicalWizardry.logger.info("Grid space (" + (xInit + xOff) + "," + (zInit + zOff) + ")");
                    }
                    master.setGridSpace(xInit + xOff, zInit + zOff, new GridSpace(type, yLevel));
                }
            }
        }
    }

    public void destroyAllInGridSpaces(World world, int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        for (int i = -this.negXRadius; i <= this.posXRadius; ++i) {
            for (int j = -this.negZRadius; j <= this.posZRadius; ++j) {
                int zOff;
                int xOff;
                GridSpace thisSpace = this.getGridSpace(i, j);
                if (thisSpace.isEmpty()) continue;
                switch (dir) {
                    case SOUTH: {
                        xOff = -i;
                        zOff = -j;
                        break;
                    }
                    case WEST: {
                        xOff = j;
                        zOff = -i;
                        break;
                    }
                    case EAST: {
                        xOff = -j;
                        zOff = i;
                        break;
                    }
                    default: {
                        xOff = i;
                        zOff = j;
                    }
                }
                for (int l = -2; l <= 2; ++l) {
                    for (int m = -2; m <= 2; ++m) {
                        Block block = world.func_147439_a(xCoord + xOff * 5 + l, yCoord, zCoord + zOff * 5 + m);
                        if (block == ModBlocks.blockDemonPortal) continue;
                        world.func_147468_f(xCoord + xOff * 5 + l, yCoord, zCoord + zOff * 5 + m);
                    }
                }
            }
        }
    }

    public int getNumberOfGridSpaces() {
        int num = 0;
        for (int i = -this.negXRadius; i <= this.posXRadius; ++i) {
            for (int j = -this.negZRadius; j <= this.posZRadius; ++j) {
                if (this.getGridSpace(i, j).isEmpty()) continue;
                ++num;
            }
        }
        return num;
    }
}

