/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.ISystemListener;
import vswe.stevesfactory.blocks.ITileEntityInterface;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityBUD;
import vswe.stevesfactory.blocks.TileEntityCluster;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.blocks.TileEntityInput;
import vswe.stevesfactory.blocks.WorldCoordinate;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.ComponentMenuCraftingPriority;
import vswe.stevesfactory.components.ComponentMenuGroup;
import vswe.stevesfactory.components.ComponentMenuInterval;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.ComponentMenuTarget;
import vswe.stevesfactory.components.ComponentMenuVariable;
import vswe.stevesfactory.components.ComponentType;
import vswe.stevesfactory.components.Connection;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.ConnectionSet;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.Point;
import vswe.stevesfactory.components.TriggerHelperBUD;
import vswe.stevesfactory.components.TriggerHelperRedstone;
import vswe.stevesfactory.components.Variable;
import vswe.stevesfactory.components.VariableColor;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.interfaces.IInterfaceRenderer;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IComponentNetworkReader;
import vswe.stevesfactory.network.PacketHandler;
import vswe.stevesfactory.settings.Settings;

public class TileEntityManager
extends TileEntity
implements ITileEntityInterface {
    public static final TriggerHelperRedstone redstoneTrigger = new TriggerHelperRedstone(3, 4);
    public static final TriggerHelperRedstone redstoneCondition = new TriggerHelperRedstone(1, 2);
    public static final TriggerHelperBUD budTrigger = new TriggerHelperBUD();
    public static final int BUTTON_SIZE_W = 14;
    public static final int BUTTON_SIZE_H = 14;
    public static final int BUTTON_SRC_X = 242;
    public static final int BUTTON_SRC_Y = 0;
    public static final int BUTTON_INNER_SIZE_W = 12;
    public static final int BUTTON_INNER_SIZE_H = 12;
    public static final int BUTTON_INNER_SRC_X = 230;
    public static final int BUTTON_INNER_SRC_Y = 0;
    private List<FlowComponent> items;
    private Connection currentlyConnecting;
    public List<Button> buttons;
    public boolean justSentServerComponentRemovalPacket;
    private List<FlowComponent> zLevelRenderingList;
    private Variable[] variables;
    private FlowComponent selectedComponent;
    @SideOnly(value=Side.CLIENT)
    public IInterfaceRenderer specialRenderer;
    private List<Integer> removedIds;
    List<ConnectionBlock> inventories = new ArrayList<ConnectionBlock>();
    public static final int MAX_CABLE_LENGTH = 128;
    public static final int MAX_COMPONENT_AMOUNT = 511;
    public static final int MAX_CONNECTED_INVENTORIES = 1023;
    private boolean firstInventoryUpdate = true;
    private boolean firstCommandExecution = true;
    private int timer = 0;
    private TileEntityManager self = this;
    private boolean usingUnlimitedInventories;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_COMPONENTS = "Components";
    private static final String NBT_VARIABLES = "Variables";

    public TileEntityManager() {
        int i;
        this.items = new ArrayList<FlowComponent>();
        this.zLevelRenderingList = new ArrayList<FlowComponent>();
        this.buttons = new ArrayList<Button>();
        this.removedIds = new ArrayList<Integer>();
        this.variables = new Variable[VariableColor.values().length];
        for (i = 0; i < this.variables.length; ++i) {
            this.variables[i] = new Variable(i);
        }
        for (i = 0; i < ComponentType.values().length; ++i) {
            this.buttons.add(new ButtonCreate(ComponentType.values()[i]));
        }
        this.buttons.add(new Button(Localization.DELETE_COMMAND){

            @Override
            protected void onClick(DataReader dr) {
                int idToRemove = dr.readComponentId();
                TileEntityManager.this.removeFlowComponent(idToRemove);
            }

            @Override
            public boolean onClick(DataWriter dw) {
                TileEntityManager.this.justSentServerComponentRemovalPacket = true;
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    dw.writeComponentId(TileEntityManager.this.self, item.getId());
                    return true;
                }
                return false;
            }

            @Override
            public boolean activateOnRelease() {
                return true;
            }
        });
        this.buttons.add(new Button(Localization.PREFERENCES){

            @Override
            protected void onClick(DataReader dr) {
            }

            @Override
            public boolean onClick(DataWriter dw) {
                Settings.openMenu(TileEntityManager.this.self);
                return false;
            }
        });
        this.buttons.add(new Button(Localization.EXIT_GROUP){

            @Override
            protected void onClick(DataReader dr) {
                int id = dr.readComponentId();
                FlowComponent component = (FlowComponent)TileEntityManager.this.items.get(id);
                boolean moveCluster = dr.readBoolean();
                if (component.getParent() != null) {
                    ComponentMenuGroup.moveComponents(component, component.getParent().getParent(), moveCluster);
                }
            }

            @Override
            public boolean onClick(DataWriter dw) {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    TileEntityManager.this.justSentServerComponentRemovalPacket = true;
                    dw.writeComponentId(TileEntityManager.this.self, item.getId());
                    dw.writeBoolean(GuiScreen.func_146272_n());
                    item.resetPosition();
                    return true;
                }
                TileEntityManager.this.selectedComponent = TileEntityManager.this.selectedComponent.getParent();
                return false;
            }

            @Override
            public boolean isVisible() {
                return !((TileEntityManager)TileEntityManager.this).field_145850_b.field_72995_K || TileEntityManager.this.selectedComponent != null;
            }

            @Override
            public boolean activateOnRelease() {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getMouseOver() {
                for (FlowComponent item : TileEntityManager.this.items) {
                    if (!item.isBeingMoved()) continue;
                    return Localization.EXIT_GROUP_DROP.toString();
                }
                return super.getMouseOver();
            }
        });
    }

    public void removeFlowComponent(int idToRemove, List<FlowComponent> items) {
        int i;
        for (i = items.size() - 1; i >= 0; --i) {
            FlowComponent component = items.get(i);
            if (i == idToRemove) {
                component.setParent(null);
                items.remove(i);
                continue;
            }
            component.updateConnectionIdsAtRemoval(idToRemove);
        }
        if (this.selectedComponent != null && this.selectedComponent.getId() == idToRemove) {
            this.selectedComponent = null;
        }
        for (i = idToRemove; i < items.size(); ++i) {
            items.get(i).decreaseId();
        }
    }

    public void removeFlowComponent(int idToRemove) {
        this.removeFlowComponent(idToRemove, this.items);
        if (!this.field_145850_b.field_72995_K) {
            this.removedIds.add(idToRemove);
        } else {
            for (int i = 0; i < this.zLevelRenderingList.size(); ++i) {
                if (this.zLevelRenderingList.get(i).getId() != idToRemove) continue;
                this.zLevelRenderingList.remove(i);
                break;
            }
        }
        this.updateVariables();
    }

    public List<FlowComponent> getFlowItems() {
        return this.items;
    }

    public List<FlowComponent> getZLevelRenderingList() {
        return this.zLevelRenderingList;
    }

    public List<ConnectionBlock> getConnectedInventories() {
        return this.inventories;
    }

    public void updateInventories() {
        this.usingUnlimitedInventories = false;
        WorldCoordinate[] oldCoordinates = new WorldCoordinate[this.inventories.size()];
        for (int i = 0; i < oldCoordinates.length; ++i) {
            TileEntity inventory = this.inventories.get(i).getTileEntity();
            oldCoordinates[i] = new WorldCoordinate(inventory.field_145851_c, inventory.field_145848_d, inventory.field_145849_e);
            oldCoordinates[i].setTileEntity(inventory);
        }
        ArrayList<WorldCoordinate> visited = new ArrayList<WorldCoordinate>();
        this.inventories.clear();
        PriorityQueue<WorldCoordinate> queue = new PriorityQueue<WorldCoordinate>();
        WorldCoordinate start = new WorldCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            WorldCoordinate element = (WorldCoordinate)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        WorldCoordinate target;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || visited.contains(target = new WorldCoordinate(element.getX() + x, element.getY() + y, element.getZ() + z, element.getDepth() + 1)) || !Settings.isLimitless(this) && this.inventories.size() >= 1023) continue;
                        visited.add(target);
                        TileEntity te = this.field_145850_b.func_147438_o(target.getX(), target.getY(), target.getZ());
                        if (te instanceof TileEntityCluster) {
                            for (TileEntityClusterElement tileEntityClusterElement : ((TileEntityCluster)te).getElements()) {
                                ((TileEntityCluster)te).setWorldObject(tileEntityClusterElement);
                                this.addInventory(tileEntityClusterElement, target);
                            }
                        } else {
                            this.addInventory(te, target);
                        }
                        if (!Settings.isLimitless(this) && element.getDepth() >= 128 || !ModBlocks.blockCable.isCable(this.field_145850_b.func_147439_a(target.getX(), target.getY(), target.getZ()), this.field_145850_b.func_72805_g(target.getX(), target.getY(), target.getZ()))) continue;
                        queue.add(target);
                    }
                }
            }
        }
        if (!this.firstInventoryUpdate) {
            for (WorldCoordinate oldCoordinate : oldCoordinates) {
                if (!(oldCoordinate.getTileEntity() instanceof ISystemListener)) continue;
                boolean found = false;
                for (ConnectionBlock inventory : this.inventories) {
                    if (oldCoordinate.getX() != inventory.getTileEntity().field_145851_c || oldCoordinate.getY() != inventory.getTileEntity().field_145848_d || oldCoordinate.getZ() != inventory.getTileEntity().field_145849_e) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ((ISystemListener)oldCoordinate.getTileEntity()).removed(this);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.updateInventorySelection(oldCoordinates);
            } else {
                for (FlowComponent item : this.items) {
                    item.setInventoryListDirty(true);
                }
            }
        }
        this.firstInventoryUpdate = false;
    }

    private void addInventory(TileEntity te, WorldCoordinate target) {
        ConnectionBlock connection = new ConnectionBlock(te, target.getDepth());
        boolean isValidConnection = false;
        for (ConnectionBlockType connectionBlockType : ConnectionBlockType.values()) {
            if (!connectionBlockType.isInstance(connection.getTileEntity())) continue;
            isValidConnection = true;
            connection.addType(connectionBlockType);
        }
        if (isValidConnection) {
            connection.setId(this.variables.length + this.inventories.size());
            if (target.getDepth() >= 128 || this.inventories.size() >= 1023) {
                this.usingUnlimitedInventories = true;
            }
            this.inventories.add(connection);
            if (connection.getTileEntity() instanceof ISystemListener) {
                ((ISystemListener)connection.getTileEntity()).added(this);
            }
        }
    }

    private void updateInventorySelection(WorldCoordinate[] oldCoordinates) {
        for (FlowComponent item : this.items) {
            for (ComponentMenu menu : item.getMenus()) {
                if (!(menu instanceof ComponentMenuContainer)) continue;
                ComponentMenuContainer menuInventory = (ComponentMenuContainer)menu;
                List<Integer> oldSelection = menuInventory.getSelectedInventories();
                menuInventory.setSelectedInventories(this.getNewSelection(oldCoordinates, oldSelection, true));
            }
        }
        for (Variable variable : this.variables) {
            variable.setContainers(this.getNewSelection(oldCoordinates, variable.getContainers(), false));
        }
    }

    private List<Integer> getNewSelection(WorldCoordinate[] oldCoordinates, List<Integer> oldSelection, boolean hasVariables) {
        ArrayList<Integer> newSelection = new ArrayList<Integer>();
        block0: for (int i = 0; i < oldSelection.size(); ++i) {
            int selection = oldSelection.get(i);
            if (hasVariables && selection >= 0 && selection < 16) {
                newSelection.add(selection);
                continue;
            }
            if (hasVariables) {
                selection -= this.variables.length;
            }
            if (selection < 0 || selection >= oldCoordinates.length) continue;
            WorldCoordinate coordinate = oldCoordinates[selection];
            for (int j = 0; j < this.inventories.size(); ++j) {
                TileEntity inventory = this.inventories.get(j).getTileEntity();
                if (coordinate.getX() != inventory.field_145851_c || coordinate.getY() != inventory.field_145848_d || coordinate.getZ() != inventory.field_145849_e || !inventory.getClass().equals(coordinate.getTileEntity().getClass())) continue;
                int id = j + (hasVariables ? this.variables.length : 0);
                if (newSelection.contains(id)) continue block0;
                newSelection.add(id);
                continue block0;
            }
        }
        return newSelection;
    }

    public Connection getCurrentlyConnecting() {
        return this.currentlyConnecting;
    }

    public void setCurrentlyConnecting(Connection currentlyConnecting) {
        this.currentlyConnecting = currentlyConnecting;
    }

    public void func_145845_h() {
        this.justSentServerComponentRemovalPacket = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.timer >= 20) {
                this.timer = 0;
                for (FlowComponent item : this.items) {
                    ComponentMenuInterval componentMenuInterval;
                    int interval;
                    if (item.getType() != ComponentType.TRIGGER || (interval = (componentMenuInterval = (ComponentMenuInterval)item.getMenus().get(2)).getInterval()) == 0) continue;
                    item.setCurrentInterval(item.getCurrentInterval() + 1);
                    if (item.getCurrentInterval() < interval) continue;
                    item.setCurrentInterval(0);
                    EnumSet<ConnectionOption> valid = EnumSet.of(ConnectionOption.INTERVAL);
                    if (item.getConnectionSet() == ConnectionSet.REDSTONE) {
                        redstoneTrigger.onTrigger(item, valid);
                    } else if (item.getConnectionSet() == ConnectionSet.BUD) {
                        budTrigger.onTrigger(item, valid);
                    }
                    this.activateTrigger(item, valid);
                }
            } else {
                ++this.timer;
            }
        }
    }

    public void updateFirst() {
        if (this.firstCommandExecution) {
            this.updateInventories();
            this.updateVariables();
            this.firstCommandExecution = false;
        }
    }

    public void activateTrigger(FlowComponent component, EnumSet<ConnectionOption> validTriggerOutputs) {
        this.updateFirst();
        for (ConnectionBlock inventory : this.inventories) {
            if (!inventory.getTileEntity().func_145837_r()) continue;
            this.updateInventories();
            break;
        }
        new CommandExecutor(this).executeTriggerCommand(component, validTriggerOutputs);
    }

    public void triggerRedstone(TileEntityInput inputTrigger) {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.REDSTONE) continue;
            redstoneTrigger.onRedstoneTrigger(item, inputTrigger);
        }
    }

    public void triggerChat() {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.CHAT) continue;
            this.activateTrigger(item, EnumSet.allOf(ConnectionOption.class));
        }
    }

    public void readGenericData(DataReader dr) {
        if (this.field_145850_b.field_72995_K) {
            if (dr.readBoolean()) {
                this.updateInventories();
            } else {
                this.removeFlowComponent(dr.readComponentId());
            }
        } else {
            Button button;
            int buttonId = dr.readData(DataBitHelper.GUI_BUTTON_ID);
            if (buttonId >= 0 && buttonId < this.buttons.size() && (button = this.buttons.get(buttonId)).isVisible()) {
                button.onClick(dr);
            }
        }
    }

    public List<Integer> getRemovedIds() {
        return this.removedIds;
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return new ContainerManager((TileEntityManager)te, inv);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return new GuiManager((TileEntityManager)te, inv);
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        this.updateInventories();
        int flowControlCount = dr.readComponentId();
        this.getFlowItems().clear();
        this.getZLevelRenderingList().clear();
        for (int i = 0; i < flowControlCount; ++i) {
            this.readAllComponentData(dr);
        }
        for (FlowComponent item : this.items) {
            item.linkParentAfterLoad();
        }
        if (Settings.isAutoCloseGroup()) {
            this.selectedComponent = null;
        } else {
            while (this.selectedComponent != null && !this.findNewSelectedComponent(this.selectedComponent.getId())) {
                this.selectedComponent = this.selectedComponent.getParent();
            }
        }
    }

    private boolean findNewSelectedComponent(int id) {
        for (FlowComponent item : this.items) {
            if (item.getId() != id) continue;
            this.selectedComponent = item;
            return true;
        }
        return false;
    }

    private void readAllComponentData(DataReader dr) {
        int x = dr.readData(DataBitHelper.FLOW_CONTROL_X);
        int y = dr.readData(DataBitHelper.FLOW_CONTROL_Y);
        int id = dr.readData(DataBitHelper.FLOW_CONTROL_TYPE_ID);
        FlowComponent flowComponent = new FlowComponent(this, x, y, ComponentType.getTypeFromId(id));
        flowComponent.setComponentName(dr.readString(DataBitHelper.NAME_LENGTH));
        boolean hasParent = dr.readBoolean();
        if (hasParent) {
            flowComponent.setParentLoadId(dr.readComponentId());
        } else {
            flowComponent.setParentLoadId(-1);
        }
        for (ComponentMenu menu : flowComponent.getMenus()) {
            menu.readData(dr);
        }
        flowComponent.clearConnections();
        for (int i = 0; i < flowComponent.getConnectionSet().getConnections().length; ++i) {
            boolean hasConnection = dr.readBoolean();
            if (!hasConnection) continue;
            Connection connection = new Connection(dr.readComponentId(), dr.readData(DataBitHelper.CONNECTION_ID));
            flowComponent.setConnection(i, connection);
            int length = dr.readData(DataBitHelper.NODE_ID);
            for (int j = 0; j < length; ++j) {
                connection.getNodes().add(new Point(dr.readData(DataBitHelper.FLOW_CONTROL_X), dr.readData(DataBitHelper.FLOW_CONTROL_Y)));
            }
        }
        this.getFlowItems().add(flowComponent);
        this.getZLevelRenderingList().add(0, flowComponent);
        this.updateVariables();
    }

    private boolean isUsingUnlimitedStuff() {
        return this.items.size() > 511 || this.usingUnlimitedInventories;
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        boolean isNew;
        if (!this.field_145850_b.field_72995_K && dr.readBoolean()) {
            boolean val = dr.readBoolean();
            if ((val || !this.isUsingUnlimitedStuff()) && player.field_71075_bZ.field_75098_d) {
                Settings.setLimitless(this, val);
            }
            return;
        }
        boolean bl = isNew = this.field_145850_b.field_72995_K && dr.readBoolean();
        if (isNew) {
            this.readAllComponentData(dr);
            this.items.get(this.items.size() - 1).linkParentAfterLoad();
        } else {
            boolean isSpecificComponent = dr.readBoolean();
            if (isSpecificComponent) {
                IComponentNetworkReader nr = this.getNetworkReaderForComponentPacket(dr, this);
                if (nr != null) {
                    nr.readNetworkComponent(dr);
                }
            } else {
                this.readGenericData(dr);
            }
        }
    }

    @Override
    public void writeAllData(DataWriter dw) {
        dw.writeComponentId(this, this.getFlowItems().size());
        for (FlowComponent flowComponent : this.getFlowItems()) {
            PacketHandler.writeAllComponentData(dw, flowComponent);
        }
    }

    private IComponentNetworkReader getNetworkReaderForComponentPacket(DataReader dr, TileEntityManager jam) {
        int componentId = dr.readComponentId();
        if (componentId >= 0 && componentId < jam.getFlowItems().size()) {
            FlowComponent component = jam.getFlowItems().get(componentId);
            if (dr.readBoolean()) {
                int menuId = dr.readData(DataBitHelper.FLOW_CONTROL_MENU_COUNT);
                if (menuId >= 0 && menuId < component.getMenus().size()) {
                    return component.getMenus().get(menuId);
                }
            } else {
                return component;
            }
        }
        return null;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void updateVariables() {
        for (Variable variable : this.variables) {
            variable.setDeclaration(null);
        }
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.VARIABLE || item.getConnectionSet() != ConnectionSet.EMPTY) continue;
            int selectedVariable = ((ComponentMenuVariable)item.getMenus().get(0)).getSelectedVariable();
            this.variables[selectedVariable].setDeclaration(item);
        }
    }

    public void triggerBUD(TileEntityBUD tileEntityBUD) {
        for (FlowComponent item : this.items) {
            if (item.getType() != ComponentType.TRIGGER || item.getConnectionSet() != ConnectionSet.BUD) continue;
            budTrigger.triggerBUD(item, tileEntityBUD);
        }
    }

    public FlowComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(FlowComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readContentFromNBT(nbtTagCompound, false);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeContentToNBT(nbtTagCompound, false);
    }

    public void readContentFromNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        this.timer = nbtTagCompound.func_74771_c(NBT_TIMER);
        NBTTagList components = nbtTagCompound.func_150295_c(NBT_COMPONENTS, 10);
        for (int i = 0; i < components.func_74745_c(); ++i) {
            NBTTagCompound component = components.func_150305_b(i);
            this.items.add(FlowComponent.readFromNBT(this, component, version, pickup));
        }
        if (version == 8) {
            for (FlowComponent item : this.items) {
                for (int i = 0; i < item.getConnectionSet().getConnections().length; ++i) {
                    Connection connection = item.getConnection(i);
                    if (connection == null) continue;
                    if (connection.getComponentId() < 0 || connection.getComponentId() >= this.items.size()) {
                        item.setConnection(i, null);
                        continue;
                    }
                    FlowComponent otherItem = this.getFlowItems().get(connection.getComponentId());
                    Connection otherConnection = otherItem.getConnection(connection.getConnectionId());
                    if (otherConnection != null && otherConnection.getComponentId() >= 0 && otherConnection.getComponentId() < this.items.size()) continue;
                    otherItem.setConnection(connection.getConnectionId(), new Connection(item.getId(), i));
                }
            }
        }
        for (FlowComponent item : this.items) {
            item.linkParentAfterLoad();
        }
        NBTTagList variablesTag = nbtTagCompound.func_150295_c(NBT_VARIABLES, 10);
        for (int i = 0; i < variablesTag.func_74745_c(); ++i) {
            NBTTagCompound variableTag = variablesTag.func_150305_b(i);
            this.variables[i].readFromNBT(variableTag);
        }
    }

    public void writeContentToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)12);
        nbtTagCompound.func_74774_a(NBT_TIMER, (byte)this.timer);
        NBTTagList components = new NBTTagList();
        for (FlowComponent item : this.items) {
            NBTTagCompound component = new NBTTagCompound();
            item.writeToNBT(component, pickup);
            components.func_74742_a((NBTBase)component);
        }
        nbtTagCompound.func_74782_a(NBT_COMPONENTS, (NBTBase)components);
        NBTTagList variablesTag = new NBTTagList();
        for (Variable variable : this.variables) {
            NBTTagCompound variableTag = new NBTTagCompound();
            variable.writeToNBT(variableTag);
            variablesTag.func_74742_a((NBTBase)variableTag);
        }
        nbtTagCompound.func_74782_a(NBT_VARIABLES, (NBTBase)variablesTag);
    }

    private class ButtonCreate
    extends Button {
        private ComponentType type;

        protected ButtonCreate(ComponentType type) {
            super(type.getLongUnLocalizedName());
            this.type = type;
        }

        @Override
        protected void onClick(DataReader dr) {
            if (Settings.isLimitless(TileEntityManager.this.self) || TileEntityManager.this.getFlowItems().size() < 511) {
                boolean isOutput;
                FlowComponent component = new FlowComponent(TileEntityManager.this.self, 50, 50, this.type);
                boolean hasParent = dr.readBoolean();
                if (hasParent) {
                    component.setParent((FlowComponent)TileEntityManager.this.items.get(dr.readComponentId()));
                }
                boolean autoSide = dr.readBoolean();
                boolean autoBlackList = dr.readBoolean();
                boolean moveFirst = dr.readBoolean();
                boolean isInput = this.type == ComponentType.INPUT || this.type == ComponentType.LIQUID_INPUT;
                boolean bl = isOutput = this.type == ComponentType.OUTPUT || this.type == ComponentType.LIQUID_OUTPUT;
                if (autoSide) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuTarget)) continue;
                        ((ComponentMenuTarget)componentMenu).setActive(isOutput ? 1 : 0);
                    }
                }
                if (autoBlackList && isInput) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuStuff)) continue;
                        ((ComponentMenuStuff)componentMenu).setBlackList();
                    }
                }
                if (this.type == ComponentType.AUTO_CRAFTING) {
                    for (ComponentMenu componentMenu : component.getMenus()) {
                        if (!(componentMenu instanceof ComponentMenuCraftingPriority)) continue;
                        ((ComponentMenuCraftingPriority)componentMenu).setPrioritizeCrafting(!moveFirst);
                    }
                }
                TileEntityManager.this.getFlowItems().add(component);
            }
        }

        @Override
        public boolean onClick(DataWriter dw) {
            if (TileEntityManager.this.selectedComponent != null) {
                dw.writeBoolean(true);
                dw.writeComponentId(TileEntityManager.this.self, TileEntityManager.this.selectedComponent.getId());
            } else {
                dw.writeBoolean(false);
            }
            dw.writeBoolean(Settings.isAutoSide());
            dw.writeBoolean(Settings.isAutoBlacklist());
            dw.writeBoolean(Settings.isPriorityMoveFirst());
            return true;
        }

        @Override
        public String getMouseOver() {
            if (!Settings.isLimitless(TileEntityManager.this.self) && TileEntityManager.this.getFlowItems().size() == 511) {
                return Localization.MAXIMUM_COMPONENT_ERROR.toString();
            }
            return Localization.CREATE_COMMAND.toString() + " " + super.getMouseOver();
        }
    }

    public abstract class Button {
        private int x;
        private int y;
        private Localization mouseOver;

        protected Button(Localization mouseOver) {
            int id = TileEntityManager.this.buttons.size();
            this.x = 5 + id / 13 * 18;
            this.y = 5 + id % 13 * 18;
            this.mouseOver = mouseOver;
        }

        protected abstract void onClick(DataReader var1);

        public abstract boolean onClick(DataWriter var1);

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String getMouseOver() {
            return this.mouseOver.toString();
        }

        public boolean activateOnRelease() {
            return false;
        }

        public boolean isVisible() {
            return true;
        }
    }
}

