/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.commands;

import mods.railcraft.common.commands.IModCommand;
import mods.railcraft.common.commands.SubCommand;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandHelpers {
    public static World getWorld(ICommandSender sender, IModCommand command, String[] args, int worldArgIndex) {
        if (worldArgIndex < args.length) {
            try {
                int dim = Integer.parseInt(args[worldArgIndex]);
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
                if (world != null) {
                    return world;
                }
            }
            catch (Exception ex) {
                CommandHelpers.throwWrongUsage(sender, command);
            }
        }
        return CommandHelpers.getWorld(sender, command);
    }

    public static World getWorld(ICommandSender sender, IModCommand command) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return player.field_70170_p;
        }
        return MinecraftServer.func_71276_C().func_71218_a(0);
    }

    public static String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, String locTag, Object ... args) {
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation(locTag, args));
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, ChatStyle chatStyle, String locTag, Object ... args) {
        ChatComponentTranslation chat = new ChatComponentTranslation(locTag, args);
        chat.func_150255_a(chatStyle);
        sender.func_145747_a((IChatComponent)chat);
    }

    public static void sendChatMessage(ICommandSender sender, String message) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static void throwWrongUsage(ICommandSender sender, IModCommand command) throws WrongUsageException {
        throw new WrongUsageException(LocalizationPlugin.translate("command.railcraft.help", command.func_71518_a(sender)), new Object[0]);
    }

    public static void processChildCommand(ICommandSender sender, SubCommand child, String[] args) {
        if (!sender.func_70003_b(child.getRequiredPermissionLevel(), child.getFullCommandString())) {
            throw new WrongUsageException(LocalizationPlugin.translate("command.railcraft.noperms"), new Object[0]);
        }
        String[] newargs = new String[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, newargs.length);
        child.func_71515_b(sender, newargs);
    }

    public static void printHelp(ICommandSender sender, IModCommand command) {
        ChatStyle header = new ChatStyle();
        header.func_150238_a(EnumChatFormatting.BLUE);
        CommandHelpers.sendLocalizedChatMessage(sender, header, "command.railcraft." + command.getFullCommandString().replace(" ", ".") + ".format", command.getFullCommandString());
        ChatStyle body = new ChatStyle();
        body.func_150238_a(EnumChatFormatting.GRAY);
        CommandHelpers.sendLocalizedChatMessage(sender, body, "command.railcraft.aliases", command.func_71514_a().toString().replace("[", "").replace("]", ""));
        CommandHelpers.sendLocalizedChatMessage(sender, body, "command.railcraft.permlevel", command.getRequiredPermissionLevel());
        CommandHelpers.sendLocalizedChatMessage(sender, body, "command.railcraft." + command.getFullCommandString().replace(" ", ".") + ".help", new Object[0]);
        if (!command.getChildren().isEmpty()) {
            CommandHelpers.sendLocalizedChatMessage(sender, "command.railcraft.list", new Object[0]);
            for (SubCommand child : command.getChildren()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "command.railcraft." + child.getFullCommandString().replace(" ", ".") + ".desc", child.func_71517_b());
            }
        }
    }

    public static boolean processStandardCommands(ICommandSender sender, IModCommand command, String[] args) {
        if (args.length >= 1) {
            if (args[0].equals("help")) {
                command.printHelp(sender);
                return true;
            }
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(args[0], child)) continue;
                CommandHelpers.processChildCommand(sender, child, args);
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String commandName, IModCommand command) {
        if (commandName.equals(command.func_71517_b())) {
            return true;
        }
        if (command.func_71514_a() != null) {
            for (String alias : command.func_71514_a()) {
                if (!commandName.equals(alias)) continue;
                return true;
            }
        }
        return false;
    }
}

