/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gttweaker.GTTweaker;
import gttweaker.mods.gregtech.GTRecipeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.RA2")
@ModOnly(value={"gregtech"})
public class RA2Builder {
    private GT_RecipeBuilder recipeBuilder;

    public RA2Builder() {
    }

    public RA2Builder(GT_RecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
    }

    @ZenMethod
    public static RA2Builder builder() {
        return new RA2Builder(GT_Values.RA.stdBuilder());
    }

    @ZenMethod
    public RA2Builder noItemInputs() {
        this.recipeBuilder.noItemInputs();
        return this;
    }

    @ZenMethod
    public RA2Builder itemInputs(IIngredient[] inputs) {
        if (inputs.length == 0) {
            this.recipeBuilder.noItemInputs();
        } else {
            this.recipeBuilder.itemInputs((ItemStack[])Arrays.stream(inputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        }
        return this;
    }

    @ZenMethod
    public RA2Builder noItemOutputs() {
        this.recipeBuilder.noItemOutputs();
        return this;
    }

    @ZenMethod
    public RA2Builder itemOutputs(IIngredient[] outputs) {
        if (outputs.length == 0) {
            this.recipeBuilder.noItemOutputs();
        } else {
            this.recipeBuilder.itemOutputs((ItemStack[])Arrays.stream(outputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        }
        return this;
    }

    @ZenMethod
    public RA2Builder noFluidInputs() {
        this.recipeBuilder.noFluidInputs();
        return this;
    }

    @ZenMethod
    public RA2Builder fluidInputs(IIngredient[] inputs) {
        if (inputs.length == 0) {
            this.recipeBuilder.noFluidInputs();
        } else {
            this.recipeBuilder.fluidInputs((FluidStack[])Arrays.stream(inputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new));
        }
        return this;
    }

    @ZenMethod
    public RA2Builder noFluidOutputs() {
        this.recipeBuilder.noFluidOutputs();
        return this;
    }

    @ZenMethod
    public RA2Builder fluidOutputs(IIngredient[] outputs) {
        if (outputs.length == 0) {
            this.recipeBuilder.noFluidOutputs();
        } else {
            this.recipeBuilder.fluidOutputs((FluidStack[])Arrays.stream(outputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new));
        }
        return this;
    }

    @ZenMethod
    public RA2Builder duration(int duration) {
        this.recipeBuilder.duration(duration);
        return this;
    }

    @ZenMethod
    public RA2Builder eut(int eut) {
        this.recipeBuilder.eut(eut);
        return this;
    }

    @ZenMethod
    public RA2Builder outputChances(int[] chances) {
        this.recipeBuilder.outputChances(chances);
        return this;
    }

    @ZenMethod
    public RA2Builder specialValue(int specialValue) {
        this.recipeBuilder.specialValue(specialValue);
        return this;
    }

    @ZenMethod
    public RA2Builder specialItem(IIngredient specialItem) {
        this.recipeBuilder.specialItem(GTTweaker.getItemStackOrNull(specialItem));
        return this;
    }

    @ZenMethod
    public RA2Builder noOptimize() {
        this.recipeBuilder.noOptimize();
        return this;
    }

    @ZenMethod
    public void addTo(String recipeMap) {
        GT_Recipe recipe = this.recipeBuilder.build().orElse(null);
        if (recipe == null) {
            MineTweakerAPI.logError((String)"Could not build recipe!");
            return;
        }
        GT_Recipe.GT_Recipe_Map map = GTRecipeMap.getRecipeMap(recipeMap);
        if (map == null) {
            MineTweakerAPI.logError((String)("Could not find recipe map named \"" + recipeMap + "\""));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RecipeAddAction(recipe, map));
    }

    public static class RecipeAddAction
    implements IUndoableAction {
        GT_Recipe recipe;
        GT_Recipe.GT_Recipe_Map map;

        public RecipeAddAction(GT_Recipe recipe, GT_Recipe.GT_Recipe_Map map) {
            this.recipe = recipe;
            this.map = map;
        }

        public void apply() {
            this.map.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.map.mRecipeList.remove(this.recipe);
            this.map.mRecipeItemMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).removeIf(r -> r == this.recipe) && ((Collection)e.getValue()).size() == 0).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(k -> {
                Collection cfr_ignored_0 = (Collection)this.map.mRecipeItemMap.remove(k);
            });
            this.map.mRecipeFluidMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).removeIf(r -> r == this.recipe) && ((Collection)e.getValue()).size() == 0).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(k -> {
                Collection cfr_ignored_0 = (Collection)this.map.mRecipeFluidMap.remove(k);
            });
        }

        public String describe() {
            return "RA2 - Adding recipe";
        }

        public String describeUndo() {
            return "RA2 - Removing recipe";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

