/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.profilers;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class Clock {
    public static ThreadMXBean threadMX = ManagementFactory.getThreadMXBean();
    public static boolean canThreadCPU = false;

    public static IClock getNewClock() {
        if (canThreadCPU) {
            return new Clock().new ClockMX();
        }
        return new Clock().new ClockNano();
    }

    public class ClockNano
    implements IClock {
        public long startTime = 0L;
        public long timeDelta = 0L;

        @Override
        public void start() {
            this.startTime = System.nanoTime();
        }

        @Override
        public void stop() {
            this.timeDelta = System.nanoTime() - this.startTime;
        }

        @Override
        public long getDelta() {
            return this.timeDelta;
        }
    }

    public class ClockMX
    implements IClock {
        public long startTime = 0L;
        public long timeDelta = 0L;

        @Override
        public void start() {
            this.startTime = threadMX.getCurrentThreadCpuTime();
        }

        @Override
        public void stop() {
            this.timeDelta = threadMX.getCurrentThreadCpuTime() - this.startTime;
        }

        @Override
        public long getDelta() {
            return this.timeDelta;
        }
    }

    public static interface IClock {
        public void start();

        public void stop();

        public long getDelta();
    }
}

