/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.matcher;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.DiagramMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.stream.Collectors;

public class ComponentDiagramMatcher
implements DiagramMatcher {
    protected final ImmutableMap<Interactable.RecipeType, ImmutableSetMultimap<Component, Diagram>> matchData;

    public ComponentDiagramMatcher(ImmutableMap<Interactable.RecipeType, ImmutableSetMultimap<Component, Diagram>> matchData) {
        this.matchData = matchData;
    }

    @Override
    public Collection<Diagram> all() {
        return this.matchData.values().stream().map(ImmutableMultimap::values).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Collection<Diagram> match(Interactable.RecipeType recipeType, Component component) {
        return ((ImmutableSetMultimap)this.matchData.get((Object)recipeType)).get((Object)component);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final EnumMap<Interactable.RecipeType, ImmutableSetMultimap.Builder<Component, Diagram>> matchDataBuilder = new EnumMap(Interactable.RecipeType.class);

        public Builder() {
            for (Interactable.RecipeType recipeType : Interactable.RecipeType.values()) {
                this.matchDataBuilder.put(recipeType, (ImmutableSetMultimap.Builder<Component, Diagram>)ImmutableSetMultimap.builder());
            }
        }

        public DiagramSubBuilder addDiagram(Diagram diagram) {
            return new DiagramSubBuilder(diagram);
        }

        public ComponentDiagramMatcher build() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.matchDataBuilder.forEach((key, value) -> builder.put((Object)key, (Object)value.build()));
            return new ComponentDiagramMatcher((ImmutableMap<Interactable.RecipeType, ImmutableSetMultimap<Component, Diagram>>)builder.build());
        }

        public final class DiagramSubBuilder {
            private final Diagram diagram;

            private DiagramSubBuilder(Diagram diagram) {
                this.diagram = diagram;
            }

            public DiagramSubBuilder addComponent(Component component) {
                for (Interactable.RecipeType recipeType : Interactable.RecipeType.values()) {
                    this.addComponent(recipeType, component);
                }
                return this;
            }

            public DiagramSubBuilder addAllComponents(Iterable<? extends Component> components) {
                for (Interactable.RecipeType recipeType : Interactable.RecipeType.values()) {
                    this.addAllComponents(recipeType, components);
                }
                return this;
            }

            public DiagramSubBuilder addComponent(Interactable.RecipeType recipeType, Component component) {
                ((ImmutableSetMultimap.Builder)Builder.this.matchDataBuilder.get((Object)recipeType)).put((Object)component, (Object)this.diagram);
                return this;
            }

            public DiagramSubBuilder addAllComponents(Interactable.RecipeType recipeType, Iterable<? extends Component> components) {
                ImmutableSetMultimap.Builder builder = (ImmutableSetMultimap.Builder)Builder.this.matchDataBuilder.get((Object)recipeType);
                components.forEach(c -> builder.put(c, (Object)this.diagram));
                return this;
            }
        }
    }
}

