/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.PageSpecies;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.LinkedHashMap;
import java.util.Map;

public class PageSpeciesClassification
extends PageSpecies {
    private Map<IClassification.EnumClassLevel, ControlText> levels = new LinkedHashMap<IClassification.EnumClassLevel, ControlText>();
    private ControlText genus;

    public PageSpeciesClassification(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        int y = 16;
        for (IClassification.EnumClassLevel level : IClassification.EnumClassLevel.values()) {
            ControlTextCentered text = new ControlTextCentered((IWidget)this, y, "");
            text.setColor(level.getColour());
            this.levels.put(level, text);
            y += 12;
        }
        this.genus = new ControlTextCentered((IWidget)this, y, "");
        this.genus.setColor(16759415);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        if (species == null) {
            return;
        }
        for (ControlText text : this.levels.values()) {
            text.setValue("- - -");
        }
        this.genus.setValue(species.getBinomial());
        for (IClassification classification = species.getBranch(); classification != null; classification = classification.getParent()) {
            IClassification.EnumClassLevel level = classification.getLevel();
            String text2 = "";
            text2 = text2 + classification.getScientific();
            this.levels.get(level).setValue(text2);
        }
    }
}

