/*
 * Decompiled with CFR 0.152.
 */
package kubatech.mixin;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kubatech.mixin.TargetedMod;

public enum Mixin {
    WorldMixin("minecraft.WorldMixin", TargetedMod.VANILLA),
    StringTranslateMixin("minecraft.StringTranslateMixin", TargetedMod.VANILLA),
    LanguageRegistryMixin("minecraft.LanguageRegistryMixin", TargetedMod.VANILLA),
    LocaleMixin("minecraft.LocaleMixin", Side.CLIENT, TargetedMod.VANILLA);

    public final String mixinClass;
    public final List<TargetedMod> targetedMods;
    private final Side side;

    private Mixin(String mixinClass, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = side;
    }

    private Mixin(String mixinClass, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = Side.BOTH;
    }

    public boolean shouldLoad(List<TargetedMod> loadedMods) {
        return (this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && new HashSet<TargetedMod>(loadedMods).containsAll(this.targetedMods);
    }

    static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

