/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.util;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.network.BlockFluidHandlerMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidHandlerData {
    public final int id;
    public WeakReference<IFluidHandler> te;
    public final WeakHashMap<EntityPlayer, NBTTagCompound> playerSet = new WeakHashMap();

    public FluidHandlerData(IFluidHandler fluidHandler, int id) {
        this.id = id;
        this.te = new WeakReference<IFluidHandler>(fluidHandler);
    }

    public void sendIfOld(EntityPlayerMP player) {
        IFluidHandler fluidHandler = (IFluidHandler)this.te.get();
        if (fluidHandler == null) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("id", this.id);
        data.func_74782_a("tank", (NBTBase)this.encodeFluidTankInfo(fluidHandler));
        if (!this.playerSet.containsKey(player) || !this.playerSet.get(player).equals((Object)data)) {
            this.playerSet.put((EntityPlayer)player, data);
            HoloInventory.getSnw().sendTo((IMessage)new BlockFluidHandlerMessage(data), player);
        }
    }

    private NBTTagList encodeFluidTankInfo(IFluidHandler fluidHandler) {
        NBTTagList tagList = new NBTTagList();
        FluidTankInfo[] tankInfos = fluidHandler.getTankInfo(ForgeDirection.UNKNOWN);
        if (tankInfos == null) {
            return tagList;
        }
        for (FluidTankInfo tankInfo : tankInfos) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            if (tankInfo.fluid == null) continue;
            tankInfo.fluid.writeToNBT(fluidTag);
            fluidTag.func_74768_a("capacity", tankInfo.capacity);
            tagList.func_74742_a((NBTBase)fluidTag);
        }
        return tagList;
    }

    public void update(IFluidHandler fluidHandler) {
        this.te = new WeakReference<IFluidHandler>(fluidHandler);
    }
}

