/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.io.Closeable;
import java.io.IOException;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.IOffhandDual;
import mods.battlegear2.api.IOffhandWield;
import mods.battlegear2.api.IUsableItem;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.core.InventorySlotType;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.ISpecialBow;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.WeaponRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;

public class BattlegearUtils {
    public static final EventBus RENDER_BUS = new EventBus();
    private static String[] itemBlackListMethodNames = new String[]{BattlegearTranslator.getMapedMethodName("func_77648_a", "onItemUse"), BattlegearTranslator.getMapedMethodName("onItemUseFirst", "onItemUseFirst"), BattlegearTranslator.getMapedMethodName("func_77659_a", "onItemRightClick")};
    private static Class[][] itemBlackListMethodParams = new Class[][]{{ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, World.class, EntityPlayer.class}};
    private static ItemStack prevNotWieldable;
    private static String genericAttack;

    public static boolean canBlockWithShield(EntityPlayer player) {
        if (!(player.field_71071_by instanceof InventoryPlayerBattle)) {
            return false;
        }
        ItemStack offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        return offhand != null && offhand.func_77973_b() instanceof IShield;
    }

    public static boolean isBlockingWithShield(EntityPlayer player) {
        return ((IBattlePlayer)player).isBlockingWithShield();
    }

    public static boolean isPlayerInBattlemode(EntityPlayer player) {
        return player.field_71071_by instanceof InventoryPlayerBattle && ((InventoryPlayerBattle)player.field_71071_by).isBattlemode();
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack, int offset) {
        ((InventoryPlayerBattle)player.field_71071_by).setInventorySlotContents(player.field_71071_by.field_70461_c + offset, stack, false);
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        BattlegearUtils.setPlayerCurrentItem(player, stack, 0);
    }

    public static void setPlayerOffhandItem(EntityPlayer player, ItemStack stack) {
        if (BattlegearUtils.isPlayerInBattlemode(player)) {
            BattlegearUtils.setPlayerCurrentItem(player, stack, InventoryPlayerBattle.WEAPON_SETS);
        }
    }

    public static boolean isWeapon(ItemStack main) {
        if (main.func_77973_b() instanceof IBattlegearWeapon) {
            return true;
        }
        if (main.func_77976_d() == 1 && main.func_77958_k() > 0 && !main.func_77981_g()) {
            return true;
        }
        if (main == prevNotWieldable) {
            return false;
        }
        if (WeaponRegistry.isWeapon(main)) {
            return true;
        }
        if (BattlegearUtils.checkWeaponOreDictEntries(main)) {
            return true;
        }
        if (!BattlegearUtils.checkForRightClickFunction(main)) {
            WeaponRegistry.addDualWeapon(main);
            return true;
        }
        prevNotWieldable = main;
        return false;
    }

    public static boolean checkWeaponOreDictEntries(ItemStack main) {
        int[] oreDictEntries = OreDictionary.getOreIDs((ItemStack)main);
        for (int i = 0; i < oreDictEntries.length; ++i) {
            int ore = oreDictEntries[i];
            String name = OreDictionary.getOreName((int)ore);
            if (!name.equals("craftingToolBlade") && !name.equals("craftingToolAxe")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off) {
        if (main == null) {
            return true;
        }
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off);
        }
        if (main.func_77973_b() instanceof IArrowContainer2) {
            return true;
        }
        if (BattlegearUtils.usagePriorAttack(main)) {
            return off == null || !BattlegearUtils.usagePriorAttack(off);
        }
        if (BattlegearUtils.isWeapon(main)) {
            return BattlegearUtils.checkWeaponOreDictEntries(main) || main.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isMainHand(main);
        }
        return false;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off, EntityPlayer wielder) {
        if (main == null) {
            return true;
        }
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off);
        }
        if (main.func_77973_b() instanceof IArrowContainer2) {
            return true;
        }
        if (BattlegearUtils.usagePriorAttack(main, wielder, false)) {
            return off == null || !BattlegearUtils.usagePriorAttack(off, wielder, true);
        }
        if (BattlegearUtils.isWeapon(main)) {
            return BattlegearUtils.checkWeaponOreDictEntries(main) || main.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isMainHand(main);
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off) {
        if (off == null) {
            return true;
        }
        if (off.func_77973_b() instanceof IOffhandDual) {
            return ((IOffhandDual)off.func_77973_b()).isOffhandHandDual(off);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(off)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            return BattlegearUtils.checkWeaponOreDictEntries(off) || off.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isOffHand(off);
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off, EntityPlayer wielder) {
        if (off == null) {
            return true;
        }
        if (off.func_77973_b() instanceof IOffhandDual) {
            return ((IOffhandDual)off.func_77973_b()).isOffhandHandDual(off);
        }
        if (off.func_77973_b() instanceof IOffhandWield) {
            return ((IOffhandWield)off.func_77973_b()).isOffhandWieldable(off, wielder);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(off, wielder, true)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            return BattlegearUtils.checkWeaponOreDictEntries(off) || off.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isOffHand(off);
        }
        return false;
    }

    public static boolean usagePriorAttack(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof IUsableItem) {
            return ((IUsableItem)itemStack.func_77973_b()).isUsedOverAttack(itemStack);
        }
        EnumAction useAction = itemStack.func_77975_n();
        return useAction == EnumAction.bow || useAction == EnumAction.drink || useAction == EnumAction.eat || BattlegearUtils.isCommonlyUsable(itemStack.func_77973_b());
    }

    public static boolean usagePriorAttack(ItemStack itemStack, EntityPlayer wielder, boolean off) {
        if (itemStack.func_77973_b() instanceof IUsableItem) {
            return ((IUsableItem)itemStack.func_77973_b()).isUsedOverAttack(itemStack);
        }
        EnumAction useAction = itemStack.func_77975_n();
        return useAction == EnumAction.bow || useAction == EnumAction.drink || useAction == EnumAction.eat || BattlegearUtils.isCommonlyUsable(itemStack.func_77973_b()) || WeaponRegistry.useOverAttack(itemStack, off);
    }

    public static boolean isCommonlyUsable(Item item) {
        return BattlegearUtils.isBow(item) || item instanceof ItemBlock || item instanceof ItemFlintAndSteel || item instanceof ItemFireball || item instanceof ItemBucket || item instanceof ItemSnowball || item instanceof ItemEnderPearl;
    }

    public static boolean isBow(Item item) {
        return item instanceof ItemBow || item instanceof ISpecialBow;
    }

    @Deprecated
    public static boolean checkForRightClickFunction(Item item, ItemStack stack) {
        return BattlegearUtils.checkForRightClickFunction(stack);
    }

    public static boolean checkForRightClickFunction(ItemStack stack) {
        if (stack.func_77975_n() == EnumAction.block || stack.func_77975_n() == EnumAction.none) {
            Class<?> c = stack.func_77973_b().getClass();
            while (!(c.equals(Item.class) || c.equals(ItemTool.class) || c.equals(ItemSword.class))) {
                if (BattlegearUtils.getBlackListedMethodIn(c)) {
                    return true;
                }
                c = c.getSuperclass();
            }
            return false;
        }
        return true;
    }

    private static boolean getBlackListedMethodIn(Class<?> c) {
        for (int i = 0; i < itemBlackListMethodNames.length; ++i) {
            try {
                c.getDeclaredMethod(itemBlackListMethodNames[i], itemBlackListMethodParams[i]);
                return true;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return false;
    }

    public static ItemStack readItemStack(ByteArrayDataInput par0DataInputStream) throws IOException {
        ItemStack itemstack = null;
        int short1 = par0DataInputStream.readInt();
        if (short1 >= 0) {
            byte b0 = par0DataInputStream.readByte();
            short short2 = par0DataInputStream.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = BattlegearUtils.readNBTTagCompound(par0DataInputStream);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput par0DataInputStream) throws IOException {
        short short1 = par0DataInputStream.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInputStream.readFully(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public static void writeItemStack(ByteArrayDataOutput par1DataOutputStream, ItemStack par0ItemStack) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeInt(Item.func_150891_b((Item)par0ItemStack.func_77973_b()));
            par1DataOutputStream.writeByte(par0ItemStack.field_77994_a);
            par1DataOutputStream.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            BattlegearUtils.writeNBTTagCompound(nbttagcompound, par1DataOutputStream);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, ByteArrayDataOutput par1DataOutputStream) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutputStream.writeShort((int)((short)abyte.length));
            par1DataOutputStream.write(abyte);
        }
    }

    public static InventoryPlayer replaceInventory(EntityPlayer entityPlayer) {
        return new InventoryPlayerBattle(entityPlayer);
    }

    public static int requestInventorySpace(EntityPlayer entityPlayer, InventorySlotType type) {
        return ((InventoryPlayerBattle)entityPlayer.field_71071_by).requestNewSlot(type);
    }

    public static void attackTargetEntityWithCurrentOffItem(EntityPlayer player, Entity par1Entity) {
        BattlegearUtils.refreshAttributes(player, false);
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, par1Entity))) {
            BattlegearUtils.refreshAttributes(player, true);
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b().onLeftClickEntity(stack, player, par1Entity)) {
            BattlegearUtils.refreshAttributes(player, true);
            return;
        }
        if (par1Entity.func_70075_an() && !par1Entity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = 0;
            float f1 = 0.0f;
            if (par1Entity instanceof EntityLivingBase) {
                f1 = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
                i += EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (player.func_70051_ag()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag2;
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && par1Entity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (par1Entity instanceof EntityLivingBase && j > 0 && !par1Entity.func_70027_ad()) {
                    flag1 = true;
                    par1Entity.func_70015_d(1);
                }
                if (flag2 = par1Entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), f)) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (flag) {
                        player.func_71009_b(par1Entity);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(par1Entity);
                    }
                    if (f >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(par1Entity);
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)par1Entity);
                    ItemStack itemstack = player.func_71045_bC();
                    Entity object = par1Entity;
                    if (par1Entity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)par1Entity).field_70259_a) != null && ientitymultipart instanceof EntityLivingBase) {
                        object = ientitymultipart;
                    }
                    if (itemstack != null && object instanceof EntityLivingBase) {
                        itemstack.func_77961_a((EntityLivingBase)object, player);
                        if (itemstack.field_77994_a <= 0) {
                            player.func_71028_bD();
                        }
                    }
                    if (par1Entity instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                        if (j > 0) {
                            par1Entity.func_70015_d(j * 4);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else if (flag1) {
                    par1Entity.func_70066_B();
                }
            }
        }
        BattlegearUtils.refreshAttributes(player, true);
    }

    public static boolean interactWith(EntityPlayer entityPlayer, Entity entity) {
        EntityInteractEvent event = new EntityInteractEvent(entityPlayer, entity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        ItemStack itemstack = entityPlayer.func_71045_bC();
        boolean offset = false;
        ItemStack copyStack = itemstack != null ? itemstack.func_77946_l() : null;
        boolean entityInteract = entity.func_130002_c(entityPlayer);
        if (!entityInteract && BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
            offset = true;
            itemstack = BattlegearUtils.refreshAttributes(entityPlayer, false);
            copyStack = itemstack != null ? itemstack.func_77946_l() : null;
            entityInteract = entity.func_130002_c(entityPlayer);
        }
        if (!entityInteract) {
            ItemStack offhandItem;
            PlayerEventChild.OffhandAttackEvent offAttackEvent;
            boolean itemInteract = false;
            if (itemstack != null && entity instanceof EntityLivingBase) {
                if (entityPlayer.field_71075_bZ.field_75098_d) {
                    itemstack = copyStack;
                }
                if (!(itemInteract = itemstack.func_111282_a(entityPlayer, (EntityLivingBase)entity)) && !offset && BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
                    offset = true;
                    itemstack = BattlegearUtils.refreshAttributes(entityPlayer, false);
                    if (itemstack != null) {
                        itemInteract = itemstack.func_111282_a(entityPlayer, (EntityLivingBase)entity);
                    }
                }
                if (itemInteract && itemstack.field_77994_a <= 0 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.func_71028_bD();
                }
            }
            if (offset) {
                BattlegearUtils.refreshAttributes(entityPlayer, true);
            }
            if (!itemInteract && BattlegearUtils.isPlayerInBattlemode(entityPlayer) && !MinecraftForge.EVENT_BUS.post((Event)(offAttackEvent = new PlayerEventChild.OffhandAttackEvent(event, offhandItem = ((InventoryPlayerBattle)event.entityPlayer.field_71071_by).getCurrentOffhandWeapon())))) {
                if (offAttackEvent.swingOffhand) {
                    BattlegearUtils.sendOffSwingEvent((PlayerEvent)event, offAttackEvent.offHand);
                }
                if (offAttackEvent.shouldAttack) {
                    ((IBattlePlayer)event.entityPlayer).attackTargetEntityWithCurrentOffItem(offAttackEvent.getTarget());
                }
                if (offAttackEvent.cancelParent) {
                    return true;
                }
            }
            return itemInteract;
        }
        if (itemstack != null && itemstack == entityPlayer.func_71045_bC()) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (itemstack.field_77994_a <= 0) {
                    entityPlayer.func_71028_bD();
                }
            } else if (itemstack.field_77994_a < copyStack.field_77994_a) {
                itemstack.field_77994_a = copyStack.field_77994_a;
            }
        }
        if (offset) {
            BattlegearUtils.refreshAttributes(entityPlayer, true);
        }
        return true;
    }

    public static void sendOffSwingEvent(PlayerEvent event, ItemStack offhandItem) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.OffhandSwingEvent(event, offhandItem))) {
            ((IBattlePlayer)event.entityPlayer).swingOffItem();
        }
    }

    public static ItemStack refreshAttributes(EntityPlayer entityPlayer, boolean fromOffhand) {
        ItemStack oldItem = entityPlayer.func_71045_bC();
        entityPlayer.field_71071_by.field_70461_c = fromOffhand ? (entityPlayer.field_71071_by.field_70461_c -= InventoryPlayerBattle.WEAPON_SETS) : (entityPlayer.field_71071_by.field_70461_c += InventoryPlayerBattle.WEAPON_SETS);
        ItemStack newStack = entityPlayer.func_71045_bC();
        BattlegearUtils.refreshAttributes(entityPlayer.func_110140_aT(), oldItem, newStack);
        return newStack;
    }

    public static void refreshAttributes(BaseAttributeMap attributeMap, ItemStack oldItem, ItemStack currentItem) {
        if (oldItem != null) {
            attributeMap.func_111148_a(oldItem.func_111283_C());
        }
        if (currentItem != null) {
            attributeMap.func_111147_b(currentItem.func_111283_C());
        }
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack beforeFinishUseEvent(EntityPlayer entityPlayer, ItemStack itemInUse, int itemInUseCount, ItemStack result, int previousStackSize) {
        result = ForgeEventFactory.onItemUseFinish((EntityPlayer)entityPlayer, (ItemStack)itemInUse, (int)itemInUseCount, (ItemStack)result);
        if (BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
            if (result != itemInUse || result != null && result.field_77994_a != previousStackSize) {
                if (itemInUse == entityPlayer.func_71045_bC()) {
                    if (result != null && result.field_77994_a == 0) {
                        BattlegearUtils.setPlayerCurrentItem(entityPlayer, null);
                    } else {
                        BattlegearUtils.setPlayerCurrentItem(entityPlayer, result);
                    }
                } else if (itemInUse == ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon()) {
                    if (result != null && result.field_77994_a == 0) {
                        BattlegearUtils.setPlayerOffhandItem(entityPlayer, null);
                    } else {
                        BattlegearUtils.setPlayerOffhandItem(entityPlayer, result);
                    }
                }
            }
            entityPlayer.func_71041_bz();
            return null;
        }
        return result;
    }

    public static ItemStack getCurrentItemOnUpdate(EntityPlayer entityPlayer, ItemStack itemInUse) {
        ItemStack itemStack;
        if (BattlegearUtils.isPlayerInBattlemode(entityPlayer) && itemInUse == (itemStack = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon())) {
            return itemStack;
        }
        return entityPlayer.func_71045_bC();
    }

    public static void onBowStackDepleted(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (itemStack == entityPlayer.func_71045_bC()) {
            entityPlayer.func_71028_bD();
        } else {
            ItemStack orig = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon();
            if (orig == itemStack) {
                BattlegearUtils.setPlayerOffhandItem(entityPlayer, null);
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)entityPlayer, (ItemStack)orig);
            }
        }
    }

    static {
        genericAttack = SharedMonsterAttributes.field_111264_e.func_111108_a();
    }
}

