/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modhazardousitems;

import com.dreammaster.modhazardousitems.HazardDamageSources;
import com.dreammaster.modhazardousitems.HazardEffect;
import com.dreammaster.modhazardousitems.IDamageEffectContainer;
import com.dreammaster.modhazardousitems.cause.HazardCause;
import eu.usrv.yamcore.auxiliary.FluidHelper;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="HazardousItemList")
public class HazardousItems {
    @XmlElement(name="Item")
    protected List<HazardousItem> hazardousItem;
    @XmlElement(name="Fluid")
    protected List<HazardousFluid> hazardousFluid;

    public List<HazardousFluid> getHazardousFluids() {
        if (this.hazardousFluid == null) {
            this.hazardousFluid = new ArrayList<HazardousFluid>();
        }
        return this.hazardousFluid;
    }

    public List<HazardousItem> getHazardousItems() {
        if (this.hazardousItem == null) {
            this.hazardousItem = new ArrayList<HazardousItem>();
        }
        return this.hazardousItem;
    }

    public HazardousFluid FindHazardousFluidExact(String pFluidName) {
        for (HazardousFluid hf : this.hazardousFluid) {
            if (!hf.fluidName.equals(pFluidName)) continue;
            return hf;
        }
        return null;
    }

    public HazardousItem FindHazardousItemExact(String pItemName) {
        for (HazardousItem hi : this.hazardousItem) {
            if (!hi.itemName.equals(pItemName)) continue;
            return hi;
        }
        return null;
    }

    public boolean RemoveItemExact(ItemStack pInHand, boolean pIncludeNonExact) {
        try {
            ArrayList<HazardousItem> tNewList = new ArrayList<HazardousItem>();
            for (HazardousItem hi : this.hazardousItem) {
                if (hi.exactMatch) {
                    if (hi.itemName.equals(ItemDescriptor.fromItem((Item)pInHand.func_77973_b()))) {
                        continue;
                    }
                } else if (pIncludeNonExact) {
                    String p1 = hi.itemName.toLowerCase();
                    String p2 = ItemDescriptor.fromItem((Item)pInHand.func_77973_b()).toString().toLowerCase();
                    if (p2.contains(p1)) continue;
                }
                tNewList.add(hi);
            }
            this.hazardousItem = tNewList;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean RemoveFluidExact(ItemStack pInHand, boolean pIncludeNonExact) {
        try {
            ArrayList<HazardousFluid> tNewList = new ArrayList<HazardousFluid>();
            Fluid tContainerFluid = FluidHelper.getFluidFromContainer((ItemStack)pInHand);
            for (HazardousFluid hi : this.hazardousFluid) {
                if (hi.exactMatch) {
                    if (hi.fluidName.equals(tContainerFluid.getName())) {
                        continue;
                    }
                } else if (pIncludeNonExact) {
                    String p1 = hi.fluidName.toLowerCase();
                    String p2 = tContainerFluid.getName().toLowerCase();
                    if (p2.contains(p1)) continue;
                }
                tNewList.add(hi);
            }
            this.hazardousFluid = tNewList;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public HazardousItem FindHazardousItemContains(String pSearchString, boolean pIgnoreCase) {
        for (HazardousItem hi : this.hazardousItem) {
            String p2;
            String p1 = pIgnoreCase ? hi.itemName.toLowerCase() : hi.itemName;
            if (!p1.contains(p2 = pIgnoreCase ? pSearchString.toLowerCase() : pSearchString)) continue;
            return hi;
        }
        return null;
    }

    public HazardousFluid FindHazardousFluidContains(String pSearchString, boolean pIgnoreCase) {
        for (HazardousFluid hi : this.hazardousFluid) {
            String p2;
            String p1 = pIgnoreCase ? hi.fluidName.toLowerCase() : hi.fluidName;
            if (!p1.contains(p2 = pIgnoreCase ? pSearchString.toLowerCase() : pSearchString)) continue;
            return hi;
        }
        return null;
    }

    public HazardousItem FindHazardousItem(ItemStack pItemStack) {
        for (HazardousItem hi : this.hazardousItem) {
            if (hi.exactMatch) {
                if (!hi.itemName.equals(ItemDescriptor.fromStack((ItemStack)pItemStack).toString())) continue;
                return hi;
            }
            String p1 = hi.itemName.toLowerCase();
            String p2 = ItemDescriptor.fromStack((ItemStack)pItemStack).toString().toLowerCase();
            if (!p2.contains(p1)) continue;
            return hi;
        }
        return null;
    }

    public HazardousFluid FindHazardousFluid(ItemStack pItemStack) {
        FluidStack tStackFluid = FluidHelper.getFluidStackFromContainer((ItemStack)pItemStack);
        if (tStackFluid == null) {
            return null;
        }
        if (tStackFluid.amount == 0) {
            return null;
        }
        for (HazardousFluid hi : this.hazardousFluid) {
            if (hi.exactMatch) {
                if (!hi.fluidName.equals(tStackFluid.getFluid().getName())) continue;
                return hi;
            }
            String p1 = hi.fluidName.toLowerCase();
            String p2 = tStackFluid.getFluid().getName().toLowerCase();
            if (!p2.contains(p1)) continue;
            return hi;
        }
        return null;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    public static class ItmPotionEffect
    extends HazardEffect {
        @XmlAttribute(name="PotionID")
        protected Integer id;
        @XmlAttribute(name="TickDuration")
        protected Integer duration;
        @XmlAttribute(name="Level")
        protected Integer level;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer value) {
            this.id = value;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public void setDuration(Integer value) {
            this.duration = value;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer value) {
            this.level = value;
        }

        @Override
        protected void apply(HazardCause cause, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(this.getId().intValue(), this.getDuration().intValue(), this.getLevel().intValue()));
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    public static class ItmDamageEffect
    extends HazardEffect {
        @XmlAttribute(name="Source")
        protected String damageSource;
        @XmlAttribute(name="Amount")
        protected Float amount;

        public String getDamageSource() {
            return this.damageSource;
        }

        public void setDamageSource(String value) {
            this.damageSource = value;
        }

        public Float getAmount() {
            return this.amount;
        }

        public void setAmount(Float value) {
            this.amount = value;
        }

        @Override
        protected void apply(HazardCause cause, EntityPlayer player) {
            Function<HazardCause, DamageSource> sourceFactory = HazardDamageSources.getDamageSourceFactoryOrFail(this.getDamageSource());
            player.func_70097_a(sourceFactory.apply(cause), this.getAmount().floatValue());
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    public static class HazardousFluid
    implements IDamageEffectContainer {
        @XmlAttribute(name="FluidName")
        public String fluidName;
        @XmlAttribute(name="ExactNameMatch")
        protected boolean exactMatch;
        @XmlAttribute(name="OnContactCheck")
        protected boolean checkContact;
        @XmlAttribute(name="InventoryCheck")
        protected boolean checkInventory;
        @XmlElement(name="DamageEffect")
        protected List<ItmDamageEffect> damageEffect;
        @XmlElement(name="PotionEffect")
        protected List<ItmPotionEffect> potionEffect;

        public void setCheckInventory(boolean pVal) {
            this.checkInventory = pVal;
        }

        public void setCheckContact(boolean pVal) {
            this.checkContact = pVal;
        }

        public boolean getCheckInventory() {
            return this.checkInventory;
        }

        public boolean getCheckContact() {
            return this.checkContact;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public void setFluidName(String value) {
            this.fluidName = value;
        }

        public boolean getExactMatch() {
            return this.exactMatch;
        }

        public void setExactMatch(boolean value) {
            this.exactMatch = value;
        }

        @Override
        public List<ItmPotionEffect> getPotionEffects() {
            if (this.potionEffect == null) {
                this.potionEffect = new ArrayList<ItmPotionEffect>();
            }
            return this.potionEffect;
        }

        @Override
        public List<ItmDamageEffect> getDamageEffects() {
            if (this.damageEffect == null) {
                this.damageEffect = new ArrayList<ItmDamageEffect>();
            }
            return this.damageEffect;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    public static class HazardousItem
    implements IDamageEffectContainer {
        @XmlAttribute(name="ItemName")
        public String itemName;
        @XmlAttribute(name="ExactNameMatch")
        protected boolean exactMatch;
        @XmlAttribute(name="OnContactCheck")
        protected boolean checkContact;
        @XmlAttribute(name="InventoryCheck")
        protected boolean checkInventory;
        @XmlElement(name="DamageEffect")
        protected List<ItmDamageEffect> damageEffect;
        @XmlElement(name="PotionEffect")
        protected List<ItmPotionEffect> potionEffect;

        public void setCheckInventory(boolean pVal) {
            this.checkInventory = pVal;
        }

        public void setCheckContact(boolean pVal) {
            this.checkContact = pVal;
        }

        public boolean getCheckInventory() {
            return this.checkInventory;
        }

        public boolean getCheckContact() {
            return this.checkContact;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String value) {
            this.itemName = value;
        }

        public boolean getExactMatch() {
            return this.exactMatch;
        }

        public void setExactMatch(boolean value) {
            this.exactMatch = value;
        }

        @Override
        public List<ItmPotionEffect> getPotionEffects() {
            if (this.potionEffect == null) {
                this.potionEffect = new ArrayList<ItmPotionEffect>();
            }
            return this.potionEffect;
        }

        @Override
        public List<ItmDamageEffect> getDamageEffects() {
            if (this.damageEffect == null) {
                this.damageEffect = new ArrayList<ItmDamageEffect>();
            }
            return this.damageEffect;
        }
    }
}

