/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEDam;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class HEClient {
    private static HEDam[] dams = new HEDam[HEConfig.maxDams];

    public static void onWaterUpdate(int waterId, float waterLevel) {
        if (waterId < 0 || waterId >= HEConfig.maxDams) {
            HE.error("Server uses invalid waterIds! Server message ignored. Please make sure your config \"maxControllers\" is at least as big as the server you are connecting to!");
            return;
        }
        dams[waterId].onWaterUpdate(waterLevel);
    }

    public static void onConfigUpdate(int waterId, int blockX, int blockY, int blockZ, HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        HE.debug("Received dam config update");
        if (waterId < 0 || waterId >= HEConfig.maxDams) {
            HE.error("Server uses invalid waterIds! Server message ignored. Please make sure your config \"maxControllers\" is at least as big as the server you are connecting to!");
            return;
        }
        dams[waterId].onConfigUpdate(blockX, blockY, blockZ, mode, limitWest, limitDown, limitNorth, limitEast, limitUp, limitSouth);
    }

    public static float[] getDebugStatesAsFactors() {
        float[] debugFactors = new float[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            debugFactors[waterId] = dams[waterId].renderAsDebug() ? 1.0f : 0.0f;
        }
        return debugFactors;
    }

    public static float[] getAllWaterLevelsForRendering() {
        float[] waterLevels = new float[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            waterLevels[waterId] = dams[waterId].getWaterLevelForRendering();
        }
        return waterLevels;
    }

    public static float[] getAllWaterLevelForPhysicsAndLighting() {
        float[] waterLevels = new float[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            waterLevels[waterId] = dams[waterId].getWaterLevelForPhysicsAndLighting();
        }
        return waterLevels;
    }

    public static void onSynchronize(int[] blocksX, int[] blocksY, int[] blocksZ, float[] waterLevels, HE.DamMode[] modes, int[] limitsWest, int[] limitsDown, int[] limitsNorth, int[] limitsEast, int[] limitsUp, int[] limitsSouth, boolean[] enabledTiers) {
        if (HEConfig.maxDams < waterLevels.length) {
            HE.error("Server uses invalid waterIds! Server message ignored. Please make sure your config \"maxControllers\" is at least as big as the server you are connecting to!");
        }
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            dams[waterId].onConfigUpdate(blocksX[waterId], blocksY[waterId], blocksZ[waterId], modes[waterId], limitsWest[waterId], limitsDown[waterId], limitsNorth[waterId], limitsEast[waterId], limitsUp[waterId], limitsSouth[waterId]);
            dams[waterId].onWaterUpdate(waterLevels[waterId]);
        }
        HE.debug("Received synchronize packet from server");
        if (HEConfig.enabledTiers.length != enabledTiers.length) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d("HydroEnergy: Configuration mismatch to the server found! This might crash somewhat randomly. Please talk to your server admin!");
            return;
        }
        for (int tierId = 0; tierId < enabledTiers.length; ++tierId) {
            if (HEConfig.enabledTiers[tierId] == enabledTiers[tierId]) continue;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("HydroEnergy: Configuration mismatch to the server found! This might crash somewhat randomly. Please talk to your server admin!");
            return;
        }
    }

    public static HEDam getDam(int waterId) {
        return dams[waterId];
    }

    public static void onDisconnect() {
        dams = new HEDam[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            HEClient.dams[waterId] = new HEDam(waterId);
        }
    }

    public static int getWaterId(int blockX, int blockY, int blockZ) {
        for (HEDam dam : dams) {
            if (dam.getBlockX() != blockX || dam.getBlockY() != blockY || dam.getBlockZ() != blockZ) continue;
            return dam.getWaterId();
        }
        return -1;
    }

    static {
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            HEClient.dams[waterId] = new HEDam(waterId);
        }
    }
}

