/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.recipes;

import java.util.HashMap;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.CraftingInfo;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeAction;
import minetweaker.api.recipes.IRecipeFunction;

public class ShapedRecipe
implements ICraftingRecipe {
    private final int width;
    private final int height;
    private final byte[] posx;
    private final byte[] posy;
    private final boolean mirrored;
    private final IRecipeFunction function;
    private final IRecipeAction action;
    private final IItemStack output;
    private final IIngredient[] ingredients;

    public ShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, boolean mirrored) {
        this(output, ingredients, function, null, mirrored);
    }

    public ShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
        int numIngredients = 0;
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] ingredient;
            for (IIngredient iIngredient : ingredient = iIngredientArray[i]) {
                if (iIngredient == null) continue;
                ++numIngredients;
            }
        }
        this.posx = new byte[numIngredients];
        this.posy = new byte[numIngredients];
        this.output = output;
        this.ingredients = new IIngredient[numIngredients];
        this.function = function;
        this.action = action;
        int width1 = 0;
        int height1 = ingredients.length;
        int ix = 0;
        for (int j = 0; j < ingredients.length; ++j) {
            IIngredient[] row = ingredients[j];
            width1 = Math.max(width1, row.length);
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null) continue;
                this.posx[ix] = (byte)i;
                this.posy[ix] = (byte)j;
                this.ingredients[ix] = row[i];
                ++ix;
            }
        }
        this.width = width1;
        this.height = height1;
        this.mirrored = mirrored;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public IIngredient[] getIngredients() {
        return this.ingredients;
    }

    public byte[] getIngredientsX() {
        return this.posx;
    }

    public byte[] getIngredientsY() {
        return this.posy;
    }

    public IItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(ICraftingInventory inventory) {
        IItemStack item;
        int k;
        int j;
        int i;
        if (inventory.getStackCount() != this.ingredients.length) {
            return false;
        }
        for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
            block1: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                for (k = 0; k < this.ingredients.length; ++k) {
                    item = inventory.getStack(this.posx[k] + i, this.posy[k] + j);
                    if (item == null || !this.ingredients[k].matches(item)) continue block1;
                }
                return true;
            }
        }
        if (this.mirrored) {
            for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
                block4: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                    for (k = 0; k < this.ingredients.length; ++k) {
                        item = inventory.getStack(inventory.getWidth() - (this.posx[k] + i) - 1, this.posy[k] + j);
                        if (item == null || !this.ingredients[k].matches(item)) continue block4;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IItemStack getCraftingResult(ICraftingInventory inventory) {
        IItemStack item;
        int k;
        int j;
        int i;
        IItemStack[] stacks = new IItemStack[this.ingredients.length];
        for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
            block1: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                for (k = 0; k < this.ingredients.length; ++k) {
                    item = inventory.getStack(this.posx[k] + i, this.posy[k] + j);
                    if (item == null || !this.ingredients[k].matches(item)) continue block1;
                    stacks[k] = item;
                }
                return this.doRecipe(inventory, stacks, i, j, this.output, false);
            }
        }
        if (this.mirrored) {
            for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
                block4: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                    for (k = 0; k < this.ingredients.length; ++k) {
                        item = inventory.getStack(inventory.getWidth() - (this.posx[k] + i) - 1, this.posy[k] + j);
                        if (item == null || !this.ingredients[k].matches(item)) continue block4;
                        stacks[k] = item;
                    }
                    return this.doRecipe(inventory, stacks, i, j, this.output, true);
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasTransformers() {
        for (IIngredient ingredient : this.ingredients) {
            if (!ingredient.hasTransformers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyTransformers(ICraftingInventory inventory, IPlayer byPlayer) {
        IItemStack item;
        int k;
        int j;
        int i;
        IItemStack[] stacks = new IItemStack[this.ingredients.length];
        for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
            block1: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                for (k = 0; k < this.ingredients.length; ++k) {
                    item = inventory.getStack(this.posx[k] + i, this.posy[k] + j);
                    if (item == null || !this.ingredients[k].matches(item)) continue block1;
                    stacks[k] = item;
                }
                this.doRecipeTransformers(inventory, stacks, i, j, false, byPlayer);
                return;
            }
        }
        if (this.mirrored) {
            for (i = 0; i <= inventory.getWidth() - this.width; ++i) {
                block4: for (j = 0; j <= inventory.getHeight() - this.height; ++j) {
                    for (k = 0; k < this.ingredients.length; ++k) {
                        item = inventory.getStack(inventory.getWidth() - (this.posx[k] + i) - 1, this.posy[k] + j);
                        if (item == null || !this.ingredients[k].matches(item)) continue block4;
                        stacks[k] = item;
                    }
                    this.doRecipeTransformers(inventory, stacks, i, j, true, byPlayer);
                    return;
                }
            }
        }
    }

    @Override
    public String toCommandString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("recipes.addShaped(");
        if (this.output != null) {
            result.append(this.output);
        } else {
            result.append("null");
        }
        result.append(", [");
        IIngredient[][] ingredientsArray = new IIngredient[this.height][this.width];
        for (i = 0; i < this.ingredients.length; ++i) {
            ingredientsArray[this.posy[i]][this.posx[i]] = this.ingredients[i];
        }
        for (i = 0; i < ingredientsArray.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append("[");
            for (int j = 0; j < ingredientsArray[i].length; ++j) {
                if (j > 0) {
                    result.append(", ");
                }
                result.append(ingredientsArray[i][j]);
            }
            result.append("]");
        }
        result.append("]);");
        return result.toString();
    }

    private IItemStack doRecipe(ICraftingInventory inventory, IItemStack[] stacks, int offx, int offy, IItemStack output, boolean mirrored) {
        if (this.function != null) {
            HashMap<String, IItemStack> tagged = new HashMap<String, IItemStack>();
            for (int k = 0; k < this.ingredients.length; ++k) {
                if (this.ingredients[k].getMark() == null) continue;
                tagged.put(this.ingredients[k].getMark(), stacks[k]);
            }
            output = this.function.process(output, tagged, new CraftingInfo(inventory, null));
            System.out.println("Ouput: " + output);
        }
        if (output == null) {
            return null;
        }
        return output;
    }

    private void doRecipeTransformers(ICraftingInventory inventory, IItemStack[] stacks, int offx, int offy, boolean mirrored, IPlayer byPlayer) {
        for (int i = 0; i < this.ingredients.length; ++i) {
            IItemStack transformed = this.ingredients[i].applyTransform(stacks[i], byPlayer);
            if (transformed == stacks[i]) continue;
            if (mirrored) {
                inventory.setStack(inventory.getWidth() - (offx + this.posx[i]) - 1, offy + this.posy[i], transformed);
                continue;
            }
            inventory.setStack(offx + this.posx[i], offy + this.posy[i], transformed);
        }
    }

    public IRecipeAction getAction() {
        return this.action;
    }
}

