/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.vec.Point3i;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SpawnUtil {
    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation) {
        return SpawnUtil.findClearGround(world, startingLocation, clearLocation, 2, 10, false);
    }

    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation, int horizRange, int vertRange, boolean checkForLivingEntities) {
        boolean foundTargetSpace = false;
        for (int xOff = -horizRange; xOff <= horizRange && !foundTargetSpace; ++xOff) {
            clearLocation.x = startingLocation.x + xOff;
            for (int zOff = -horizRange; zOff <= horizRange && !foundTargetSpace; ++zOff) {
                clearLocation.z = startingLocation.z + zOff;
                foundTargetSpace = SpawnUtil.seachYForClearGround(clearLocation, world, vertRange, checkForLivingEntities);
                if (foundTargetSpace) continue;
                clearLocation.y = startingLocation.y;
            }
        }
        return foundTargetSpace;
    }

    public static boolean seachYForClearGround(Point3i target, World world) {
        return SpawnUtil.seachYForClearGround(target, world, 10, false);
    }

    public static boolean seachYForClearGround(Point3i target, World world, int searchRange, boolean checkForLivingEntities) {
        boolean foundY = false;
        for (int i = 0; i < searchRange && !foundY; ++i) {
            if (world.func_147437_c(target.x, target.y, target.z)) {
                foundY = true;
                continue;
            }
            ++target.y;
        }
        boolean onGround = false;
        if (foundY) {
            for (int i = 0; i < searchRange && !onGround; ++i) {
                boolean bl = onGround = !world.func_147437_c(target.x, target.y - 1, target.z) && !SpawnUtil.isLiquid(world, target.x, target.y - 1, target.z);
                if (!onGround) {
                    --target.y;
                    continue;
                }
                if (!checkForLivingEntities || !SpawnUtil.containsLiving(world, target)) continue;
                return false;
            }
        }
        return foundY && onGround;
    }

    public static boolean containsLiving(World world, Point3i blockCoord) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, (double)(blockCoord.x + 1), (double)(blockCoord.y + 1), (double)(blockCoord.z + 1));
        List ents = world.func_72872_a(EntityLivingBase.class, bb);
        return ents != null && !ents.isEmpty();
    }

    public static boolean isLiquid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149688_o().func_76224_d();
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, EntityCreature asCreature, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (asCreature != null && asCreature.func_70783_a(i, j, k) < 0.0f) {
            return false;
        }
        if (checkEntityCollisions && !worldObj.func_72855_b(entity.field_70121_D)) {
            return false;
        }
        if (!worldObj.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty()) {
            return false;
        }
        return canSpawnInLiquid || !worldObj.func_72953_d(entity.field_70121_D);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityCreature entity, boolean checkEntityCollisions) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, (EntityLiving)entity, entity, checkEntityCollisions, false);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, boolean checkEntityCollisions) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, entity, null, checkEntityCollisions, false);
    }
}

