/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.items.SimpleSubItemClass;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_THTR
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_THTR> {
    private static final int BASECASINGINDEX = 44;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_THTR> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  BBBBBBB  ", " BBBBBBBBB ", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", " BBBBBBBBB ", "  BBBBBBB  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  bbb~bbb  ", " bbbbbbbbb ", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", " bbbbbbbbb ", "  bbbbbbb  "}})).addElement('c', StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)12))).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)44, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)44, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)44, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)12))})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)44, (int)2), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)12))})).build();
    private static final int HELIUM_NEEDED = 730000;
    private static final int powerUsage = BW_Util.getMachineVoltageFromTier(5) / 2;
    private static final int maxcapacity = 675000;
    private static final int mincapacity = 100000;
    private int HeliumSupply;
    private int fuelsupply;
    private boolean empty;
    private int coolanttaking = 0;
    private int mCasing = 0;

    public GT_TileEntity_THTR(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_THTR(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public IStructureDefinition<GT_TileEntity_THTR> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("High Temperature Reactor").addInfo("Controller block for the Thorium High Temperature Reactor (THTR)").addInfo("Needs to be primed with " + GT_Utility.formatNumbers((long)730000L) + " of helium").addInfo("Needs a constant supply of coolant while running").addInfo("Needs at least 100k Fuel pebbles to start operation (can hold up to 675k pebbles)").addInfo("Consumes up to 0.5% of total Fuel Pellets per Operation depending on efficiency").addInfo("Efficiency decreases exponentially if the internal buffer is not completely filled").addInfo("Reactor will take 4 800L/t of coolant multiplied by efficiency").addInfo("Uses " + GT_Utility.formatNumbers((long)powerUsage) + " EU/t").addInfo("One Operation takes 9 hours").addSeparator().beginStructureBlock(11, 12, 11, true).addController("Front bottom center").addCasingInfo("Radiation Proof Casings", 500).addStructureInfo("Corners and the 2 touching blocks are air (cylindric)").addInputBus("Any top layer casing", new int[]{2}).addInputHatch("Any top layer casing", new int[]{2}).addOutputBus("Any bottom layer casing", new int[]{1}).addOutputHatch("Any bottom layer casing", new int[]{1}).addEnergyHatch("Any bottom layer casing", new int[]{1}).addMaintenanceHatch("Any bottom layer casing", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 11, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mCasing = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 11, 0) && this.mCasing >= 500 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() > 0 && this.mOutputHatches.size() > 0 && this.mInputBusses.size() > 0 && this.mOutputBusses.size() > 0 && this.mEnergyHatches.size() > 0;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.HeliumSupply = aNBT.func_74762_e("HeliumSupply");
        this.fuelsupply = aNBT.func_74762_e("fuelsupply");
        this.coolanttaking = aNBT.func_74762_e("coolanttaking");
        this.empty = aNBT.func_74767_n("EmptyMode");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("HeliumSupply", this.HeliumSupply);
        aNBT.func_74768_a("fuelsupply", this.fuelsupply);
        aNBT.func_74768_a("coolanttaking", this.coolanttaking);
        aNBT.func_74757_a("EmptyMode", this.empty);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && !this.empty) {
            int toget;
            if (this.HeliumSupply < 730000) {
                for (FluidStack fluidStack : this.getStoredFluids()) {
                    if (!fluidStack.isFluidEqual(Materials.Helium.getGas(1L))) continue;
                    toget = Math.min(730000 - this.HeliumSupply, fluidStack.amount);
                    fluidStack.amount -= toget;
                    this.HeliumSupply += toget;
                    if (730000 != this.HeliumSupply || fluidStack.amount != 0) continue;
                    fluidStack = null;
                }
            }
            if (this.fuelsupply < 675000) {
                this.startRecipeProcessing();
                for (ItemStack itemStack : this.getStoredInputs()) {
                    if (!GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)new ItemStack((Item)THTRMaterials.aTHTR_Materials, 1, 4)) || (toget = Math.min(675000 - this.fuelsupply, itemStack.field_77994_a)) == 0) continue;
                    itemStack.field_77994_a -= toget;
                    this.fuelsupply += toget;
                }
                this.endRecipeProcessing();
                this.updateSlots();
            }
        }
    }

    public boolean checkRecipe(ItemStack controllerStack) {
        int meta;
        ItemStack[] toOutput;
        int toReduce;
        if (this.empty) {
            if (this.HeliumSupply > 0 || this.fuelsupply > 0) {
                this.mEfficiency = 10000;
                this.mMaxProgresstime = 100;
                return true;
            }
            return false;
        }
        if (this.HeliumSupply < 730000 || this.fuelsupply < 100000) {
            return false;
        }
        double eff = Math.min(Math.pow((double)(this.fuelsupply - 100000) / 57500.0, 2.0) + 1.0, 100.0) / 100.0 - (double)(this.getIdealStatus() - this.getRepairStatus()) / 10.0;
        if (eff <= 0.0) {
            return false;
        }
        int originalToReduce = toReduce = MathUtils.floorInt((double)this.fuelsupply * 0.005 * eff);
        int burnedballs = toReduce / 64;
        if (burnedballs > 0) {
            toReduce -= burnedballs * 64;
        }
        if (!this.canOutputAll(toOutput = new ItemStack[]{new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedballs, meta = 5), new ItemStack((Item)THTRMaterials.aTHTR_Materials, toReduce, meta + 1)})) {
            return false;
        }
        this.fuelsupply -= originalToReduce;
        this.mOutputItems = toOutput;
        this.coolanttaking = (int)(4800.0 * eff);
        this.mEfficiency = (int)(eff * 10000.0);
        this.mEUt = -powerUsage;
        this.mMaxProgresstime = 648000;
        return true;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.empty) {
            this.addOutput(Materials.Helium.getGas((long)this.HeliumSupply));
            this.addOutput(new ItemStack((Item)THTRMaterials.aTHTR_Materials, this.fuelsupply, 4));
            this.HeliumSupply = 0;
            this.fuelsupply = 0;
            this.updateSlots();
            return true;
        }
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        int takecoolant = this.coolanttaking;
        int drainedamount = 0;
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            if (!GT_TileEntity_THTR.isValidMetaTileEntity((MetaTileEntity)tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2coolant", (int)1))) continue;
            FluidStack drained = tHatch.drain(takecoolant, true);
            drainedamount += drained.amount;
            if ((takecoolant -= drained.amount) > 0) continue;
            break;
        }
        if (drainedamount > 0) {
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)drainedamount));
        }
        this.updateSlots();
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_THTR(this.mName);
    }

    public String[] getInfoData() {
        return new String[]{"Progress:", GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + "secs /" + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + "secs", "TRISO-Pebbles:", GT_Utility.formatNumbers((long)this.fuelsupply) + "pcs. / " + GT_Utility.formatNumbers((long)this.fuelsupply) + "psc.", "Helium-Level:", GT_Utility.formatNumbers((long)this.HeliumSupply) + "L / " + GT_Utility.formatNumbers((long)730000L) + "L", "Coolant/t:", GT_Utility.formatNumbers((long)(this.mProgresstime == 0 ? 0L : (long)this.coolanttaking)) + "L/t", "Problems:", String.valueOf(this.getIdealStatus() - this.getRepairStatus())};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44)};
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"THTR mode cannot be changed while the machine is running.");
            return;
        }
        this.empty = !this.empty;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("THTR is now running in " + (this.empty ? "emptying mode." : "normal Operation")));
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public static class THTRMaterials {
        public static final SimpleSubItemClass aTHTR_Materials = new SimpleSubItemClass("BISOPelletCompound", "BISOPelletBall", "TRISOPelletCompound", "TRISOPelletBall", "TRISOPellet", "BurnedOutTRISOPelletBall", "BurnedOutTRISOPellet");
        public static final int MATERIAL_FUEL_INDEX = 4;
        public static final int MATERIAL_USED_FUEL_INDEX = 5;

        public static void registeraTHR_Materials() {
            GameRegistry.registerItem((Item)aTHTR_Materials, (String)"bw.THTRMaterials");
        }
    }
}

