/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.abstracts;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicBerryCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;

public abstract class BasicNetherBerryCrop
extends BasicBerryCrop {
    @Override
    public int tier() {
        return 4;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (crop.getSize() < 1) {
            return true;
        }
        return crop.getSize() < 3;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Has increased Nutrient requirements (x1.5)", "Has decreased humidity requirements (x0.5)");
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 0.5 + (double)nutrients * 1.5 + (double)air * 1.0);
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() == 2 ? 300 : 700;
    }
}

