/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.render.TextureFactory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class GT_MetaTileEntity_Hatch_MultiInput
extends GT_MetaTileEntity_Hatch_Input
implements IAddUIWidgets {
    private final FluidStack[] mStoredFluid;
    private final FluidStackTank[] fluidTanks;
    public final int mCapacityPer;

    public GT_MetaTileEntity_Hatch_MultiInput(int aID, int aSlot, String aName, String aNameRegional, int aTier) {
        super(aID, aSlot, aName, aNameRegional, aTier);
        this.mStoredFluid = new FluidStack[aSlot];
        this.fluidTanks = new FluidStackTank[aSlot];
        this.mCapacityPer = this.getCapacityPerTank(aTier, aSlot);
    }

    public GT_MetaTileEntity_Hatch_MultiInput(String aName, int aSlot, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aSlot, aTier, aDescription, aTextures);
        this.mStoredFluid = new FluidStack[aSlot];
        this.fluidTanks = new FluidStackTank[aSlot];
        this.mCapacityPer = this.getCapacityPerTank(aTier, aSlot);
        for (int i = 0; i < aSlot; ++i) {
            int index = i;
            this.fluidTanks[i] = new FluidStackTank(() -> this.mStoredFluid[index], fluid -> {
                this.mStoredFluid[index] = fluid;
            }, this.mCapacityPer);
        }
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_MultiInput(this.mName, this.getMaxType(), (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.mStoredFluid.length; ++i) {
                if (this.mStoredFluid[i] == null) continue;
                aNBT.func_74782_a("mFluid" + i, (NBTBase)this.mStoredFluid[i].writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.mStoredFluid.length; ++i) {
                if (!aNBT.func_74764_b("mFluid" + i)) continue;
                this.mStoredFluid[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + i));
            }
        }
    }

    @Override
    public boolean displaysStackSize() {
        return true;
    }

    public FluidStack[] getStoredFluid() {
        return this.mStoredFluid;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_INPUT_HATCH_2x2)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_INPUT_HATCH_2x2)};
    }

    public int getMaxType() {
        return this.mStoredFluid.length;
    }

    @Override
    public FluidStack getFluid() {
        for (FluidStack tFluid : this.mStoredFluid) {
            if (tFluid == null || tFluid.amount <= 0) continue;
            return tFluid;
        }
        return null;
    }

    public FluidStack getFluid(int aSlot) {
        if (this.mStoredFluid == null || aSlot < 0 || aSlot >= this.getMaxType()) {
            return null;
        }
        return this.mStoredFluid[aSlot];
    }

    @Override
    public int getFluidAmount() {
        if (this.getFluid() != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        return this.mCapacityPer;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.mStoredFluid.length; ++i) {
            if (this.mStoredFluid[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFluid(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        for (FluidStack tFluid : this.mStoredFluid) {
            if (!aFluid.isFluidEqual(tFluid)) continue;
            return true;
        }
        return false;
    }

    public int getFluidSlot(FluidStack tFluid) {
        if (tFluid == null) {
            return -1;
        }
        for (int i = 0; i < this.mStoredFluid.length; ++i) {
            if (!tFluid.equals((Object)this.mStoredFluid[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFluidAmount(FluidStack tFluid) {
        int tSlot = this.getFluidSlot(tFluid);
        if (tSlot != -1) {
            return this.mStoredFluid[tSlot].amount;
        }
        return 0;
    }

    public void setFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        this.mStoredFluid[aSlot] = aFluid;
    }

    public void addFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        if (aFluid.equals((Object)this.mStoredFluid[aSlot])) {
            this.mStoredFluid[aSlot].amount += aFluid.amount;
        }
        if (this.mStoredFluid[aSlot] == null) {
            this.mStoredFluid[aSlot] = aFluid.copy();
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mFluid = this.getFluid();
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (!this.hasFluid(aFluid) && this.getFirstEmptySlot() != -1) {
            int tFilled = Math.min(aFluid.amount, this.mCapacityPer);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFirstEmptySlot());
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        if (this.hasFluid(aFluid)) {
            int tLeft = this.mCapacityPer - this.getFluidAmount(aFluid);
            int tFilled = Math.min(tLeft, aFluid.amount);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFluidSlot(tFluid));
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        return 0;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getFluid() == null || !this.canTankBeEmptied()) {
            return null;
        }
        if (this.getFluid().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(this.getFluid()));
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        FluidStack tRemove = this.getFluid().copy();
        tRemove.amount = Math.min(maxDrain, tRemove.amount);
        if (doDrain) {
            this.getFluid().amount -= tRemove.amount;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (this.getFluid() == null || this.getFluid().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(this.getFluid()));
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return tRemove;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack aFluid, boolean doDrain) {
        if (aFluid == null || !this.hasFluid(aFluid)) {
            return null;
        }
        FluidStack tStored = this.mStoredFluid[this.getFluidSlot(aFluid)];
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        FluidStack tRemove = tStored.copy();
        tRemove.amount = Math.min(aFluid.amount, tRemove.amount);
        if (doDrain) {
            tStored.amount -= tRemove.amount;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return tRemove;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] FTI = new FluidTankInfo[this.getMaxType()];
        for (int i = 0; i < this.getMaxType(); ++i) {
            FTI[i] = new FluidTankInfo(this.mStoredFluid[i], this.mCapacityPer);
        }
        return FTI;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null || this.mStoredFluid[i].amount > 0) continue;
                this.mStoredFluid[i] = null;
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex >= 4;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int SLOT_NUMBER = 4;
        Pos2d[] positions = new Pos2d[]{new Pos2d(70, 25), new Pos2d(88, 25), new Pos2d(70, 43), new Pos2d(88, 43)};
        for (int i = 0; i < 4; ++i) {
            builder.widget(new FluidSlotWidget((IFluidTank)this.fluidTanks[i]).setBackground(new IDrawable[]{ModularUITextures.FLUID_SLOT}).setPos(positions[i]));
        }
    }
}

