/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.GregTech_API;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.ISerializableObject;
import java.lang.ref.WeakReference;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public final class CoverInfo {
    private static final String NBT_SIDE = "s";
    private static final String NBT_ID = "id";
    private static final String NBT_DATA = "d";
    public static final CoverInfo EMPTY_INFO = new CoverInfo(ForgeDirection.UNKNOWN, null);
    private final ForgeDirection coverSide;
    private int coverID = 0;
    private GT_CoverBehaviorBase<?> coverBehavior = null;
    private ISerializableObject coverData = null;
    private final WeakReference<ICoverable> coveredTile;
    private boolean needsUpdate = false;

    public CoverInfo(ForgeDirection side, ICoverable aTile) {
        this.coverSide = side;
        this.coveredTile = new WeakReference<ICoverable>(aTile);
    }

    public CoverInfo(ForgeDirection side, int aID, ICoverable aTile, ISerializableObject aCoverData) {
        this.coverSide = side;
        this.coverID = aID;
        this.coverBehavior = GregTech_API.getCoverBehaviorNew(aID);
        this.coverData = aCoverData == null ? this.coverBehavior.createDataObject() : aCoverData;
        this.coveredTile = new WeakReference<ICoverable>(aTile);
    }

    public CoverInfo(ICoverable aTile, NBTTagCompound aNBT) {
        this.coverSide = ForgeDirection.getOrientation((int)aNBT.func_74771_c(NBT_SIDE));
        this.coverID = aNBT.func_74762_e(NBT_ID);
        this.coverBehavior = GregTech_API.getCoverBehaviorNew(this.coverID);
        this.coverData = aNBT.func_74764_b(NBT_DATA) ? this.coverBehavior.createDataObject(aNBT.func_74781_a(NBT_DATA)) : this.coverBehavior.createDataObject();
        this.coveredTile = new WeakReference<ICoverable>(aTile);
    }

    public boolean isValid() {
        return this.coverID != 0 && this.coverSide != ForgeDirection.UNKNOWN;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT) {
        aNBT.func_74774_a(NBT_SIDE, (byte)this.coverSide.ordinal());
        aNBT.func_74768_a(NBT_ID, this.coverID);
        if (this.coverData != null) {
            aNBT.func_74782_a(NBT_DATA, this.coverData.saveDataToNBT());
        }
        return aNBT;
    }

    public int getCoverID() {
        return this.coverID;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean aUpdate) {
        this.needsUpdate = aUpdate;
    }

    public GT_CoverBehaviorBase<?> getCoverBehavior() {
        if (this.coverBehavior != null) {
            return this.coverBehavior;
        }
        return GregTech_API.sNoBehavior;
    }

    public ISerializableObject getCoverData() {
        if (this.coverData != null) {
            return this.coverData;
        }
        return GregTech_API.sNoBehavior.createDataObject();
    }

    public boolean onCoverRemoval(boolean aForced) {
        return this.getCoverBehavior().onCoverRemoval(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aForced);
    }

    public ItemStack getDrop() {
        return this.getCoverBehavior().getDrop(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public ItemStack getDisplayStack() {
        return this.getCoverBehavior().getDisplayStack(this.coverID, this.coverData);
    }

    public boolean isDataNeededOnClient() {
        return this.getCoverBehavior().isDataNeededOnClient(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public void onDropped() {
        this.getCoverBehavior().onDropped(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public void setCoverData(ISerializableObject aData) {
        this.coverData = aData;
    }

    public ITexture getSpecialCoverFGTexture() {
        return this.getCoverBehavior().getSpecialCoverFGTexture(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public ITexture getSpecialCoverTexture() {
        return this.getCoverBehavior().getSpecialCoverTexture(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public int getTickRate() {
        return this.getCoverBehavior().getTickRate(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public ForgeDirection getSide() {
        return this.coverSide;
    }

    public ICoverable getTile() {
        return (ICoverable)this.coveredTile.get();
    }

    public boolean isRedstoneSensitive(long aTickTimer) {
        return this.getCoverBehavior().isRedstoneSensitive(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aTickTimer);
    }

    public ISerializableObject doCoverThings(long aTickTimer, byte aRedstone) {
        return this.getCoverBehavior().doCoverThings(this.coverSide, aRedstone, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aTickTimer);
    }

    public void onBaseTEDestroyed() {
        this.getCoverBehavior().onBaseTEDestroyed(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public void updateCoverBehavior() {
        this.coverBehavior = GregTech_API.getCoverBehaviorNew(this.coverID);
    }

    public void preDataChanged(int aCoverID, ISerializableObject aCoverData) {
        this.getCoverBehavior().preDataChanged(this.coverSide, this.coverID, aCoverID, this.coverData, aCoverData, (ICoverable)this.coveredTile.get());
    }

    public void onDataChanged() {
        this.getCoverBehavior().onDataChanged(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public String getBehaviorDescription() {
        return this.getCoverBehavior().getDescription(this.coverSide, this.coverID, this.coverData, null);
    }

    public ModularWindow createWindow(EntityPlayer player) {
        GT_CoverUIBuildContext buildContext = new GT_CoverUIBuildContext(player, this.coverID, this.coverSide, (ICoverable)this.coveredTile.get(), true);
        return this.getCoverBehavior().createWindow(buildContext);
    }

    public boolean isGUIClickable() {
        return this.getCoverBehavior().isGUIClickable(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public boolean hasCoverGUI() {
        return this.getCoverBehavior().hasCoverGUI();
    }

    public boolean useModularUI() {
        return this.getCoverBehavior().useModularUI();
    }

    public boolean letsItemsIn(int aSlot) {
        return this.getCoverBehavior().letsItemsIn(this.coverSide, this.coverID, this.coverData, aSlot, (ICoverable)this.coveredTile.get());
    }

    public boolean letsItemsOut(int aSlot) {
        return this.getCoverBehavior().letsItemsOut(this.coverSide, this.coverID, this.coverData, aSlot, (ICoverable)this.coveredTile.get());
    }

    public boolean letsFluidIn(Fluid aFluid) {
        return this.letsFluidIn(aFluid, (ICoverable)this.coveredTile.get());
    }

    public boolean letsFluidOut(Fluid aFluid) {
        return this.letsFluidOut(aFluid, (ICoverable)this.coveredTile.get());
    }

    public boolean letsFluidIn(Fluid aFluid, ICoverable tile) {
        return this.getCoverBehavior().letsFluidIn(this.coverSide, this.coverID, this.coverData, aFluid, tile);
    }

    public boolean letsFluidOut(Fluid aFluid, ICoverable tile) {
        return this.getCoverBehavior().letsFluidOut(this.coverSide, this.coverID, this.coverData, aFluid, tile);
    }

    public boolean letsEnergyIn() {
        return this.getCoverBehavior().letsEnergyIn(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public boolean letsEnergyOut() {
        return this.getCoverBehavior().letsEnergyOut(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public boolean alwaysLookConnected() {
        return this.getCoverBehavior().alwaysLookConnected(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.getCoverBehavior().onCoverRightClick(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aPlayer, aX, aY, aZ);
    }

    public boolean onCoverShiftRightClick(EntityPlayer aPlayer) {
        return this.getCoverBehavior().onCoverShiftRightClick(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aPlayer);
    }

    public ISerializableObject onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.getCoverBehavior().onCoverScrewdriverClick(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get(), aPlayer, aX, aY, aZ);
    }

    public Block getFacadeBlock() {
        return this.getCoverBehavior().getFacadeBlock(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }

    public int getFacadeMeta() {
        return this.getCoverBehavior().getFacadeMeta(this.coverSide, this.coverID, this.coverData, (ICoverable)this.coveredTile.get());
    }
}

