/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_SlotWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_Cover_Fluidfilter
extends GT_CoverBehaviorBase<FluidFilterData> {
    private final int FILTER_INPUT_DENY_OUTPUT = 0;
    private final int INVERT_INPUT_DENY_OUTPUT = 1;
    private final int FILTER_INPUT_ANY_OUTPUT = 2;
    private final int INVERT_INPUT_ANY_OUTPUT = 3;
    private final int DENY_INPUT_FILTER_OUTPUT = 4;
    private final int DENY_INPUT_INVERT_OUTPUT = 5;
    private final int ANY_INPUT_FILTER_OUTPUT = 6;
    private final int ANY_INPUT_INVERT_OUTPUT = 7;

    @Deprecated
    GT_Cover_Fluidfilter() {
        this((ITexture)null);
    }

    public GT_Cover_Fluidfilter(ITexture coverTexture) {
        super(FluidFilterData.class, coverTexture);
    }

    @Override
    public FluidFilterData createDataObject() {
        return new FluidFilterData(-1, 0);
    }

    @Override
    public FluidFilterData createDataObject(int aLegacyData) {
        return new FluidFilterData(aLegacyData >>> 3, aLegacyData & 7);
    }

    @Override
    protected String getDescriptionImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        Fluid fluid = FluidRegistry.getFluid((int)aCoverVariable.mFluidID);
        if (fluid == null) {
            return "";
        }
        FluidStack sFluid = new FluidStack(fluid, 1000);
        return String.format("Filtering Fluid: %s - %s", sFluid.getLocalizedName(), this.getFilterMode(aCoverVariable.mFilterMode));
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected FluidFilterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    public String getFilterMode(int aFilterMode) {
        String string;
        switch (aFilterMode) {
            case 0: {
                string = GT_Utility.trans("043", "Filter input, Deny output");
                break;
            }
            case 1: {
                string = GT_Utility.trans("044", "Invert input, Deny output");
                break;
            }
            case 2: {
                string = GT_Utility.trans("045", "Filter input, Permit any output");
                break;
            }
            case 3: {
                string = GT_Utility.trans("046", "Invert input, Permit any output");
                break;
            }
            case 4: {
                string = GT_Utility.trans("307", "Deny input, Filter output");
                break;
            }
            case 5: {
                string = GT_Utility.trans("308", "Deny input, Invert output");
                break;
            }
            case 6: {
                string = GT_Utility.trans("309", "Permit any input, Filter output");
                break;
            }
            case 7: {
                string = GT_Utility.trans("310", "Permit any input, Invert output");
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    @Override
    protected FluidFilterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mFilterMode = (aCoverVariable.mFilterMode + (aPlayer.func_70093_af() ? -1 : 1)) % 8;
        if (aCoverVariable.mFilterMode < 0) {
            aCoverVariable.mFilterMode = 7;
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.getFilterMode(aCoverVariable.mFilterMode));
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        if ((double)aX > 0.375 && (double)aX < 0.625 || side.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625 || (side.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 && (double)aZ > 0.375 && (double)aZ < 0.625 || side.offsetZ != 0) {
            ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
            if (tStack == null) {
                return true;
            }
            FluidStack tFluid = GT_Utility.getFluidForFilledItem(tStack, true);
            if (tFluid != null) {
                int aFluid = tFluid.getFluidID();
                aCoverVariable.mFluidID = aFluid;
                aTileEntity.setCoverDataAtSide(side, aCoverVariable);
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsInImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable.mFilterMode;
        int aFilterFluid = aCoverVariable.mFluidID;
        if (aFilterMode == 4 || aFilterMode == 5) {
            return false;
        }
        if (aFilterMode == 6 || aFilterMode == 7) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 0 || aFilterMode == 2;
        }
        return aFilterMode == 1 || aFilterMode == 3;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = aCoverVariable.mFilterMode;
        int aFilterFluid = aCoverVariable.mFluidID;
        if (aFilterMode == 0 || aFilterMode == 1) {
            return false;
        }
        if (aFilterMode == 2 || aFilterMode == 3) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 4 || aFilterMode == 6;
        }
        return aFilterMode == 5 || aFilterMode == 7;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, FluidFilterData aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new FluidFilterUIFactory(buildContext).createWindow();
    }

    public static class FluidFilterData
    implements ISerializableObject {
        private int mFluidID;
        private int mFilterMode;

        public FluidFilterData(int mFluidID, int mFilterMode) {
            this.mFluidID = mFluidID;
            this.mFilterMode = mFilterMode;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidFilterData(this.mFluidID, this.mFilterMode);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74768_a("mFilterMode", this.mFilterMode);
            if (this.mFluidID >= 0) {
                tNBT.func_74778_a("mFluid", FluidRegistry.getFluid((int)this.mFluidID).getName());
            }
            return tNBT;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeByte(this.mFilterMode).writeInt(this.mFluidID);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tNBT = (NBTTagCompound)aNBT;
                this.mFilterMode = tNBT.func_74762_e("mFilterMode");
                this.mFluidID = tNBT.func_150297_b("mFluid", 8) ? FluidRegistry.getFluidID((String)tNBT.func_74779_i("mFluid")) : -1;
            }
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mFilterMode = aBuf.readByte();
            this.mFluidID = aBuf.readInt();
            return this;
        }
    }

    private class FluidFilterUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public FluidFilterUIFactory(GT_CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<FluidFilterData>(this::getCoverData, this::setCoverData, GT_Cover_Fluidfilter.this, (id, coverData) -> !this.getClickable((int)id, (FluidFilterData)coverData), (id, coverData) -> {
                ((FluidFilterData)coverData).mFilterMode = this.getNewFilterMode((int)id, (FluidFilterData)coverData);
                return coverData;
            }).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GT_Utility.trans("232", "Filter Input")).setPos(0, 0)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GT_Utility.trans("233", "Filter Output")).setPos(18, 0)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BLOCK_INPUT).addTooltip(GT_Utility.trans("234", "Block Output")).setPos(0, 36)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_ALLOW_INPUT).addTooltip(GT_Utility.trans("235", "Allow Output")).setPos(18, 36)).addToggleButton(4, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(GT_Utility.trans("236", "Whitelist Fluid")).setPos(0, 18)).addToggleButton(5, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BLACKLIST).addTooltip(GT_Utility.trans("237", "Blacklist Fluid")).setPos(18, 18)).addFollower((Widget)new CoverDataFollower_SlotWidget<FluidFilterData>((IItemHandlerModifiable)new ItemStackHandler(), 0, true){

                protected void putClickedStack(ItemStack stack, int mouseButton) {
                    if (stack != null && GT_Utility.getFluidFromContainerOrFluidDisplay(stack) == null) {
                        return;
                    }
                    super.putClickedStack(GT_Utility.getFluidDisplayStack(GT_Utility.getFluidFromContainerOrFluidDisplay(stack), false), mouseButton);
                }
            }, this::getFluidDisplayItem, (coverData, stack) -> {
                if (stack == null) {
                    ((FluidFilterData)coverData).mFluidID = -1;
                } else {
                    FluidStack fluid = GT_Utility.getFluidFromDisplayStack(stack);
                    if (fluid != null && fluid.getFluid() != null) {
                        ((FluidFilterData)coverData).mFluidID = fluid.getFluid().getID();
                    }
                }
                return coverData;
            }, widget -> widget.setBackground(new IDrawable[]{ModularUITextures.FLUID_SLOT}).setPos(0, 56)).setPos(10, 25))).widget(new TextWidget(GT_Utility.trans("238", "Filter Direction")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 28))).widget(new TextWidget(GT_Utility.trans("239", "Filter Type")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 46))).widget(new TextWidget(GT_Utility.trans("240", "Block Flow")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 64))).widget(TextWidget.dynamicString(() -> {
                ItemStack fluidDisplay;
                if (this.getCoverData() != null && (fluidDisplay = this.getFluidDisplayItem((FluidFilterData)this.getCoverData())) != null) {
                    return fluidDisplay.func_82833_r();
                }
                return GT_Utility.trans("315", "Filter Empty");
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TITLE.get()).intValue()).setPos(31, 83));
        }

        private int getNewFilterMode(int id, FluidFilterData coverVariable) {
            int n;
            switch (id) {
                case 0: {
                    n = coverVariable.mFilterMode & 3;
                    break;
                }
                case 1: {
                    n = coverVariable.mFilterMode | 4;
                    break;
                }
                case 2: {
                    n = coverVariable.mFilterMode & 5;
                    break;
                }
                case 3: {
                    n = coverVariable.mFilterMode | 2;
                    break;
                }
                case 4: {
                    n = coverVariable.mFilterMode & 6;
                    break;
                }
                case 5: {
                    n = coverVariable.mFilterMode | 1;
                    break;
                }
                default: {
                    n = coverVariable.mFilterMode;
                }
            }
            return n;
        }

        private boolean getClickable(int id, FluidFilterData coverVariable) {
            boolean bl;
            switch (id) {
                case 0: 
                case 1: {
                    if ((coverVariable.mFilterMode >> 2 & 1) != (id & 1)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: 
                case 3: {
                    if ((coverVariable.mFilterMode >> 1 & 1) != (id & 1)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: 
                case 5: {
                    if ((coverVariable.mFilterMode & 1) != (id & 1)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private ItemStack getFluidDisplayItem(FluidFilterData coverData) {
            Fluid fluid = FluidRegistry.getFluid((int)coverData.mFluidID);
            return GT_Utility.getFluidDisplayStack(fluid);
        }
    }
}

