/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.entities;

import com.mojang.authlib.GameProfile;
import gregtech.api.enums.ParticleFX;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class GT_Entity_Arrow
extends EntityArrow {
    private int mHitBlockX = -1;
    private int mHitBlockY = -1;
    private int mHitBlockZ = -1;
    private Block mHitBlock = Blocks.field_150350_a;
    private int mHitBlockMeta = 0;
    private boolean inGround = false;
    private int mTicksAlive = 0;
    private int ticksInAir = 0;
    private int mKnockback = 0;
    private ItemStack mArrow = null;

    public GT_Entity_Arrow(World aWorld) {
        super(aWorld);
    }

    public GT_Entity_Arrow(World aWorld, double aX, double aY, double aZ) {
        super(aWorld, aX, aY, aZ);
    }

    public GT_Entity_Arrow(World aWorld, EntityLivingBase aEntity, float aSpeed) {
        super(aWorld, aEntity, aSpeed);
    }

    public GT_Entity_Arrow(EntityArrow aArrow, ItemStack aStack) {
        super(aArrow.field_70170_p);
        NBTTagCompound tNBT = new NBTTagCompound();
        aArrow.func_70109_d(tNBT);
        this.func_70020_e(tNBT);
        this.setArrowItem(aStack);
    }

    public void func_70071_h_() {
        Block tBlock;
        this.func_70030_z();
        if (this.mArrow == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        Entity tShootingEntity = this.field_70250_c;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if (this.mTicksAlive++ == 3000) {
            this.func_70106_y();
        }
        if ((tBlock = this.field_70170_p.func_147439_a(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ)).func_149688_o() != Material.field_151579_a) {
            tBlock.func_149719_a((IBlockAccess)this.field_70170_p, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            AxisAlignedBB axisalignedbb = tBlock.func_149668_a(this.field_70170_p, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.inGround) {
            int j = this.field_70170_p.func_72805_g(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (tBlock != this.mHitBlock || j != this.mHitBlockMeta) {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.mTicksAlive = 0;
                this.ticksInAir = 0;
            }
        } else {
            Entity potentiallyHitEntity2;
            ++this.ticksInAir;
            Vec3 vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition tVector = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (tVector != null) {
                vec3 = Vec3.func_72443_a((double)tVector.field_72307_f.field_72450_a, (double)tVector.field_72307_f.field_72448_b, (double)tVector.field_72307_f.field_72449_c);
            }
            Entity tHitEntity = null;
            List tAllPotentiallyHitEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double tLargestDistance = Double.MAX_VALUE;
            for (Entity potentiallyHitEntity2 : tAllPotentiallyHitEntities) {
                double tDistance;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                if (!potentiallyHitEntity2.func_70067_L() || potentiallyHitEntity2 == tShootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = potentiallyHitEntity2.field_70121_D.func_72314_b(0.3, 0.3, 0.3)).func_72327_a(vec31, vec3)) == null || !((tDistance = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < tLargestDistance)) continue;
                tHitEntity = potentiallyHitEntity2;
                tLargestDistance = tDistance;
            }
            if (tHitEntity != null) {
                tVector = new MovingObjectPosition(tHitEntity);
            }
            if (tVector != null && (potentiallyHitEntity2 = tVector.field_72308_g) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)potentiallyHitEntity2;
                if (entityplayer.field_71075_bZ.field_75102_a || tShootingEntity instanceof EntityPlayer && !((EntityPlayer)tShootingEntity).func_96122_a(entityplayer)) {
                    tVector = null;
                }
            }
            if (tVector != null) {
                if (tVector.field_72308_g != null) {
                    int tHitTimer;
                    int tKnockback;
                    ItemData tData = GT_OreDictUnificator.getItemData(this.mArrow);
                    float tMagicDamage = tVector.field_72308_g instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.mArrow, (EnumCreatureAttribute)((EntityLivingBase)tVector.field_72308_g).func_70668_bt()) : 0.0f;
                    float tDamage = MathHelper.func_76143_f((double)((double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * (this.func_70242_d() + (double)(tData != null && tData.mMaterial != null && tData.mMaterial.mMaterial != null ? (float)tData.mMaterial.mMaterial.mToolQuality / 2.0f - 1.0f : 0.0f))));
                    if (this.func_70241_g()) {
                        tDamage += (float)this.field_70146_Z.nextInt((int)((double)tDamage / 2.0 + 2.0));
                    }
                    int tFireDamage = (this.func_70027_ad() ? 5 : 0) + 4 * EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)this.mArrow);
                    int[] tDamages = this.onHitEntity(tVector.field_72308_g, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow == null ? new ItemStack(Items.field_151032_g, 1) : this.mArrow, (int)(tDamage * 2.0f), (int)(tMagicDamage * 2.0f), tKnockback = this.mKnockback + EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)this.mArrow), tFireDamage, tHitTimer = -1);
                    if (tDamages != null) {
                        tDamage = (float)tDamages[0] / 2.0f;
                        tMagicDamage = (float)tDamages[1] / 2.0f;
                        tKnockback = tDamages[2];
                        tFireDamage = tDamages[3];
                        tHitTimer = tDamages[4];
                        if (tFireDamage > 0 && !(tVector.field_72308_g instanceof EntityEnderman)) {
                            tVector.field_72308_g.func_70015_d(tFireDamage);
                        }
                        if (!(tHitEntity instanceof EntityPlayer) && EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)this.mArrow) > 0) {
                            FakePlayer tPlayer = null;
                            if (this.field_70170_p instanceof WorldServer) {
                                tPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_70170_p), (GameProfile)new GameProfile(new UUID(0L, 0L), tShootingEntity instanceof EntityLivingBase ? tShootingEntity.func_70005_c_() : "Arrow"));
                            }
                            if (tPlayer != null) {
                                tPlayer.field_71071_by.field_70461_c = 0;
                                tPlayer.field_71071_by.func_70299_a(0, this.getArrowItem());
                                tShootingEntity = tPlayer;
                                tPlayer.func_70106_y();
                            }
                        }
                        DamageSource tDamageSource = DamageSource.func_76353_a((EntityArrow)this, (Entity)(tShootingEntity == null ? this : tShootingEntity));
                        if (tDamage + tMagicDamage > 0.0f && tVector.field_72308_g.func_70097_a(tDamageSource, tDamage + tMagicDamage)) {
                            Entity entity = tVector.field_72308_g;
                            if (entity instanceof EntityLivingBase) {
                                float tKnockbackDivider;
                                EntityLivingBase tHitLivingEntity = (EntityLivingBase)entity;
                                if (tHitTimer >= 0) {
                                    tVector.field_72308_g.field_70172_ad = tHitTimer;
                                }
                                if (tVector.field_72308_g instanceof EntityCreeper && EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)this.mArrow) > 0) {
                                    ((EntityCreeper)tVector.field_72308_g).func_146079_cb();
                                }
                                if (!this.field_70170_p.field_72995_K) {
                                    tHitLivingEntity.func_85034_r(tHitLivingEntity.func_85035_bI() + 1);
                                }
                                if (tKnockback > 0 && (tKnockbackDivider = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                    tHitLivingEntity.func_70024_g(this.field_70159_w * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider, 0.1, this.field_70179_y * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider);
                                }
                                GT_Utility.GT_EnchantmentHelper.applyBullshitA(tHitLivingEntity, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow);
                                GT_Utility.GT_EnchantmentHelper.applyBullshitB(tShootingEntity instanceof EntityLivingBase ? (EntityLivingBase)tShootingEntity : null, (Entity)tHitLivingEntity, this.mArrow);
                                if (tHitLivingEntity != tShootingEntity && tHitLivingEntity instanceof EntityPlayer && tShootingEntity instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)tShootingEntity).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                                }
                            }
                            if (tShootingEntity instanceof EntityPlayer && tMagicDamage > 0.0f) {
                                ((EntityPlayer)tShootingEntity).func_71047_c(tVector.field_72308_g);
                            }
                            if (!(tVector.field_72308_g instanceof EntityEnderman) || ((EntityEnderman)tVector.field_72308_g).func_70660_b(Potion.field_76437_t) != null) {
                                if (tFireDamage > 0) {
                                    tVector.field_72308_g.func_70015_d(tFireDamage);
                                }
                                this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                                this.func_70106_y();
                            }
                        } else {
                            this.field_70159_w *= -0.1000000014901161;
                            this.field_70181_x *= -0.1000000014901161;
                            this.field_70179_y *= -0.1000000014901161;
                            this.field_70177_z += 180.0f;
                            this.field_70126_B += 180.0f;
                            this.ticksInAir = 0;
                        }
                    }
                } else {
                    this.mHitBlockX = tVector.field_72311_b;
                    this.mHitBlockY = tVector.field_72312_c;
                    this.mHitBlockZ = tVector.field_72309_d;
                    this.mHitBlock = this.field_70170_p.func_147439_a(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.mHitBlockMeta = this.field_70170_p.func_72805_g(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.field_70159_w = (float)(tVector.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(tVector.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(tVector.field_72307_f.field_72449_c - this.field_70161_v);
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * 0.0500000007450581;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * 0.0500000007450581;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * 0.0500000007450581;
                    this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.field_70249_b = 7;
                    this.func_70243_d(false);
                    if (this.mHitBlock.func_149688_o() != Material.field_151579_a) {
                        this.mHitBlock.func_149670_a(this.field_70170_p, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, (Entity)this);
                    }
                    if (!this.field_70170_p.field_72995_K && EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)this.mArrow) > 2) {
                        GT_Utility.setCoordsOnFire(this.field_70170_p, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, true);
                    }
                    if (this.breaksOnImpact()) {
                        this.func_70106_y();
                    }
                }
            }
            WorldSpawnedEventBuilder.ParticleEventBuilder events = new WorldSpawnedEventBuilder.ParticleEventBuilder().setWorld(this.field_70170_p);
            if (this.func_70241_g()) {
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)events.setIdentifier((Enum)ParticleFX.CRIT)).setMotion(-this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y).times(4, (x, i) -> x.setPosition(this.field_70165_t + this.field_70159_w * (double)i.intValue() / 4.0, this.field_70163_u + this.field_70181_x * (double)i.intValue() / 4.0, this.field_70161_v + this.field_70179_y * (double)i.intValue() / 4.0).run());
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float tFrictionMultiplier = 0.99f;
            if (this.func_70090_H()) {
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)events.setMotion(-this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y).setIdentifier((Enum)ParticleFX.BUBBLE)).setPosition(this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25).times(4, Runnable::run);
                tFrictionMultiplier = 0.8f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)tFrictionMultiplier;
            this.field_70181_x *= (double)tFrictionMultiplier;
            this.field_70179_y *= (double)tFrictionMultiplier;
            this.field_70181_x -= 0.0500000007450581;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70014_b(NBTTagCompound aNBT) {
        super.func_70014_b(aNBT);
        aNBT.func_74777_a("xTile", (short)this.mHitBlockX);
        aNBT.func_74777_a("yTile", (short)this.mHitBlockY);
        aNBT.func_74777_a("zTile", (short)this.mHitBlockZ);
        aNBT.func_74777_a("life", (short)this.mTicksAlive);
        aNBT.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.mHitBlock));
        aNBT.func_74774_a("inData", (byte)this.mHitBlockMeta);
        aNBT.func_74774_a("shake", (byte)this.field_70249_b);
        aNBT.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        aNBT.func_74774_a("pickup", (byte)this.field_70251_a);
        aNBT.func_74780_a("damage", this.func_70242_d());
        aNBT.func_74782_a("mArrow", this.mArrow == null ? null : this.mArrow.func_77955_b(new NBTTagCompound()));
    }

    public void func_70037_a(NBTTagCompound aNBT) {
        super.func_70037_a(aNBT);
        this.mHitBlockX = aNBT.func_74765_d("xTile");
        this.mHitBlockY = aNBT.func_74765_d("yTile");
        this.mHitBlockZ = aNBT.func_74765_d("zTile");
        this.mTicksAlive = aNBT.func_74765_d("life");
        this.mHitBlock = Block.func_149729_e((int)(aNBT.func_74771_c("inTile") & 0xFF));
        this.mHitBlockMeta = aNBT.func_74771_c("inData") & 0xFF;
        this.field_70249_b = aNBT.func_74771_c("shake") & 0xFF;
        this.inGround = aNBT.func_74771_c("inGround") == 1;
        this.func_70239_b(aNBT.func_74769_h("damage"));
        this.field_70251_a = aNBT.func_74771_c("pickup");
        this.mArrow = GT_Utility.loadItem(aNBT, "mArrow");
    }

    public void func_70100_b_(EntityPlayer aPlayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.field_70249_b <= 0 && this.field_70251_a == 1 && aPlayer.field_71071_by.func_70441_a(this.getArrowItem())) {
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            aPlayer.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    public int[] onHitEntity(Entity aHitEntity, Entity aShootingEntity, ItemStack aArrow, int aRegularDamage, int aMagicDamage, int aKnockback, int aFireDamage, int aHitTimer) {
        return new int[]{aRegularDamage, aMagicDamage, aKnockback, aFireDamage, aHitTimer};
    }

    public ItemStack getArrowItem() {
        return GT_Utility.copyOrNull(this.mArrow);
    }

    public void setArrowItem(ItemStack aStack) {
        this.mArrow = GT_Utility.updateItemStack(GT_Utility.copyAmount(1L, aStack));
    }

    public boolean breaksOnImpact() {
        return false;
    }

    public void func_70240_a(int aKnockback) {
        this.mKnockback = aKnockback;
    }
}

