/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ExoticEnergyInputHelper;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ProcessingArray_Manager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GT_MetaTileEntity_ProcessingArray>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_ProcessingArray> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"hhh", "hhh", "hhh"}, {"h~h", "h-h", "hhh"}, {"hhh", "hhh", "hhh"}})).addElement('h', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).casingIndex(48).dot(1).build()), StructureUtility.onElementPass(t -> ++t.mCasingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0))})).build();
    private int mCasingAmount = 0;
    private GT_Recipe.GT_Recipe_Map mLastRecipeMap;
    private ItemStack lastControllerStack;
    private int tTier = 0;
    private int mMult = 0;
    private boolean downtierUEV = true;

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Processing Array").addInfo("Runs supplied machines as if placed in the world").addInfo("Place up to 64 singleblock GT machines into the controller").addInfo("Note that you still need to supply power to them all").addInfo("Use a screwdriver to enable separate input busses").addInfo("Use a wire cutter to disable UEV+ downtiering").addInfo("Doesn't work on certain machines, deal with it").addInfo("Use it if you hate GT++, or want even more speed later on").addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoRange("Robust Tungstensteel Machine Casing", 14, 24, false).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addInputBus("Any casing", 1).addInputHatch("Any casing", 1).addOutputBus("Any casing", 1).addOutputHatch("Any casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    private GT_Recipe.GT_Recipe_Map fetchRecipeMap() {
        if (this.isCorrectMachinePart(this.getControllerSlot())) {
            return GT_ProcessingArray_Manager.giveRecipeMap(GT_ProcessingArray_Manager.getMachineName(this.getControllerSlot()));
        }
        return null;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mLastRecipeMap;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.");
    }

    @Override
    protected void sendStartMultiBlockSoundLoop() {
        SoundResource sound = GT_ProcessingArray_Manager.getSoundResource(GT_ProcessingArray_Manager.getMachineName(this.getControllerSlot()));
        if (sound != null) {
            this.sendLoopStart((byte)sound.id);
        }
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        SoundResource sound = SoundResource.get(aIndex < 0 ? aIndex + 256 : 0);
        if (sound != null) {
            GT_Utility.doSoundAtClient(sound, this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (!GT_Utility.areStacksEqual(this.lastControllerStack, this.getControllerSlot())) {
            this.lastControllerStack = this.getControllerSlot();
            this.mLastRecipeMap = this.fetchRecipeMap();
            this.setTierAndMult();
        }
        if (this.mLastRecipeMap == null) {
            return SimpleCheckRecipeResult.ofFailure("no_machine");
        }
        if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null && this.mSingleRecipeCheck.getRecipeMap() != this.mLastRecipeMap) {
            return SimpleCheckRecipeResult.ofFailure("machine_mismatch");
        }
        return super.checkProcessing();
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                if (GT_Mod.gregtechproxy.mLowGravProcessing && recipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(recipe, GT_MetaTileEntity_ProcessingArray.this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
                    return SimpleCheckRecipeResult.ofFailure("high_gravity");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }.setMaxParallelSupplier(this::getMaxParallel);
    }

    @Override
    protected boolean canUseControllerSlotForRecipe() {
        return false;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Values.V[this.tTier] * (long)(this.mLastRecipeMap != null ? this.mLastRecipeMap.mAmperage : 1));
        logic.setAvailableAmperage(this.getMaxParallel());
        logic.setAmperageOC(false);
    }

    private void setTierAndMult() {
        IMetaTileEntity aMachine = GT_Item_Machines.getMetaTileEntity(this.getControllerSlot());
        this.tTier = aMachine instanceof GT_MetaTileEntity_TieredMachineBlock ? (int)((GT_MetaTileEntity_TieredMachineBlock)aMachine).mTier : 0;
        this.mMult = 0;
        if (this.downtierUEV && this.tTier > 9) {
            --this.tTier;
            this.mMult = 2;
        }
    }

    private int getMaxParallel() {
        if (this.getControllerSlot() == null) {
            return 0;
        }
        return this.getControllerSlot().field_77994_a << this.mMult;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mMachine && aTick % 20L == 0L) {
            for (GT_MetaTileEntity_Hatch_InputBus tInputBus : this.mInputBusses) {
                tInputBus.mRecipeMap = this.mLastRecipeMap;
            }
            for (GT_MetaTileEntity_Hatch_Input tInputHatch : this.mInputHatches) {
                tInputHatch.mRecipeMap = this.mLastRecipeMap;
            }
        }
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_ProcessingArray> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    private boolean checkHatches() {
        return this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("downtierUEV", this.downtierUEV);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparate");
        }
        if (aNBT.func_74764_b("mUseMultiparallelMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
        this.downtierUEV = aNBT.func_74767_n("downtierUEV");
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        } else {
            this.inputSeparation = !this.inputSeparation;
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer(aPlayer, "Batch recipes");
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, "Don't batch recipes");
            }
        } else {
            this.downtierUEV = !this.downtierUEV;
            GT_Utility.sendChatToPlayer(aPlayer, "Treat UEV+ machines as multiple UHV " + this.downtierUEV);
        }
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private List<IHatchElement<? super GT_MetaTileEntity_ProcessingArray>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.OutputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.OutputBus, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy, (Object)GT_HatchElement.ExoticEnergy);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mExoticEnergyHatches.clear();
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0) && this.mCasingAmount >= 14 && this.checkHatches();
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mExoticEnergyHatches) {
            if (!GT_MetaTileEntity_ProcessingArray.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(GT_ExoticEnergyInputHelper.getMaxInputVoltageMulti(this.getExoticAndNormalEnergyHatchList())) + EnumChatFormatting.RESET + " EU/t(*" + GT_Utility.formatNumbers(GT_ExoticEnergyInputHelper.getMaxInputAmpsMulti(this.getExoticAndNormalEnergyHatchList())) + "A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(GT_ExoticEnergyInputHelper.getMaxInputVoltageMulti(this.getExoticAndNormalEnergyHatchList()))] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.PA.machinetier") + ": " + EnumChatFormatting.GREEN + this.tTier + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.PA.discount") + ": " + EnumChatFormatting.GREEN + 1 + EnumChatFormatting.RESET + " x", StatCollector.func_74838_a((String)"GT5U.PA.parallel") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.getMaxParallel()) + EnumChatFormatting.RESET};
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.downtierUEV = !this.downtierUEV;
            this.setTierAndMult();
        }).setPlayClickSound(true).setBackground(() -> {
            if (this.downtierUEV) {
                return new IDrawable[]{GT_UITextures.BUTTON_STANDARD_PRESSED, GT_UITextures.OVERLAY_BUTTON_DOWN_TIERING_ON};
            }
            return new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_DOWN_TIERING_OFF};
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.down_tier")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.downtierUEV, val -> {
            this.downtierUEV = val;
        }));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.mLastRecipeMap != null && this.getControllerSlot() != null) {
            tag.func_74778_a("type", this.getControllerSlot().func_82833_r());
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("type")) {
            currentTip.add("Machine: " + EnumChatFormatting.YELLOW + tag.func_74779_i("type"));
        } else {
            currentTip.add("Machine: " + EnumChatFormatting.YELLOW + "None");
        }
    }
}

