/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.openmodularturrets.entity.projectiles;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMHadronDefinition;
import gregtech.api.enums.SoundResource;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import openmodularturrets.entity.projectiles.LaserProjectile;
import openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.util.PlayerUtil;
import openmodularturrets.util.TurretHeadUtil;

public class projectileEM
extends LaserProjectile {
    public float gravity = 0.0f;
    private TurretBase turretBase;
    private boolean strange;
    private boolean antiMatter;
    private boolean isAmped;
    private int ampLevel;
    private float massFactor;
    private double mass;
    private double charge;

    public projectileEM(World par1World) {
        super(par1World);
    }

    public projectileEM(World par1World, TurretBase turretBase) {
        super(par1World, turretBase);
        int amp = TurretHeadUtil.getAmpLevel((TurretBase)turretBase);
        if (amp > 0) {
            this.isAmped = true;
            this.ampLevel = amp;
        }
    }

    public projectileEM(World par1World, TurretBase turretBase, EMInstanceStack projectileContent) {
        super(par1World, turretBase);
        this.turretBase = turretBase;
        if (projectileContent != null) {
            this.mass = projectileContent.getMass();
            this.charge = projectileContent.getCharge();
            this.massFactor = (float)(projectileContent.getDefinition().getMass() / EMHadronDefinition.hadron_n_.getMass());
            if (projectileContent.getDefinition().getGeneration() > 1 || projectileContent.getDefinition().getGeneration() < -1) {
                this.strange = true;
            }
            if (projectileContent.getDefinition().getGeneration() < 0) {
                this.antiMatter = true;
            }
            this.gravity = projectileContent.getDefinition().getCharge() == 0 ? this.massFactor / 100.0f : Math.min(0.0025f / (float)Math.abs(projectileContent.getDefinition().getCharge()), this.massFactor / 100.0f);
        }
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        if (this.field_70173_aa > 1) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "openmodularturrets:laserHit", ConfigHandler.getTurretSoundVolume(), TecTech.RANDOM.nextFloat() + 0.5f);
                switch (movingobjectposition.field_72313_a) {
                    case BLOCK: {
                        Block hitBlock = this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
                        if (hitBlock == null) break;
                        if (TecTech.configTecTech.ENABLE_TURRET_EXPLOSIONS && this.antiMatter && hitBlock.func_149688_o().func_76220_a()) {
                            GT_Utility.sendSoundToPlayers((World)this.field_70170_p, (SoundResource)SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, (float)1.0f, (float)-1.0f, (int)movingobjectposition.field_72311_b, (int)movingobjectposition.field_72312_c, (int)movingobjectposition.field_72309_d);
                            this.field_70170_p.func_72876_a(null, (double)movingobjectposition.field_72311_b + 0.5, (double)movingobjectposition.field_72312_c + 0.5, (double)movingobjectposition.field_72309_d + 0.5, TecTech.configTecTech.TURRET_EXPLOSION_FACTOR * (float)(this.strange ? 10 : 1) * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f) * ((float)this.field_70173_aa / 250.0f), true);
                            break;
                        }
                        return;
                    }
                    case ENTITY: {
                        float damage = (float)(this.strange ? 10 : 1) * TecTech.configTecTech.TURRET_DAMAGE_FACTOR * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f);
                        if (movingobjectposition.field_72308_g instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)movingobjectposition.field_72308_g;
                            if (this.canDamagePlayer(player)) {
                                movingobjectposition.field_72308_g.func_70015_d((this.strange ? 10 : 1) * 2);
                                movingobjectposition.field_72308_g.func_70097_a((DamageSource)new NormalDamageSource("laser"), damage);
                                if (this.antiMatter) {
                                    movingobjectposition.field_72308_g.field_70172_ad = 0;
                                }
                                if (this.strange) {
                                    TecTech.anomalyHandler.addCancer(player, this.mass);
                                }
                                if (this.charge != 0.0) {
                                    TecTech.anomalyHandler.addCharge(player, this.charge);
                                }
                            }
                        } else {
                            movingobjectposition.field_72308_g.func_70015_d((this.strange ? 10 : 1) * 2);
                            movingobjectposition.field_72308_g.func_70097_a((DamageSource)new NormalDamageSource("laser"), damage);
                            if (this.antiMatter) {
                                movingobjectposition.field_72308_g.field_70172_ad = 0;
                            }
                        }
                        if (!TecTech.configTecTech.ENABLE_TURRET_EXPLOSIONS || !this.antiMatter) break;
                        GT_Utility.sendSoundToPlayers((World)this.field_70170_p, (SoundResource)SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, (float)1.0f, (float)-1.0f, (int)((int)movingobjectposition.field_72308_g.field_70165_t), (int)((int)movingobjectposition.field_72308_g.field_70163_u), (int)((int)movingobjectposition.field_72308_g.field_70161_v));
                        this.field_70170_p.func_72876_a(null, movingobjectposition.field_72308_g.field_70165_t, movingobjectposition.field_72308_g.field_70163_u, movingobjectposition.field_72308_g.field_70161_v, (float)(this.strange ? 10 : 1) * TecTech.configTecTech.TURRET_EXPLOSION_FACTOR * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f) * ((float)this.field_70173_aa / 250.0f), true);
                        break;
                    }
                }
            }
            this.func_70106_y();
        }
    }

    public boolean canDamagePlayer(EntityPlayer entityPlayer) {
        return ConfigHandler.turretDamageTrustedPlayers || this.turretBase.getTrustedPlayer(entityPlayer.func_110124_au()) == null && !PlayerUtil.getPlayerUIDUnstable((String)this.turretBase.getOwner()).equals(entityPlayer.func_110124_au());
    }

    public void func_70030_z() {
        if (this.field_70173_aa >= 75) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return this.gravity;
    }
}

