/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.BitSet;

public class SlidingWindowBitSet {
    private final BitSet set = new BitSet();
    private final int window;
    private int currentEx = -1;
    private int cleared;

    public SlidingWindowBitSet(int window) {
        this.window = window;
    }

    public void set(long i, boolean b) {
        int mod = (int)i & (1 << this.window) - 1;
        this.checkEx(i);
        this.set.set(mod, b);
    }

    public void set(long i) {
        int mod = (int)i & (1 << this.window) - 1;
        this.checkEx(i);
        this.set.set(mod);
    }

    public boolean get(long i) {
        int mod = (int)i & (1 << this.window) - 1;
        this.checkEx(i);
        return this.set.get(mod);
    }

    private void checkEx(long i) {
        int bit = 1 << this.window;
        int mod = (int)i & bit - 1;
        int ex = (int)i >> this.window;
        if (this.currentEx < ex) {
            if (this.cleared < bit) {
                this.set.clear(this.cleared, bit);
            }
            this.currentEx = ex;
            this.cleared = 0;
        }
        if (this.cleared <= mod && this.currentEx == ex) {
            int clear_till = (mod >> 6) + 1 << 6;
            this.set.clear(this.cleared, clear_till);
            this.cleared = clear_till;
        }
    }
}

