/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.base;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.CoverInfo;
import gtPlusPlus.api.interfaces.ILazyCoverable;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BTF_Inventory;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import ic2.api.Direction;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBase
extends TileEntity
implements ILazyCoverable,
IGregTechDeviceInformation,
IDescribable {
    private String customName;
    public String mOwnerName = "null";
    public String mOwnerUUID = "null";
    private boolean mIsOwnerOP = false;
    public final BTF_Inventory mInventory;
    private final GT_CoverBehavior[] mCoverBehaviors = new GT_CoverBehavior[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected TileEntityBase mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected int[] mAverageEUInput = new int[11];
    protected int[] mAverageEUOutput = new int[11];
    private boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    private int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverData = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean mHasEnoughEnergy = true;
    protected boolean mRunningThroughTick = false;
    protected boolean mInputDisabled = false;
    protected boolean mOutputDisabled = false;
    private boolean mMuffler = false;
    private boolean mLockUpgrade = false;
    private boolean mActive = false;
    private boolean mRedstone = false;
    private boolean mWorkUpdate = false;
    private boolean mSteamConverter = false;
    private boolean mInventoryChanged = false;
    private boolean mWorks = true;
    private boolean mNeedsUpdate = true;
    private boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private boolean oRedstone = false;
    private boolean mEnergyStateReady = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte mStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte oTexturePage = 0;
    private byte oLightValueClient = (byte)-1;
    private byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private byte mOtherUpgrades = 0;
    private byte mFacing = 0;
    private byte oFacing = 0;
    private byte mWorkData = 0;
    private int mDisplayErrorCode = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;
    private short mID = 0;
    protected long mTickTimer = 0L;
    private long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private boolean firstTicked = false;

    public TileEntityBase(int aCapacity) {
        this.mInventory = new BTF_Inventory(aCapacity, this);
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        nbt.func_74757_a("mIsOwnerOP", this.mIsOwnerOP);
        nbt.func_74778_a("mOwnerName", this.mOwnerName);
        nbt.func_74778_a("mOwnerUUID", this.mOwnerUUID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
        this.mIsOwnerOP = nbt.func_74767_n("mIsOwnerOP");
        this.mOwnerName = nbt.func_74779_i("mOwnerName");
        this.mOwnerUUID = nbt.func_74779_i("mOwnerUUID");
    }

    public void func_145845_h() {
        long aTick = System.currentTimeMillis();
        this.isDead = false;
        if (!this.firstTicked) {
            this.onFirstTick();
        }
        try {
            if (this.isServerSide()) {
                this.onPreTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's pre-tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onPostTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's post-tick stage.");
            t.printStackTrace();
        }
    }

    public boolean onPreTick(long aTick) {
        return true;
    }

    public boolean onTick(long aTick) {
        try {
            if (this.isServerSide()) {
                this.processRecipe();
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's processing of a recipe stage.");
            t.printStackTrace();
        }
        return true;
    }

    public boolean onPostTick(long aTick) {
        return true;
    }

    public boolean processRecipe() {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public String getOwner() {
        if (this.mOwnerName == null) {
            return "null";
        }
        return this.mOwnerName;
    }

    public UUID getOwnerUUID() {
        return UUID.fromString(this.mOwnerUUID);
    }

    public boolean isOwnerOP() {
        return this.mIsOwnerOP;
    }

    public void setOwnerInformation(String mName, String mUUID, boolean mOP) {
        if (this.isServerSide() && (this.mOwnerName == null || this.mOwnerUUID == null || this.mOwnerName.equals("null") || this.mOwnerUUID.equals("null"))) {
            this.mOwnerName = mName;
            this.mOwnerUUID = mUUID;
            this.mIsOwnerOP = mOP;
        }
    }

    public boolean isServerSide() {
        return this.func_145830_o() && !this.func_145831_w().field_72995_K;
    }

    public final boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.tileentity.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        return this.mInventory.func_70301_a(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mInventory.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.mInventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.mInventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.mInventory.func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
        this.mInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.mInventory.func_70305_f();
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mInventory.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (this.canAccessData() && (coverInfo.letsItemsOut(-1) || coverInfo.letsItemsIn(-1))) {
            return this.mInventory.func_94128_d(ordinalSide);
        }
        return new int[0];
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.getCoverInfoAtSide(side).letsItemsIn(aIndex) && this.mInventory.func_102007_a(aIndex, aStack, ordinalSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.getCoverInfoAtSide(side).letsItemsOut(aIndex) && this.mInventory.func_102008_b(aIndex, aStack, ordinalSide);
    }

    public boolean isValidSlot(int aIndex) {
        return this.canAccessData() ? this.mInventory.isValidSlot(aIndex) : false;
    }

    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    protected final boolean canAccessData() {
        return !this.isDead() && !this.func_145837_r();
    }

    public void issueBlockUpdate() {
        super.func_70296_d();
    }

    public void issueCoverUpdate(ForgeDirection side) {
        this.issueClientUpdate();
    }

    public void receiveCoverData(ForgeDirection coverSide, int coverID, int coverData) {
        if (coverSide != ForgeDirection.UNKNOWN && this.mCoverSides[coverSide.ordinal()] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    public long getTimer() {
        return this.mTickTimer;
    }

    public long getOutputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesOut() : 0L;
    }

    public long getOutputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput() ? this.mMetaTileEntity.maxEUOutput() : 0L;
    }

    public long getInputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesIn() : 0L;
    }

    public long getInputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxEUInput() : Integer.MAX_VALUE;
    }

    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return !this.canAccessData() ? false : (this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy));
    }

    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() >= this.getEUCapacity() && !aIgnoreTooMuchEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
        return true;
    }

    public boolean inputEnergyFrom(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN ? true : (!this.isServerSide() ? this.isEnergyInputSide(side) : side != ForgeDirection.UNKNOWN && this.mActiveEUInputs[side.ordinal()] && !this.mReleaseEnergy);
    }

    public boolean outputsEnergyTo(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN ? true : (!this.isServerSide() ? this.isEnergyOutputSide(side) : side != ForgeDirection.UNKNOWN && this.mActiveEUOutputs[side.ordinal()] || this.mReleaseEnergy);
    }

    private boolean isEnergyInputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (!this.getCoverInfoAtSide(side).letsEnergyIn()) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(side);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (!this.getCoverInfoAtSide(side).letsEnergyOut()) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(side);
            }
        }
        return false;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    private void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            this.mBufferedTileEntities[i] = null;
        }
    }

    public final World getWorld() {
        return this.field_145850_b;
    }

    public final int getXCoord() {
        return this.field_145851_c;
    }

    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    public final int getZCoord() {
        return this.field_145849_e;
    }

    public final int getOffsetX(ForgeDirection side, int aMultiplier) {
        return this.field_145851_c + side.offsetX * aMultiplier;
    }

    public final short getOffsetY(ForgeDirection side, int aMultiplier) {
        return (short)(this.field_145848_d + side.offsetY * aMultiplier);
    }

    public final int getOffsetZ(ForgeDirection side, int aMultiplier) {
        return this.field_145849_e + side.offsetZ * aMultiplier;
    }

    public final int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final Block getBlockAtSide(ForgeDirection side) {
        return this.getBlockAtSideAndDistance(side, 1);
    }

    public final Block getBlockAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getBlock(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getMetaIDAtSide(ForgeDirection side) {
        return this.getMetaIDAtSideAndDistance(side, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getMetaID(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final byte getLightLevelAtSide(ForgeDirection side) {
        return this.getLightLevelAtSideAndDistance(side, 1);
    }

    public final byte getLightLevelAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getLightLevel(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getOpacityAtSide(ForgeDirection side) {
        return this.getOpacityAtSideAndDistance(side, 1);
    }

    public final boolean getOpacityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getOpacity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getSkyAtSide(ForgeDirection side) {
        return this.getSkyAtSideAndDistance(side, 1);
    }

    public final boolean getSkyAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getSky(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getAirAtSide(ForgeDirection side) {
        return this.getAirAtSideAndDistance(side, 1);
    }

    public final boolean getAirAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getAir(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final TileEntity getTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return aDistance == 1 ? this.getTileEntityAtSide(side) : this.getTileEntity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    public final Block getBlock(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? Blocks.field_150350_a : this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    @Override
    public final byte getMetaID(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? (byte)0 : (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    public final byte getLightLevel(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? (byte)0 : (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    public final boolean getSky(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? true : this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    public final boolean getOpacity(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? false : GT_Utility.isOpaqueBlock((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    public final boolean getAir(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? true : GT_Utility.isBlockAir((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? null : this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    public final TileEntity getTileEntityAtSide(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        if (side != ForgeDirection.UNKNOWN && this.mBufferedTileEntities[ordinalSide] != this) {
            int tX = this.getOffsetX(side, 1);
            short tY = this.getOffsetY(side, 1);
            int tZ = this.getOffsetZ(side, 1);
            if (this.crossedChunkBorder(tX, tZ)) {
                this.mBufferedTileEntities[ordinalSide] = null;
                if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                    return null;
                }
            }
            if (this.mBufferedTileEntities[ordinalSide] == null) {
                this.mBufferedTileEntities[ordinalSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
                if (this.mBufferedTileEntities[ordinalSide] == null) {
                    this.mBufferedTileEntities[ordinalSide] = this;
                    return null;
                }
                return this.mBufferedTileEntities[ordinalSide];
            }
            if (this.mBufferedTileEntities[ordinalSide].func_145837_r()) {
                this.mBufferedTileEntities[ordinalSide] = null;
                return this.getTileEntityAtSide(side);
            }
            return this.mBufferedTileEntities[ordinalSide].field_145851_c == tX && this.mBufferedTileEntities[ordinalSide].field_145848_d == tY && this.mBufferedTileEntities[ordinalSide].field_145849_e == tZ ? this.mBufferedTileEntities[ordinalSide] : null;
        }
        return null;
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    public final void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, (GT_Packet)new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    public final void setOnFire() {
        GT_Utility.setCoordsOnFire((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (boolean)false);
    }

    public final void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    public byte getInternalInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.getCoverBehaviorAtSide(side).getRedstoneInput(side, this.getInputRedstoneSignal(side), this.getCoverIDAtSide(side), this.getCoverDataAtSide(side), (ICoverable)this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(side, 1), (int)this.getOffsetY(side, 1), this.getOffsetZ(side, 1), side.ordinal()) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(ForgeDirection side) {
        return this.getCoverBehaviorAtSide(side).manipulatesSidedRedstoneOutput(side, this.getCoverIDAtSide(side), this.getCoverDataAtSide(side), (ICoverable)this) ? this.mSidedRedstone[side.ordinal()] : this.getGeneralRS(side);
    }

    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    public byte getGeneralRS(ForgeDirection side) {
        return this.allowGeneralRedstoneOutput() ? this.mSidedRedstone[side.ordinal()] : (byte)0;
    }

    public void setInternalOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        if (!this.getCoverBehaviorAtSide(side).manipulatesSidedRedstoneOutput(side, this.getCoverIDAtSide(side), this.getCoverDataAtSide(side), (ICoverable)this)) {
            this.setOutputRedstoneSignal(side, aStrength);
        }
    }

    @Override
    public void setOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (side != ForgeDirection.UNKNOWN && this.mSidedRedstone[side.ordinal()] != aStrength) {
            this.mSidedRedstone[side.ordinal()] = aStrength;
            this.issueBlockUpdate();
        }
    }

    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    public GT_CoverBehavior getCoverBehaviorAtSide(ForgeDirection side) {
        return side != ForgeDirection.UNKNOWN ? this.mCoverBehaviors[side.ordinal()] : GregTech_API.sNoBehavior;
    }

    public void setCoverIDAtSide(ForgeDirection side, int aID) {
        if (this.setCoverIDAtSideNoUpdate(side, aID)) {
            this.issueCoverUpdate(side);
            this.issueBlockUpdate();
        }
    }

    public boolean setCoverIDAtSideNoUpdate(ForgeDirection side, int aID) {
        if (side != ForgeDirection.UNKNOWN) {
            int ordinalSide = side.ordinal();
            this.mCoverSides[ordinalSide] = aID;
            this.mCoverData[ordinalSide] = 0;
            this.mCoverBehaviors[ordinalSide] = (GT_CoverBehavior)GregTech_API.getCoverBehaviorNew((int)aID);
            return true;
        }
        return false;
    }

    public void setCoverIdAndDataAtSide(ForgeDirection side, int aId, ISerializableObject aData) {
        this.setCoverIDAtSide(side, aId);
        this.setCoverDataAtSide(side, aData);
    }

    public void setCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        GregTech_API.getCoverBehaviorNew((ItemStack)aCover).placeCover(side, aCover, (ICoverable)this);
    }

    public int getCoverIDAtSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            return this.mCoverSides[side.ordinal()];
        }
        return 0;
    }

    public ItemStack getCoverItemAtSide(ForgeDirection side) {
        return GT_Utility.intToStack((int)this.getCoverIDAtSide(side));
    }

    public boolean canPlaceCoverIDAtSide(ForgeDirection side, int aID) {
        return this.getCoverIDAtSide(side) == 0;
    }

    public boolean canPlaceCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        return this.getCoverIDAtSide(side) == 0;
    }

    public void setCoverDataAtSide(ForgeDirection side, int aData) {
        if (side != ForgeDirection.UNKNOWN) {
            this.mCoverData[side.ordinal()] = aData;
        }
    }

    public int getCoverDataAtSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            return this.mCoverData[side.ordinal()];
        }
        return 0;
    }

    public byte getLightValue() {
        return this.mLightValue;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    public long getAverageElectricInput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (this.mAverageEUInput.length - 1);
    }

    public long getAverageElectricOutput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (this.mAverageEUOutput.length - 1);
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return false;
    }

    public boolean dropCover(ForgeDirection side, ForgeDirection droppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSide(side).onCoverRemoval(side, this.getCoverIDAtSide(side), this.mCoverData[side.ordinal()], (ICoverable)this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSide(side).getDrop(side, this.getCoverIDAtSide(side), this.getCoverDataAtSide(side), (ICoverable)this);
            if (tStack != null) {
                tStack.func_77982_d(null);
                EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(droppedSide, 1) + 0.5, (double)this.getOffsetY(droppedSide, 1) + 0.5, (double)this.getOffsetZ(droppedSide, 1) + 0.5, tStack);
                tEntity.field_70159_w = 0.0;
                tEntity.field_70181_x = 0.0;
                tEntity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)tEntity);
            }
            this.setCoverIDAtSide(side, 0);
            if (this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                this.setOutputRedstoneSignal(side, (byte)0);
            } else {
                this.setOutputRedstoneSignal(side, (byte)15);
            }
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        if (GT_Utility.isStringInvalid((Object)this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid((Object)aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(side) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        return side != ForgeDirection.UNKNOWN && (this.mStrongRedstone & 1 << ordinalSide) != 0 ? (byte)(this.mSidedRedstone[ordinalSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << side.ordinal());
        this.setOutputRedstoneSignal(side, aStrength);
    }

    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(side) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = (int)((long)this.mAverageEUInput[n] + aVoltage * aAmperage);
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(side) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = (int)((long)this.mAverageEUOutput[n] + aVoltage * aAmperage);
            return true;
        }
        return false;
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.oOutput;
    }

    public boolean isTeleporterCompatible(ForgeDirection side) {
        return false;
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits(aDirection, (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom(aDirection);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo(aDirection);
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= this.oOutput ? (double)Math.max(0L, this.oOutput) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (int)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits(aForgeDirection, aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, this.oOutput);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits(aDirection.toForgeDirection(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return this.inputEnergyFrom(aDirection.toForgeDirection());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return this.outputsEnergyTo(aDirection.toForgeDirection());
    }

    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid((ItemStack)aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GT_Utility.isStackInvalid((ItemStack)tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)tStack, (ItemStack)(aStack = GT_OreDictUnificator.get((ItemStack)aStack))) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount((int)aAmount, (ItemStack)aStack));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GT_Mod arg9999 = GT_Mod.instance;
            GT_Mod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "electricproblems");
        }
    }

    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTech_API.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork((long)GT_Values.V[5], (long)Math.max(1L, this.getStoredEU() / GT_Values.V[5]), (IEnergyConnected)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.onExplosion();
            PollutionUtils.addPollution((IHasWorldObjectAndCoords)this, 100000);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void onExplosion() {
    }

    public String[] getDescription() {
        return this.canAccessData() ? this.mMetaTileEntity.getDescription() : new String[]{};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return null;
    }

    public long getEUVar() {
        return this.mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        this.mStoredEnergy = aEnergy;
    }

    public long getStoredEU() {
        return this.canAccessData() ? Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity()) : 0L;
    }

    public long getEUCapacity() {
        return this.canAccessData() ? this.mMetaTileEntity.maxEUStore() : 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy < 0L && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
        if (this.mMetaTileEntity.getEUVar() < 0L) {
            this.setStoredEU(0L);
            return false;
        }
        return true;
    }

    public boolean energyStateReady() {
        return false;
    }

    public boolean onFirstTick() {
        if (!this.firstTicked) {
            this.firstTicked = true;
            if (this.mInventory != null) {
                this.mInventory.purgeNulls();
                return true;
            }
        }
        return false;
    }

    public boolean inputEnergyFrom(byte arg0, boolean arg1) {
        return false;
    }

    public boolean outputsEnergyTo(byte arg0, boolean arg1) {
        return false;
    }
}

