/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaPipeEntity_Cable
extends GT_MetaPipeEntity_Cable
implements IMetaTileEntityCable {
    private static Textures.BlockIcons INSULATION_MEDIUM_PLUS;
    private short[] vRGB = null;

    public GregtechMetaPipeEntity_Cable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock, short[] aRGB) {
        super(aID, aName, aNameRegional, aThickNess, aMaterial, aCableLossPerMeter, aAmperage, aVoltage, aInsulated, aCanShock);
        this.vRGB = aRGB == null || aRGB.length != 4 ? Materials.Iron.mRGBa : aRGB;
    }

    public GregtechMetaPipeEntity_Cable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock, short[] aRGB) {
        super(aName, aThickNess, aMaterial, aCableLossPerMeter, aAmperage, aVoltage, aInsulated, aCanShock);
        this.vRGB = aRGB == null || aRGB.length != 4 ? Materials.Iron.mRGBa : aRGB;
    }

    public GregtechMetaPipeEntity_Cable(int aID, String aName, String aNameRegional, float aThickNess, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock, short[] aRGB) {
        this(aID, aName, aNameRegional, aThickNess, null, aCableLossPerMeter, aAmperage, aVoltage, aInsulated, aCanShock, aRGB);
    }

    public GregtechMetaPipeEntity_Cable(String aName, float aThickNess, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock, short[] aRGB) {
        this(aName, aThickNess, null, aCableLossPerMeter, aAmperage, aVoltage, aInsulated, aCanShock, aRGB);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaPipeEntity_Cable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock, this.vRGB);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        return this.getTextureGTNH(aBaseMetaTileEntity, side, aConnections, aColorIndex, aConnected, aRedstone);
    }

    private ITexture[] getTextureGTNH(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection aSide, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        Materials wireMaterial = this.mMaterial;
        if (wireMaterial == null) {
            wireMaterial = Materials.Iron;
        }
        if (!this.mInsulated) {
            return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], Dyes.getModulation((int)aColorIndex, (short[])this.vRGB))};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)INSULATION_MEDIUM_PLUS, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(wireMaterial.mIconSet.mTextures[69], this.vRGB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
    }

    static {
        try {
            INSULATION_MEDIUM_PLUS = (Textures.BlockIcons)GT_Utility.getField(Textures.BlockIcons.class, (String)"INSULATION_MEDIUM_PLUS").get(null);
        }
        catch (IllegalAccessException | NullPointerException e) {
            throw new Error(e);
        }
    }
}

