/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_Refinery
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Refinery>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_Refinery> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_Refinery(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Refinery(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Fuel Refinery";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Fission Fuel Processing Unit").addInfo("Refines fluorides and Uranium into nuclear fuel for the LFTR").addInfo("LFTR Fuel 2 and Fuel 3 have alternative, much more efficient recipes").addInfo("However, they require fission breeding outputs from the LFTR itself").addInfo("Only one Energy Hatch is allowed per Processing Unit").addInfo("All recipe times in this multi are very long, watch out!").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 9, 3, false).addController("Bottom Center").addCasingInfoMin("Hastelloy-X Structural Block", 7, false).addCasingInfoMin("Incoloy-DS Fluid Containment Block", 5, false).addCasingInfoMin("Zeron-100 Reactor Shielding", 4, false).addCasingInfoMin("Hastelloy-N Sealant Blocks", 17, false).addInputHatch("Base platform", new int[]{1}).addOutputHatch("Base platform", new int[]{1}).addMufflerHatch("Base platform", new int[]{1}).addMaintenanceHatch("Base platform", new int[]{1}).addEnergyHatch("Base platform", new int[]{1}).addStructureInfo("Muffler's Tier must be IV+").addStructureInfo("2-4x Input Hatches, 1-2x Output Hatches").addStructureInfo("1x Muffler, 1x Maintenance Hatch, 1x Energy Hatch").toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(18);
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.fissionFuelProcessingRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler && ((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity).mTier >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public IStructureDefinition<GregtechMetaTileEntity_Refinery> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"   ", " N ", "   "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" Z ", "ZIZ", " Z "}, {" N ", "NIN", " N "}, {"XXX", "XXX", "XXX"}, {"X~X", "XXX", "XXX"}})).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Refinery.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch}).casingIndex(TAE.GTPP_INDEX(18)).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Refinery.class).atLeast(new IHatchElement[]{GT_HatchElement.Muffler}).adder(GregtechMetaTileEntity_Refinery::addMufflerToMachineList).hatchItemFilterAnd(t -> GT_StructureUtility.filterByMTETier((int)6, (int)Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(18)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)2))})).addElement('I', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)3)).addElement('N', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)1)).addElement('Z', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)13)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 7, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 7, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 1, 7, 0) && this.mCasing >= 7 && this.mInputHatches.size() >= 2 && this.mInputHatches.size() <= 4 && this.mOutputHatches.size() >= 1 && this.mOutputHatches.size() <= 2 && this.mMufflerHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 1) {
            this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
            return true;
        }
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiRefinery;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Refinery(this.mName);
    }
}

