/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.interfaces.internal.Interface_OreRecipeRegistrator;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import net.minecraft.item.ItemStack;

public class ProcessingElectricSnips
implements Interface_OreRecipeRegistrator,
Runnable {
    public ProcessingElectricSnips() {
        GregtechOrePrefixes.toolElectricSnips.add(this);
    }

    @Override
    public void registerOre(GregtechOrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial == Materials.Stone || aMaterial == Materials.Flint || aMaterial == Materials.Rubber || aMaterial.contains(SubTag.WOOD) || aMaterial.contains(SubTag.BOUNCY) || !aMaterial.contains(SubTag.NO_SMASHING)) {
            // empty if block
        }
    }

    @Override
    public void registerOre(GregtechOrePrefixes aPrefix, GregtechOrePrefixes.GT_Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
    }

    public void materialsLoops() {
        Materials[] i = Materials.values();
        int size = i.length;
        Logger.MATERIALS("Materials to attempt tool gen. with: " + size);
        int used = 0;
        Materials aMaterial = null;
        for (Materials materials : i) {
            aMaterial = materials;
            if (aMaterial != Materials.Stone && aMaterial != Materials.Flint && aMaterial != Materials.Rubber && aMaterial != Materials._NULL) {
                if (!(aMaterial.contains(SubTag.WOOD) || aMaterial.contains(SubTag.BOUNCY) || aMaterial.contains(SubTag.NO_SMASHING) || aMaterial.contains(SubTag.TRANSPARENT) || aMaterial.contains(SubTag.FLAMMABLE) || aMaterial.contains(SubTag.MAGICAL) || aMaterial.contains(SubTag.NO_SMELTING))) {
                    Logger.MATERIALS("Generating Electric Snips from " + MaterialUtils.getMaterialName(aMaterial));
                    ItemStack plate = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)aMaterial, (long)1L);
                    if (null != plate) {
                        this.addRecipe(aMaterial, 1600000L, 3, ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0]));
                        this.addRecipe(aMaterial, 1200000L, 3, ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0]));
                        this.addRecipe(aMaterial, 800000L, 3, ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0]));
                        ++used;
                        continue;
                    }
                    Logger.MATERIALS("Unable to generate Electric Snips from " + MaterialUtils.getMaterialName(aMaterial) + ", Plate or Long Rod may be invalid. Invalid | Plate? " + (plate == null) + " | Rod?  |");
                    continue;
                }
                Logger.MATERIALS("Unable to generate Electric Snips from " + MaterialUtils.getMaterialName(aMaterial));
                continue;
            }
            Logger.MATERIALS("Unable to generate Electric Snips from " + MaterialUtils.getMaterialName(aMaterial));
        }
        Logger.INFO("Materials used for tool gen: " + used);
    }

    @Override
    public void run() {
        Logger.INFO("Generating Electric Snips for all valid GT Materials.");
        this.materialsLoops();
    }

    public boolean addRecipe(Materials aMaterial, long aBatteryStorage, int aVoltageTier, ItemStack aBattery) {
        ItemStack aOutputStack = MetaGeneratedGregtechTools.INSTANCE.getToolWithStats(7934, 1, aMaterial, Materials.Titanium, new long[]{aBatteryStorage, GT_Values.V[aVoltageTier], 3L, -1L});
        ItemStack aInputCutter = GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(26, 1, aMaterial, aMaterial, null);
        long aDura = MetaGeneratedGregtechTools.getToolMaxDamage((ItemStack)aOutputStack);
        if (aDura <= 32000L) {
            Logger.MATERIALS("Unable to generate Electric Snips from " + MaterialUtils.getMaterialName(aMaterial) + ", Durability: " + aDura);
            return false;
        }
        return RecipeUtils.addShapedRecipe(OrePrefixes.wireFine.get((Object)Materials.Electrum), aInputCutter, OrePrefixes.wireFine.get((Object)Materials.Electrum), ELEMENT.STANDALONE.WHITE_METAL.getGear(1), CI.getElectricMotor(aVoltageTier, 1), ELEMENT.STANDALONE.WHITE_METAL.getGear(1), OrePrefixes.plate.get((Object)aMaterial), aBattery, OrePrefixes.plate.get((Object)aMaterial), aOutputStack);
    }
}

