/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import forestry.apiculture.blocks.BlockCandle;
import forestry.apiculture.tiles.TileCandle;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderCandleBlock
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block.func_149645_b() == Proxies.render.getCandleRenderId()) {
            RenderCandleBlock.renderBlockCandle(world, x, y, z, (BlockCandle)block);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return Proxies.render.getCandleRenderId();
    }

    private static boolean renderBlockCandle(IBlockAccess world, int x, int y, int z, BlockCandle block) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileCandle)) {
            return false;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        boolean isLit = tileCandle.isLit();
        IIcon iconA = block.getTextureFromPassAndLit(0, isLit);
        IIcon iconB = block.getTextureFromPassAndLit(1, isLit);
        int colour = tileCandle.getColour();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(world.func_72802_i(x, y, z, block.getLightValue(world, x, y, z)));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        double d0 = 0.4f;
        double d1 = 0.5 - d0;
        double d2 = 0.2f;
        if (meta == 1) {
            RenderCandleBlock.renderCandleAtAngle(iconA, (double)x - d1, (double)y + d2, z, -d0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, (double)x - d1, (double)y + d2, z, -d0, 0.0, colour);
        } else if (meta == 2) {
            RenderCandleBlock.renderCandleAtAngle(iconA, (double)x + d1, (double)y + d2, z, d0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, (double)x + d1, (double)y + d2, z, d0, 0.0, colour);
        } else if (meta == 3) {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, (double)y + d2, (double)z - d1, 0.0, -d0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, (double)y + d2, (double)z - d1, 0.0, -d0, colour);
        } else if (meta == 4) {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, (double)y + d2, (double)z + d1, 0.0, d0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, (double)y + d2, (double)z + d1, 0.0, d0, colour);
        } else {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, y, z, 0.0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, y, z, 0.0, 0.0, colour);
        }
        return true;
    }

    private static void renderCandleAtAngle(IIcon icon, double x, double y, double z, double par8, double par10, int colour) {
        Tessellator tessellator = Tessellator.field_78398_a;
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        double textureLightTopU = icon.func_94214_a(7.0);
        double d10 = icon.func_94207_b(6.0);
        double textureLightBottomU = icon.func_94214_a(9.0);
        double d12 = icon.func_94207_b(8.0);
        double d14 = icon.func_94207_b(13.0);
        double d16 = icon.func_94207_b(15.0);
        double d17 = (x += 0.5) - 0.5;
        double d18 = x + 0.5;
        double d19 = (z += 0.5) - 0.5;
        double d20 = z + 0.5;
        double d21 = 0.0625;
        double d22 = 0.625;
        tessellator.func_78378_d(colour);
        tessellator.func_78374_a(x + par8 * (1.0 - d22) - d21, y + d22, z + par10 * (1.0 - d22) - d21, textureLightTopU, d10);
        tessellator.func_78374_a(x + par8 * (1.0 - d22) - d21, y + d22, z + par10 * (1.0 - d22) + d21, textureLightTopU, d12);
        tessellator.func_78374_a(x + par8 * (1.0 - d22) + d21, y + d22, z + par10 * (1.0 - d22) + d21, textureLightBottomU, d12);
        tessellator.func_78374_a(x + par8 * (1.0 - d22) + d21, y + d22, z + par10 * (1.0 - d22) - d21, textureLightBottomU, d10);
        tessellator.func_78374_a(x - d21, y + 1.0, d19, minU, minV);
        tessellator.func_78374_a(x - d21 + par8, y, d19 + par10, minU, maxV);
        tessellator.func_78374_a(x - d21 + par8, y, d20 + par10, maxU, maxV);
        tessellator.func_78374_a(x - d21, y + 1.0, d20, maxU, minV);
        tessellator.func_78374_a(x + d21, y + 1.0, d20, minU, minV);
        tessellator.func_78374_a(x + par8 + d21, y, d20 + par10, minU, maxV);
        tessellator.func_78374_a(x + par8 + d21, y, d19 + par10, maxU, maxV);
        tessellator.func_78374_a(x + d21, y + 1.0, d19, maxU, minV);
        tessellator.func_78374_a(d18, y + 1.0, z - d21, minU, minV);
        tessellator.func_78374_a(d18 + par8, y, z - d21 + par10, minU, maxV);
        tessellator.func_78374_a(d17 + par8, y, z - d21 + par10, maxU, maxV);
        tessellator.func_78374_a(d17, y + 1.0, z - d21, maxU, minV);
        tessellator.func_78374_a(d17, y + 1.0, z + d21, minU, minV);
        tessellator.func_78374_a(d17 + par8, y, z + d21 + par10, minU, maxV);
        tessellator.func_78374_a(d18 + par8, y, z + d21 + par10, maxU, maxV);
        tessellator.func_78374_a(d18, y + 1.0, z + d21, maxU, minV);
        tessellator.func_78374_a(x + d21 + par8, y, z - d21 + par10, textureLightBottomU, d14);
        tessellator.func_78374_a(x + d21 + par8, y, z + d21 + par10, textureLightBottomU, d16);
        tessellator.func_78374_a(x - d21 + par8, y, z + d21 + par10, textureLightTopU, d16);
        tessellator.func_78374_a(x - d21 + par8, y, z - d21 + par10, textureLightTopU, d14);
    }
}

