/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.blocks;

import forestry.core.blocks.IMachinePropertiesTESR;
import forestry.core.proxy.Proxies;
import forestry.core.render.IBlockRenderer;
import forestry.core.tiles.TileForestry;
import forestry.factory.tiles.TileBottler;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileCentrifuge;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMillRainmaker;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileSqueezer;
import forestry.factory.tiles.TileStill;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum BlockFactoryTesrType implements IMachinePropertiesTESR
{
    BOTTLER(TileBottler.class),
    CARPENTER(TileCarpenter.class),
    CENTRIFUGE(TileCentrifuge.class),
    FERMENTER(TileFermenter.class),
    MOISTENER(TileMoistener.class),
    SQUEEZER(TileSqueezer.class),
    STILL(TileStill.class),
    RAINMAKER(TileMillRainmaker.class){

        @Override
        public IBlockRenderer getRenderer() {
            return Proxies.render.getRenderMill("textures/blocks/rainmaker_");
        }
    };

    public static final BlockFactoryTesrType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;
    private final String name;

    private BlockFactoryTesrType(Class<? extends TileForestry> teClass) {
        String name = this.toString().toLowerCase(Locale.ENGLISH);
        this.teIdent = "forestry." + WordUtils.capitalize((String)name);
        this.teClass = teClass;
        this.name = name;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    @Override
    public IBlockRenderer getRenderer() {
        return Proxies.render.getRenderDefaultMachine("textures/blocks/" + this.name + "_");
    }

    static {
        VALUES = BlockFactoryTesrType.values();
    }
}

