/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.order.IDistanceTracker;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemRoutingInformation {
    public int destinationint = -1;
    public UUID destinationUUID;
    public boolean arrived;
    public int bufferCounter = 0;
    public boolean _doNotBuffer;
    public IRoutedItem.TransportMode _transportMode = IRoutedItem.TransportMode.Unknown;
    public List<Integer> jamlist = new ArrayList<Integer>();
    public IDistanceTracker tracker = null;
    public IAdditionalTargetInformation targetInfo;
    private long delay = 640 + MainProxy.getGlobalTick();
    private ItemIdentifierStack item;

    public ItemRoutingInformation clone() {
        ItemRoutingInformation that = new ItemRoutingInformation();
        that.destinationint = this.destinationint;
        that.destinationUUID = this.destinationUUID;
        that.arrived = this.arrived;
        that.bufferCounter = this.bufferCounter;
        that._doNotBuffer = this._doNotBuffer;
        that._transportMode = this._transportMode;
        that.jamlist = new ArrayList<Integer>(this.jamlist);
        that.tracker = this.tracker;
        that.targetInfo = this.targetInfo;
        that.item = this.getItem().clone();
        return that;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("destinationUUID")) {
            this.destinationUUID = UUID.fromString(nbttagcompound.func_74779_i("destinationUUID"));
        }
        this.arrived = nbttagcompound.func_74767_n("arrived");
        this.bufferCounter = nbttagcompound.func_74762_e("bufferCounter");
        this._transportMode = IRoutedItem.TransportMode.values()[nbttagcompound.func_74762_e("transportMode")];
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("Item"));
        if (stack != null) {
            this.setItem(ItemIdentifierStack.getFromStack(stack));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.destinationUUID != null) {
            nbttagcompound.func_74778_a("destinationUUID", this.destinationUUID.toString());
        }
        nbttagcompound.func_74757_a("arrived", this.arrived);
        nbttagcompound.func_74768_a("bufferCounter", this.bufferCounter);
        nbttagcompound.func_74768_a("transportMode", this._transportMode.ordinal());
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        this.getItem().makeNormalStack().func_77955_b(nbttagcompound2);
        nbttagcompound.func_74782_a("Item", (NBTBase)nbttagcompound2);
    }

    public long getTimeOut() {
        return this.delay;
    }

    public long getTickToTimeOut() {
        return this.delay - (long)MainProxy.getGlobalTick();
    }

    public void resetDelay() {
        this.delay = 640 + MainProxy.getGlobalTick();
        if (this.tracker != null) {
            this.tracker.setDelay(this.delay);
        }
    }

    public String toString() {
        return "(" + this.item + ", " + this.destinationint + ", " + this.destinationUUID + ", " + (Object)((Object)this._transportMode) + ", " + this.jamlist + ", " + this.delay + ", " + this.tracker;
    }

    public ItemIdentifierStack getItem() {
        return this.item;
    }

    public void setItem(ItemIdentifierStack item) {
        this.item = item;
    }

    public static class DelayComparator
    implements Comparator<ItemRoutingInformation> {
        @Override
        public int compare(ItemRoutingInformation o1, ItemRoutingInformation o2) {
            return (int)(o2.getTimeOut() - o1.getTimeOut());
        }
    }
}

