/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.configuration;

import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import lumien.custommainmenu.CustomMainMenu;
import lumien.custommainmenu.configuration.Config;
import lumien.custommainmenu.configuration.GuiConfig;
import lumien.custommainmenu.gui.GuiCustom;
import org.apache.commons.io.IOUtils;

public class ConfigurationLoader {
    Config config;

    public ConfigurationLoader(Config config) {
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    public void load() throws Exception {
        JsonObject jsonObject;
        JsonElement jsonElement;
        JsonReader reader;
        String name;
        GuiConfig guiConfig;
        File[] jsonFiles;
        File mainmenuConfig;
        JsonParser jsonParser = new JsonParser();
        File configFolder = new File(CustomMainMenu.INSTANCE.configFolder, "CustomMainMenu");
        if (!configFolder.exists()) {
            configFolder.mkdir();
        }
        if (!(mainmenuConfig = new File(configFolder, "mainmenu.json")).exists()) {
            void var10_6;
            InputStream inputStream = null;
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(mainmenuConfig);
                InputStream inputStream2 = this.getClass().getResourceAsStream("/assets/custommainmenu/mainmenu_default.json");
                ByteStreams.copy((InputStream)inputStream2, (OutputStream)output);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((InputStream)var10_6);
        }
        for (File guiFile : jsonFiles = configFolder.listFiles()) {
            if (!guiFile.getName().equals("mainmenu.json")) continue;
            guiConfig = new GuiConfig();
            name = guiFile.getName().replace(".json", "");
            reader = null;
            try {
                reader = new JsonReader((Reader)new FileReader(guiFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                jsonElement = jsonParser.parse(reader);
                jsonObject = jsonElement.getAsJsonObject();
                guiConfig.load(name, jsonObject);
            }
            catch (Exception e) {
                try {
                    reader.close();
                    throw e;
                }
                catch (IOException io) {
                    io.printStackTrace();
                    throw e;
                }
            }
            try {
                reader.close();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            this.config.addGui(guiConfig.name, new GuiCustom(guiConfig));
        }
        for (File guiFile : jsonFiles) {
            if (guiFile.getName().equals("mainmenu.json") || !guiFile.getName().endsWith(".json")) continue;
            guiConfig = new GuiConfig();
            name = guiFile.getName().replace(".json", "");
            reader = null;
            try {
                reader = new JsonReader((Reader)new FileReader(guiFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                jsonElement = jsonParser.parse(reader);
                jsonObject = jsonElement.getAsJsonObject();
                guiConfig.load(name, jsonObject);
            }
            catch (Exception e) {
                try {
                    reader.close();
                    throw e;
                }
                catch (IOException io) {
                    io.printStackTrace();
                    throw e;
                }
            }
            try {
                reader.close();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            this.config.addGui(guiConfig.name, new GuiCustom(guiConfig));
        }
    }
}

