/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import team.chisel.block.tileentity.TileEntityPresent;
import team.chisel.network.message.base.MessageCoords;

public class MessagePresentConnect
extends MessageCoords {
    private ForgeDirection dir;
    private boolean connect;
    private boolean preserveDir;

    public MessagePresentConnect() {
    }

    public MessagePresentConnect(TileEntityPresent present, ForgeDirection dir, boolean connecting) {
        this(present, dir, connecting, false);
    }

    public MessagePresentConnect(TileEntityPresent present, ForgeDirection dir, boolean connecting, boolean preserveDir) {
        super(present);
        this.dir = dir;
        this.connect = connecting;
        this.preserveDir = preserveDir;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.dir.ordinal());
        buf.writeBoolean(this.connect);
        buf.writeBoolean(this.preserveDir);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readInt()];
        this.connect = buf.readBoolean();
        this.preserveDir = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<MessagePresentConnect, IMessage> {
        public IMessage onMessage(MessagePresentConnect message, MessageContext ctx) {
            TileEntity te = message.getTileEntity(ctx);
            if (te instanceof TileEntityPresent) {
                if (message.connect) {
                    ((TileEntityPresent)te).connectTo(message.dir);
                } else {
                    ((TileEntityPresent)te).disconnect(message.preserveDir);
                }
            }
            return null;
        }
    }
}

