/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.tracking;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.AmountHolder;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionAmountEntities;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelAmountEntities
extends JPanelMsgHandler
implements ITabPanel {
    private JCheckBox chckbxFilter;
    private JButtonAccess btnKillAll;
    private JButtonAccess btnRefresh;
    private JLabel lblSummary;

    public PanelAmountEntities() {
        this.setLayout(new MigLayout("", "[][][grow][]", "[][grow][]"));
        this.chckbxFilter = new JCheckBox("Filter Entities");
        this.add((Component)this.chckbxFilter, "cell 0 0");
        this.chckbxFilter.addItemListener(new ActionAmountEntities());
        this.btnKillAll = new JButtonAccess("Kill All", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnKillAll, "cell 1 0");
        this.btnKillAll.addActionListener(new ActionAmountEntities());
        this.btnRefresh = new JButtonAccess("Refresh", AccessLevel.NONE);
        this.add((Component)this.btnRefresh, "cell 3 0");
        this.btnRefresh.addActionListener(new ActionAmountEntities());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 4 1,grow");
        this.table = new JTableStats(new String[]{"Type", "Amount"}, new Class[]{String.class, Integer.class});
        scrollPane.setViewportView(this.table);
        this.lblSummary = new JLabel("New label");
        this.add((Component)this.lblSummary, "cell 0 2 4 1,alignx center");
    }

    public JCheckBox getChckbxFilter() {
        return this.chckbxFilter;
    }

    public JButton getBtnKillAll() {
        return this.btnKillAll;
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    public JLabel getLblSummary() {
        return this.lblSummary;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_AMOUNT_ENTITIES: {
                this.cacheData(msg, rawdata);
                SwingUtilities.invokeLater(() -> {
                    this.getTable().setTableData(rawdata.array);
                    DefaultTableModel model = this.getTable().getModel();
                    int row = this.getTable().clearTable(AmountHolder.class);
                    int totalEntities = 0;
                    for (ISerializable o : rawdata.array) {
                        AmountHolder entity = (AmountHolder)o;
                        model.addRow(new Object[]{entity.key, entity.value});
                        totalEntities += entity.value.intValue();
                    }
                    this.getLblSummary().setText("Total : " + String.valueOf(totalEntities));
                    this.getTable().dataUpdated(row);
                });
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.AMOUNTENTS;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

