/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.network.ParticleGenPacket;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIParticleGenerator
extends GuiScreen {
    private final int xSize = 212;
    private final int ySize = 198;
    private final ResourceLocation guiTexture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/ParticleGenerator.png");
    private int page = 1;
    private int infoPage = 0;
    private boolean canParticleCollide = false;
    private int selectedParticle = 1;
    private boolean isParticlesEnabled = true;
    private boolean isBeamEnabled = false;
    private boolean shouldRenderCore = false;
    private final TileParticleGenerator particleGenerator;
    private final Map<Integer, IProperty> properties;
    private GuiButton previousPage;
    private GuiButton nextPage;
    private GuiButton previousInfoPage;
    private GuiButton nextInfoPage;
    private GuiButton showInfo;
    private GuiButton hideInfo;
    private GuiButton collisionToggle;
    private GuiButton particleToggle;
    private GuiButton particleSelector;
    private GuiButton beamToggle;
    private GuiButton coreRenderToggle;
    private GuiButton settingsSaver;
    private static final String[] infoText = new String[]{StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.1")), StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.2")), StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.3")), StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.4")), EnumChatFormatting.DARK_RED + StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.5.title")) + EnumChatFormatting.BLACK + StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.5")), EnumChatFormatting.DARK_RED + StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.6.title")) + EnumChatFormatting.BLACK + StringEscapeUtils.unescapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.6")), StringEscapeUtils.escapeJava((String)StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.7"))};

    public GUIParticleGenerator(TileParticleGenerator particleGenerator) {
        this.particleGenerator = particleGenerator;
        this.properties = new HashMap<Integer, IProperty>();
        this.syncWithServer();
        this.func_73876_c();
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        int row;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        int posX = (this.field_146294_l - 212) / 2;
        int posY = (this.field_146295_m - 198) / 2;
        this.func_73729_b(posX, posY, 0, 0, 212, 198);
        if (this.page == 1) {
            this.field_146289_q.func_78261_a(StatCollector.func_74838_a((String)"gui.de.particleGenerator.main.title"), posX + 60, posY + 5, 65535);
            for (int column = 0; column < 2; ++column) {
                for (int row2 = 0; row2 < 8; ++row2) {
                    IProperty property = this.properties.get(row2 + column * 10);
                    property.drawLabel(this.field_146289_q, posX + 30 + column * 111, posY + 20 + row2 * 22);
                }
            }
            for (row = 0; row < 8; ++row) {
                this.field_146289_q.func_78261_a(" + ", posX + 98, posY + 25 + row * 22, 0xFFFFFF);
            }
        }
        if (this.page == 2) {
            this.field_146289_q.func_78261_a(StatCollector.func_74838_a((String)"gui.de.particleGenerator.main.title"), posX + 60, posY + 5, 65535);
            for (row = 0; row < 6; ++row) {
                IProperty property = this.properties.get(row + 20);
                property.drawLabel(this.field_146289_q, posX + 30, posY + 20 + row * 22);
            }
            for (row = 0; row < 3; ++row) {
                IProperty property = this.properties.get(row + 30);
                property.drawLabel(this.field_146289_q, posX + 141, posY + 20 + row * 22);
                this.field_146289_q.func_78261_a(" + ", posX + 98, posY + 25 + row * 22, 0xFFFFFF);
            }
        }
        if (this.page == 3) {
            this.field_146289_q.func_78261_a(StatCollector.func_74838_a((String)"gui.de.particleGenerator.beam.title"), posX + 65, posY + 5, 65535);
            for (row = 0; row < 8; ++row) {
                IProperty property = this.properties.get(row + 40);
                property.drawLabel(this.field_146289_q, posX + 30, posY + 20 + row * 22);
            }
        }
        if (this.page == 10) {
            this.field_146289_q.func_78261_a(StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.title"), posX + 75, posY + 5, 65535);
            this.field_146289_q.func_78279_b(infoText[this.infoPage], posX + 5, posY + 20, 200, 0);
            this.field_146289_q.func_78279_b(StatCollector.func_74837_a((String)"gui.de.particleGenerator.page.name", (Object[])new Object[]{this.infoPage + 1}), posX + 88, posY + 180, 200, 0xFF0000);
        }
        this.field_146289_q.func_78261_a(StatCollector.func_74838_a((String)"gui.de.particleGenerator.hold.name"), posX + 215, posY + 11, 0xFFFFFF);
        this.field_146289_q.func_78261_a("Shift: +-10", posX + 215, posY + 21, 0xFFFFFF);
        this.field_146289_q.func_78261_a("Ctrl: +-50", posX + 215, posY + 31, 0xFFFFFF);
        this.field_146289_q.func_78261_a("Shift+Ctrl: +-100", posX + 215, posY + 41, 0xFFFFFF);
        super.func_73863_a(x, y, partialTicks);
    }

    public void func_73866_w_() {
        int propertyId;
        int row;
        int posX = (this.field_146294_l - 212) / 2;
        int posY = (this.field_146295_m - 198) / 2;
        this.field_146292_n.clear();
        this.previousPage = new GuiButton(100, posX - 20, posY + 177, 20, 20, "<");
        this.field_146292_n.add(this.previousPage);
        this.nextPage = new GuiButton(101, posX + 213, posY + 177, 20, 20, ">");
        this.field_146292_n.add(this.nextPage);
        this.showInfo = new GuiButton(102, posX - 21, posY + 3, 20, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.info.name"));
        this.field_146292_n.add(this.showInfo);
        this.hideInfo = new GuiButton(103, posX - 31, posY + 23, 30, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.back.name"));
        this.field_146292_n.add(this.hideInfo);
        this.previousInfoPage = new GuiButton(104, posX + 4, posY + 174, 30, 20, "<-");
        this.field_146292_n.add(this.previousInfoPage);
        this.nextInfoPage = new GuiButton(105, posX + 178, posY + 174, 30, 20, "->");
        this.field_146292_n.add(this.nextInfoPage);
        for (int column = 0; column < 2; ++column) {
            for (int row2 = 0; row2 < 8; ++row2) {
                int propertyId2 = row2 + column * 10;
                IProperty property = this.properties.get(propertyId2);
                property.createButtons(this.field_146292_n, posX + 5 + column * 111, posY + 19 + row2 * 22, propertyId2);
            }
        }
        for (row = 0; row < 6; ++row) {
            propertyId = row + 20;
            IProperty property = this.properties.get(propertyId);
            property.createButtons(this.field_146292_n, posX + 5, posY + 19 + row * 22, propertyId);
        }
        for (row = 0; row < 3; ++row) {
            propertyId = row + 30;
            IProperty property = this.properties.get(propertyId);
            property.createButtons(this.field_146292_n, posX + 116, posY + 19 + row * 22, propertyId);
        }
        this.collisionToggle = new GuiButton(110, posX + 105, posY + 19 + 66, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.blockCollision.name"));
        this.field_146292_n.add(this.collisionToggle);
        this.particleSelector = new GuiButton(111, posX + 105, posY + 19 + 88, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.particleSelected.name"));
        this.field_146292_n.add(this.particleSelector);
        this.particleToggle = new GuiButton(112, posX + 105, posY + 19 + 110, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.enabled.name"));
        this.field_146292_n.add(this.particleToggle);
        for (row = 0; row < 8; ++row) {
            propertyId = row + 40;
            IProperty property = this.properties.get(propertyId);
            property.createButtons(this.field_146292_n, posX + 5, posY + 19 + row * 22, propertyId);
        }
        this.beamToggle = new GuiButton(120, posX + 105, posY + 19, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.enabled.name"));
        this.field_146292_n.add(this.beamToggle);
        this.coreRenderToggle = new GuiButton(121, posX + 105, posY + 41, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.renderCore.name"));
        this.field_146292_n.add(this.coreRenderToggle);
        this.settingsSaver = new GuiButton(127, posX + 105, posY + 19 + 154, 102, 20, StatCollector.func_74838_a((String)"gui.de.particleGenerator.saveSettings.name"));
        this.field_146292_n.add(this.settingsSaver);
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k < 100) {
            int propertyId = button.field_146127_k / 2;
            boolean shouldIncrease = button.field_146127_k % 2 == 0;
            this.modifyProperty(propertyId, shouldIncrease);
            return;
        }
        short packetData = 0;
        switch (button.field_146127_k) {
            case 100: {
                this.page = Math.max(this.page - 1, 1);
                packetData = (short)this.page;
                break;
            }
            case 101: {
                this.page = Math.min(this.page + 1, 3);
                packetData = (short)this.page;
                break;
            }
            case 102: {
                this.page = 10;
                packetData = (short)this.page;
                break;
            }
            case 103: {
                this.page = 1;
                packetData = (short)this.page;
                break;
            }
            case 104: {
                this.infoPage = Math.max(this.infoPage - 1, 0);
                break;
            }
            case 105: {
                this.infoPage = Math.min(this.infoPage + 1, infoText.length - 1);
                break;
            }
            case 110: {
                this.canParticleCollide = !this.canParticleCollide;
                packetData = (short)(this.canParticleCollide ? 1 : 0);
                break;
            }
            case 111: {
                this.selectedParticle = this.selectedParticle < 3 ? this.selectedParticle + 1 : 1;
                packetData = (short)this.selectedParticle;
                break;
            }
            case 112: {
                this.isParticlesEnabled = !this.isParticlesEnabled;
                packetData = (short)(this.isParticlesEnabled ? 1 : 0);
                break;
            }
            case 120: {
                this.isBeamEnabled = !this.isBeamEnabled;
                packetData = (short)(this.isBeamEnabled ? 1 : 0);
                break;
            }
            case 121: {
                this.shouldRenderCore = !this.shouldRenderCore;
                packetData = (short)(this.shouldRenderCore ? 1 : 0);
            }
        }
        this.updateButtons();
        DraconicEvolution.network.sendToServer((IMessage)new ParticleGenPacket((byte)button.field_146127_k, packetData, this.particleGenerator.field_145851_c, this.particleGenerator.field_145848_d, this.particleGenerator.field_145849_e));
    }

    private void modifyProperty(int propertyId, boolean shouldIncrease) {
        boolean isShiftPressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean isControlPressed = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        int amount = 1;
        if (isShiftPressed) {
            amount = 10;
        }
        if (isControlPressed) {
            amount = 50;
        }
        if (isShiftPressed && isControlPressed) {
            amount = 100;
        }
        IProperty property = this.properties.get(propertyId);
        if (shouldIncrease) {
            property.increaseValue(amount);
        } else {
            property.decreaseValue(amount);
        }
        DraconicEvolution.network.sendToServer((IMessage)new ParticleGenPacket((byte)propertyId, property.getSyncValue(), this.particleGenerator.field_145851_c, this.particleGenerator.field_145848_d, this.particleGenerator.field_145849_e));
    }

    public boolean func_73868_f() {
        return false;
    }

    private void syncWithServer() {
        this.properties.put(0, new IntegerProperty(1, "red.name", this.particleGenerator.red, 0, 255));
        this.properties.put(1, new IntegerProperty(1, "green.name", this.particleGenerator.green, 0, 255));
        this.properties.put(2, new IntegerProperty(1, "blue.name", this.particleGenerator.blue, 0, 255));
        this.properties.put(3, new FloatProperty(1, "motionX.name", this.particleGenerator.motionX, -5.0f, 5.0f, 1000.0f));
        this.properties.put(4, new FloatProperty(1, "motionY.name", this.particleGenerator.motionY, -5.0f, 5.0f, 1000.0f));
        this.properties.put(5, new FloatProperty(1, "motionZ.name", this.particleGenerator.motionZ, -5.0f, 5.0f, 1000.0f));
        this.properties.put(6, new FloatProperty(1, "scale.name", this.particleGenerator.scale, 0.01f, 50.0f, 100.0f));
        this.properties.put(7, new IntegerProperty(1, "life.name", this.particleGenerator.life, 0, 1000));
        this.properties.put(10, new IntegerProperty(1, "random.name", this.particleGenerator.randomRed, 0, 255));
        this.properties.put(11, new IntegerProperty(1, "random.name", this.particleGenerator.randomGreen, 0, 255));
        this.properties.put(12, new IntegerProperty(1, "random.name", this.particleGenerator.randomBlue, 0, 255));
        this.properties.put(13, new FloatProperty(1, "random.name", this.particleGenerator.randomMotionX, -5.0f, 5.0f, 1000.0f));
        this.properties.put(14, new FloatProperty(1, "random.name", this.particleGenerator.randomMotionY, -5.0f, 5.0f, 1000.0f));
        this.properties.put(15, new FloatProperty(1, "random.name", this.particleGenerator.randomMotionZ, -5.0f, 5.0f, 1000.0f));
        this.properties.put(16, new FloatProperty(1, "random.name", this.particleGenerator.randomScale, 0.0f, 50.0f, 100.0f));
        this.properties.put(17, new IntegerProperty(1, "random.name", this.particleGenerator.randomLife, 0, 1000));
        this.properties.put(20, new FloatProperty(2, "spawnX.name", this.particleGenerator.spawnX, -50.0f, 50.0f, 10.0f));
        this.properties.put(21, new FloatProperty(2, "spawnY.name", this.particleGenerator.spawnY, -50.0f, 50.0f, 10.0f));
        this.properties.put(22, new FloatProperty(2, "spawnZ.name", this.particleGenerator.spawnZ, -50.0f, 50.0f, 10.0f));
        this.properties.put(23, new IntegerProperty(2, "delay.name", this.particleGenerator.spawnRate, 1, 200));
        this.properties.put(24, new IntegerProperty(2, "fade.name", this.particleGenerator.fade, 0, 100));
        this.properties.put(25, new FloatProperty(2, "gravity.name", this.particleGenerator.gravity, -5.0f, 5.0f, 1000.0f));
        this.properties.put(30, new FloatProperty(2, "random.name", this.particleGenerator.randomSpawnX, -50.0f, 50.0f, 10.0f));
        this.properties.put(31, new FloatProperty(2, "random.name", this.particleGenerator.randomSpawnY, -50.0f, 50.0f, 10.0f));
        this.properties.put(32, new FloatProperty(2, "random.name", this.particleGenerator.randomSpawnZ, -50.0f, 50.0f, 10.0f));
        this.page = this.particleGenerator.page;
        this.canParticleCollide = this.particleGenerator.canParticleCollide;
        this.selectedParticle = this.particleGenerator.selectedParticle;
        this.isParticlesEnabled = this.particleGenerator.isParticlesEnabled;
        this.properties.put(40, new IntegerProperty(3, "red.name", this.particleGenerator.beamRed, 0, 255));
        this.properties.put(41, new IntegerProperty(3, "green.name", this.particleGenerator.beamGreen, 0, 255));
        this.properties.put(42, new IntegerProperty(3, "blue.name", this.particleGenerator.beamBlue, 0, 255));
        this.properties.put(43, new FloatProperty(3, "pitch.name", this.particleGenerator.beamPitch, -180.0f, 180.0f, 10.0f));
        this.properties.put(44, new FloatProperty(3, "yaw.name", this.particleGenerator.beamYaw, -180.0f, 180.0f, 10.0f));
        this.properties.put(45, new FloatProperty(3, "rotation.name", this.particleGenerator.beamRotation, -1.0f, 1.0f, 100.0f));
        this.properties.put(46, new FloatProperty(3, "scale.name", this.particleGenerator.beamScale, 0.0f, 5.0f, 100.0f));
        this.properties.put(47, new FloatProperty(3, "length.name", this.particleGenerator.beamLength, 0.0f, 320.0f, 100.0f));
        this.shouldRenderCore = this.particleGenerator.shouldRenderCore;
        this.isBeamEnabled = this.particleGenerator.isBeamEnabled;
    }

    private void updateButtons() {
        for (IProperty property : this.properties.values()) {
            property.updateButtons(this.page);
        }
        this.previousPage.field_146125_m = this.page > 1 && this.page <= 3;
        boolean bl = this.nextPage.field_146125_m = this.page < 3;
        if (this.page == 10) {
            this.showInfo.field_146125_m = false;
            this.hideInfo.field_146125_m = true;
            this.previousInfoPage.field_146125_m = this.infoPage > 0;
            this.nextInfoPage.field_146125_m = this.infoPage < infoText.length - 1;
        } else {
            this.showInfo.field_146125_m = true;
            this.hideInfo.field_146125_m = false;
            this.previousInfoPage.field_146125_m = false;
            this.nextInfoPage.field_146125_m = false;
        }
        String onLabel = StatCollector.func_74838_a((String)"gui.de.on.txt");
        String offLabel = StatCollector.func_74838_a((String)"gui.de.off.txt");
        this.collisionToggle.field_146125_m = this.page == 2;
        this.collisionToggle.field_146126_j = StatCollector.func_74837_a((String)"gui.de.particleGenerator.blockCollision.name", (Object[])new Object[]{this.canParticleCollide ? onLabel : offLabel});
        this.particleSelector.field_146125_m = this.page == 2;
        this.particleSelector.field_146126_j = StatCollector.func_74837_a((String)"gui.de.particleGenerator.particleSelected.name", (Object[])new Object[]{this.selectedParticle});
        this.particleToggle.field_146125_m = this.page == 2;
        this.particleToggle.field_146126_j = StatCollector.func_74837_a((String)"gui.de.particleGenerator.enabled.name", (Object[])new Object[]{this.isParticlesEnabled ? onLabel : offLabel});
        this.beamToggle.field_146125_m = this.page == 3;
        this.beamToggle.field_146126_j = StatCollector.func_74837_a((String)"gui.de.particleGenerator.enabled.name", (Object[])new Object[]{this.isBeamEnabled ? onLabel : offLabel});
        this.coreRenderToggle.field_146125_m = this.page == 3;
        this.coreRenderToggle.field_146126_j = StatCollector.func_74837_a((String)"gui.de.particleGenerator.renderCore.name", (Object[])new Object[]{this.shouldRenderCore ? onLabel : offLabel});
        this.settingsSaver.field_146125_m = this.page == 3;
    }

    private static interface IProperty {
        public void increaseValue(int var1);

        public void decreaseValue(int var1);

        public short getSyncValue();

        public void createButtons(List<GuiButton> var1, int var2, int var3, int var4);

        public void updateButtons(int var1);

        public void drawLabel(FontRenderer var1, int var2, int var3);
    }

    private static class IntegerProperty
    implements IProperty {
        private final int page;
        private final String label;
        private final int minimumValue;
        private final int maximumValue;
        private int value;
        private GuiButton increaseButton;
        private GuiButton decreaseButton;

        public IntegerProperty(int page, String label, int value, int minimumValue, int maximumValue) {
            this.page = page;
            this.label = StatCollector.func_74838_a((String)("gui.de.particleGenerator." + label));
            this.value = value;
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
        }

        @Override
        public void increaseValue(int amount) {
            this.value = Math.min(this.value + amount, this.maximumValue);
        }

        @Override
        public void decreaseValue(int amount) {
            this.value = Math.max(this.value - amount, this.minimumValue);
        }

        @Override
        public short getSyncValue() {
            return (short)this.value;
        }

        @Override
        public void createButtons(List<GuiButton> buttons, int x, int y, int propertyId) {
            this.increaseButton = new GuiButton(propertyId * 2, x, y, 20, 20, "+");
            buttons.add(this.increaseButton);
            this.decreaseButton = new GuiButton(propertyId * 2 + 1, x + 71, y, 20, 20, "-");
            buttons.add(this.decreaseButton);
        }

        @Override
        public void updateButtons(int page) {
            this.increaseButton.field_146125_m = this.page == page;
            this.decreaseButton.field_146125_m = this.page == page;
        }

        @Override
        public void drawLabel(FontRenderer fontRenderer, int x, int y) {
            fontRenderer.func_78276_b(this.label, x, y, 0);
            fontRenderer.func_78276_b(String.valueOf(this.value), x, y + 10, 0);
        }
    }

    private static class FloatProperty
    implements IProperty {
        private final int page;
        private final String label;
        private final float minimumValue;
        private final float maximumValue;
        private final float scale;
        private float value;
        private GuiButton increaseButton;
        private GuiButton decreaseButton;

        public FloatProperty(int page, String label, float value, float minimumValue, float maximumValue, float scale) {
            this.page = page;
            this.label = StatCollector.func_74838_a((String)("gui.de.particleGenerator." + label));
            this.value = value;
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
            this.scale = scale;
        }

        @Override
        public void increaseValue(int amount) {
            this.value = Math.min(this.value + (float)amount / this.scale, this.maximumValue);
        }

        @Override
        public void decreaseValue(int amount) {
            this.value = Math.max(this.value - (float)amount / this.scale, this.minimumValue);
        }

        @Override
        public short getSyncValue() {
            return (short)(this.value * this.scale);
        }

        @Override
        public void createButtons(List<GuiButton> buttons, int x, int y, int propertyId) {
            this.increaseButton = new GuiButton(propertyId * 2, x, y, 20, 20, "+");
            buttons.add(this.increaseButton);
            this.decreaseButton = new GuiButton(propertyId * 2 + 1, x + 71, y, 20, 20, "-");
            buttons.add(this.decreaseButton);
        }

        @Override
        public void updateButtons(int page) {
            this.increaseButton.field_146125_m = this.page == page;
            this.decreaseButton.field_146125_m = this.page == page;
        }

        @Override
        public void drawLabel(FontRenderer fontRenderer, int x, int y) {
            float roundedValue = (float)Math.round(this.value * this.scale) / this.scale;
            fontRenderer.func_78276_b(this.label, x, y, 0);
            fontRenderer.func_78276_b(String.valueOf(roundedValue), x, y + 10, 0);
        }
    }
}

